/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Keys;

public class HtmlUnitKeyboardMapping {
    private static final Map<Character, Integer> specialKeysMap = new HashMap<Character, Integer>();

    private static void addMapping(Keys keys, int value) {
        specialKeysMap.put(Character.valueOf(keys.charAt(0)), value);
    }

    static boolean isSpecialKey(char ch) {
        return ch >= '\ue000' && ch <= '\uf8ff';
    }

    static int getKeysMapping(char ch) {
        Integer i = specialKeysMap.get(Character.valueOf(ch));
        if (i == null) {
            return 0;
        }
        return i;
    }

    static {
        HtmlUnitKeyboardMapping.addMapping(Keys.CANCEL, 3);
        HtmlUnitKeyboardMapping.addMapping(Keys.HELP, 6);
        HtmlUnitKeyboardMapping.addMapping(Keys.BACK_SPACE, 8);
        HtmlUnitKeyboardMapping.addMapping(Keys.TAB, 9);
        HtmlUnitKeyboardMapping.addMapping(Keys.CLEAR, 12);
        HtmlUnitKeyboardMapping.addMapping(Keys.RETURN, 13);
        HtmlUnitKeyboardMapping.addMapping(Keys.ENTER, 13);
        HtmlUnitKeyboardMapping.addMapping(Keys.SHIFT, 16);
        HtmlUnitKeyboardMapping.addMapping(Keys.LEFT_SHIFT, 16);
        HtmlUnitKeyboardMapping.addMapping(Keys.CONTROL, 17);
        HtmlUnitKeyboardMapping.addMapping(Keys.LEFT_CONTROL, 17);
        HtmlUnitKeyboardMapping.addMapping(Keys.ALT, 18);
        HtmlUnitKeyboardMapping.addMapping(Keys.LEFT_ALT, 18);
        HtmlUnitKeyboardMapping.addMapping(Keys.PAUSE, 19);
        HtmlUnitKeyboardMapping.addMapping(Keys.ESCAPE, 27);
        HtmlUnitKeyboardMapping.addMapping(Keys.SPACE, 32);
        HtmlUnitKeyboardMapping.addMapping(Keys.PAGE_UP, 33);
        HtmlUnitKeyboardMapping.addMapping(Keys.PAGE_DOWN, 34);
        HtmlUnitKeyboardMapping.addMapping(Keys.END, 35);
        HtmlUnitKeyboardMapping.addMapping(Keys.HOME, 36);
        HtmlUnitKeyboardMapping.addMapping(Keys.LEFT, 37);
        HtmlUnitKeyboardMapping.addMapping(Keys.ARROW_LEFT, 37);
        HtmlUnitKeyboardMapping.addMapping(Keys.UP, 38);
        HtmlUnitKeyboardMapping.addMapping(Keys.ARROW_UP, 38);
        HtmlUnitKeyboardMapping.addMapping(Keys.RIGHT, 39);
        HtmlUnitKeyboardMapping.addMapping(Keys.ARROW_RIGHT, 39);
        HtmlUnitKeyboardMapping.addMapping(Keys.DOWN, 12);
        HtmlUnitKeyboardMapping.addMapping(Keys.ARROW_DOWN, 40);
        HtmlUnitKeyboardMapping.addMapping(Keys.INSERT, 45);
        HtmlUnitKeyboardMapping.addMapping(Keys.DELETE, 46);
        HtmlUnitKeyboardMapping.addMapping(Keys.SEMICOLON, 59);
        HtmlUnitKeyboardMapping.addMapping(Keys.EQUALS, 61);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD0, 96);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD1, 97);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD2, 98);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD3, 99);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD4, 100);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD5, 101);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD6, 102);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD7, 103);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD8, 104);
        HtmlUnitKeyboardMapping.addMapping(Keys.NUMPAD9, 105);
        HtmlUnitKeyboardMapping.addMapping(Keys.MULTIPLY, 106);
        HtmlUnitKeyboardMapping.addMapping(Keys.ADD, 107);
        HtmlUnitKeyboardMapping.addMapping(Keys.SEPARATOR, 108);
        HtmlUnitKeyboardMapping.addMapping(Keys.SUBTRACT, 109);
        HtmlUnitKeyboardMapping.addMapping(Keys.DECIMAL, 110);
        HtmlUnitKeyboardMapping.addMapping(Keys.DIVIDE, 111);
        HtmlUnitKeyboardMapping.addMapping(Keys.F1, 112);
        HtmlUnitKeyboardMapping.addMapping(Keys.F2, 113);
        HtmlUnitKeyboardMapping.addMapping(Keys.F3, 114);
        HtmlUnitKeyboardMapping.addMapping(Keys.F4, 115);
        HtmlUnitKeyboardMapping.addMapping(Keys.F5, 116);
        HtmlUnitKeyboardMapping.addMapping(Keys.F6, 117);
        HtmlUnitKeyboardMapping.addMapping(Keys.F7, 118);
        HtmlUnitKeyboardMapping.addMapping(Keys.F8, 119);
        HtmlUnitKeyboardMapping.addMapping(Keys.F9, 120);
        HtmlUnitKeyboardMapping.addMapping(Keys.F10, 121);
        HtmlUnitKeyboardMapping.addMapping(Keys.F11, 122);
        HtmlUnitKeyboardMapping.addMapping(Keys.F12, 123);
        HtmlUnitKeyboardMapping.addMapping(Keys.META, 224);
    }
}

