/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.Version;
import com.gargoylesoftware.htmlunit.WaitingRefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLHandshakeException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.IdScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.htmlunit.AsyncScriptExecutor;
import org.openqa.selenium.htmlunit.BrowserVersionDeterminer;
import org.openqa.selenium.htmlunit.HtmlUnitAlert;
import org.openqa.selenium.htmlunit.HtmlUnitElementFinder;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.htmlunit.HtmlUnitMouse;
import org.openqa.selenium.htmlunit.HtmlUnitOptions;
import org.openqa.selenium.htmlunit.HtmlUnitTargetLocator;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.HtmlUnitWindow;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.remote.DesiredCapabilities;

public class HtmlUnitDriver
implements WebDriver,
JavascriptExecutor,
HasCapabilities,
HasInputDevices {
    private static final int sleepTime = 200;
    private WebClient webClient;
    private final HtmlUnitAlert alert;
    private final HtmlUnitWindow windowManager;
    private HtmlUnitKeyboard keyboard;
    private HtmlUnitMouse mouse;
    private boolean gotPage;
    private final WebDriver.TargetLocator targetLocator;
    private AsyncScriptExecutor asyncScriptExecutor;
    private PageLoadStrategy pageLoadStrategy = PageLoadStrategy.NORMAL;
    private final ElementsMap elementsMap = new ElementsMap();
    private final WebDriver.Options options;
    private final HtmlUnitElementFinder elementFinder;
    public static final String INVALIDXPATHERROR = "The xpath expression '%s' cannot be evaluated";
    public static final String INVALIDSELECTIONERROR = "The xpath expression '%s' selected an object of type '%s' instead of a WebElement";
    public static final String BROWSER_LANGUAGE_CAPABILITY = "browserLanguage";
    public static final String DOWNLOAD_IMAGES_CAPABILITY = "downloadImages";
    public static final String JAVASCRIPT_ENABLED = "javascriptEnabled";
    private final Lock conditionLock = new ReentrantLock();
    private final Condition mainCondition = this.conditionLock.newCondition();
    private boolean runAsyncRunning;
    private RuntimeException exception;
    private final ExecutorService defaultExecutor;
    private Executor executor;

    public HtmlUnitDriver() {
        this(BrowserVersion.getDefault(), false);
    }

    public HtmlUnitDriver(BrowserVersion version) {
        this(version, false);
    }

    public HtmlUnitDriver(boolean enableJavascript) {
        this(BrowserVersion.getDefault(), enableJavascript);
    }

    public HtmlUnitDriver(BrowserVersion version, boolean enableJavascript) {
        this(version, enableJavascript, null);
        this.modifyWebClient(this.webClient);
    }

    public HtmlUnitDriver(Capabilities capabilities) {
        this(BrowserVersionDeterminer.determine(capabilities), capabilities.getCapability(JAVASCRIPT_ENABLED) == null || capabilities.is(JAVASCRIPT_ENABLED), Proxy.extractFrom((Capabilities)capabilities));
        Boolean acceptSslCerts;
        this.setDownloadImages(capabilities.is(DOWNLOAD_IMAGES_CAPABILITY));
        if (this.alert != null) {
            this.alert.handleBrowserCapabilities(capabilities);
        }
        if ((acceptSslCerts = (Boolean)capabilities.getCapability("acceptSslCerts")) == null) {
            acceptSslCerts = true;
        }
        this.setAcceptSslCertificates(acceptSslCerts);
        String pageLoadStrategyString = (String)capabilities.getCapability("pageLoadStrategy");
        if ("none".equals(pageLoadStrategyString)) {
            this.pageLoadStrategy = PageLoadStrategy.NONE;
        } else if ("eager".equals(pageLoadStrategyString)) {
            this.pageLoadStrategy = PageLoadStrategy.EAGER;
        }
        this.modifyWebClient(this.webClient);
    }

    public HtmlUnitDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this((Capabilities)new DesiredCapabilities(new Capabilities[]{desiredCapabilities, requiredCapabilities}));
    }

    private HtmlUnitDriver(BrowserVersion version, boolean enableJavascript, Proxy proxy) {
        this.webClient = this.newWebClient(version);
        WebClientOptions clientOptions = this.webClient.getOptions();
        clientOptions.setHomePage(UrlUtils.URL_ABOUT_BLANK.toString());
        clientOptions.setThrowExceptionOnFailingStatusCode(false);
        clientOptions.setPrintContentOnFailingStatusCode(false);
        clientOptions.setRedirectEnabled(true);
        clientOptions.setUseInsecureSSL(true);
        this.setJavascriptEnabled(enableJavascript);
        this.setProxySettings(proxy);
        this.webClient.setRefreshHandler((RefreshHandler)new WaitingRefreshHandler());
        this.elementFinder = new HtmlUnitElementFinder();
        this.alert = new HtmlUnitAlert(this);
        this.windowManager = new HtmlUnitWindow(this);
        this.defaultExecutor = Executors.newCachedThreadPool();
        this.executor = this.defaultExecutor;
        this.get(clientOptions.getHomePage());
        this.gotPage = false;
        this.options = new HtmlUnitOptions(this);
        this.targetLocator = new HtmlUnitTargetLocator(this);
        this.resetKeyboardAndMouseState();
    }

    boolean isProcessAlert() {
        if (this.asyncScriptExecutor != null) {
            String text = this.alert.getText();
            this.alert.dismiss();
            this.asyncScriptExecutor.alertTriggered(text);
            return false;
        }
        this.conditionLock.lock();
        this.mainCondition.signal();
        this.conditionLock.unlock();
        return true;
    }

    protected void runAsync(Runnable r) {
        boolean loadStrategyWait;
        boolean bl = loadStrategyWait = this.pageLoadStrategy != PageLoadStrategy.NONE;
        if (loadStrategyWait) {
            while (this.runAsyncRunning) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.conditionLock.lock();
            this.runAsyncRunning = true;
        }
        this.exception = null;
        Runnable wrapped = () -> {
            try {
                r.run();
            }
            catch (RuntimeException e) {
                this.exception = e;
            }
            finally {
                this.conditionLock.lock();
                this.runAsyncRunning = false;
                this.mainCondition.signal();
                this.conditionLock.unlock();
            }
        };
        this.executor.execute(wrapped);
        if (loadStrategyWait && this.runAsyncRunning) {
            this.mainCondition.awaitUninterruptibly();
            this.conditionLock.unlock();
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void click(DomElement element, boolean directClick) {
        this.runAsync(() -> this.mouse.click(element, directClick));
    }

    public void doubleClick(DomElement element) {
        this.runAsync(() -> this.mouse.doubleClick(element));
    }

    public void mouseUp(DomElement element) {
        this.runAsync(() -> this.mouse.mouseUp(element));
    }

    public void mouseMove(DomElement element) {
        this.runAsync(() -> this.mouse.mouseMove(element));
    }

    public void mouseDown(DomElement element) {
        this.runAsync(() -> this.mouse.mouseDown(element));
    }

    public void submit(HtmlUnitWebElement element) {
        this.runAsync(element::submitImpl);
    }

    public void sendKeys(HtmlUnitWebElement element, CharSequence ... value) {
        this.runAsync(() -> this.keyboard.sendKeys(element, true, value));
    }

    public BrowserVersion getBrowserVersion() {
        return this.webClient.getBrowserVersion();
    }

    protected WebClient newWebClient(BrowserVersion version) {
        return new WebClient(version);
    }

    protected WebClient modifyWebClient(WebClient client) {
        return client;
    }

    public HtmlUnitWindow getWindowManager() {
        return this.windowManager;
    }

    public HtmlUnitAlert getAlert() {
        return this.alert;
    }

    public ElementsMap getElementsMap() {
        return this.elementsMap;
    }

    public void setCurrentWindow(WebWindow window) {
        this.getWebClient().setCurrentWindow(window);
    }

    public void setProxySettings(Proxy proxy) {
        if (proxy == null || proxy.getProxyType() == Proxy.ProxyType.UNSPECIFIED) {
            return;
        }
        switch (proxy.getProxyType()) {
            case MANUAL: {
                String socksProxy;
                String httpProxy;
                ArrayList<String> noProxyHosts = new ArrayList<String>();
                String noProxy = proxy.getNoProxy();
                if (noProxy != null && !noProxy.isEmpty()) {
                    String[] hosts;
                    for (String host : hosts = noProxy.split(",")) {
                        if (host.trim().length() <= 0) continue;
                        noProxyHosts.add(host.trim());
                    }
                }
                if ((httpProxy = proxy.getHttpProxy()) != null && !httpProxy.isEmpty()) {
                    String host = httpProxy;
                    int port = 0;
                    int index = httpProxy.indexOf(":");
                    if (index != -1) {
                        host = httpProxy.substring(0, index);
                        port = Integer.parseInt(httpProxy.substring(index + 1));
                    }
                    this.setHTTPProxy(host, port, noProxyHosts);
                }
                if ((socksProxy = proxy.getSocksProxy()) == null || socksProxy.isEmpty()) break;
                String host = socksProxy;
                int port = 0;
                int index = socksProxy.indexOf(":");
                if (index != -1) {
                    host = socksProxy.substring(0, index);
                    port = Integer.parseInt(socksProxy.substring(index + 1));
                }
                this.setSocksProxy(host, port, noProxyHosts);
                break;
            }
            case PAC: {
                String pac = proxy.getProxyAutoconfigUrl();
                if (pac == null || pac.isEmpty()) break;
                this.setAutoProxy(pac);
                break;
            }
        }
    }

    public void setProxy(String host, int port) {
        this.setHTTPProxy(host, port, null);
    }

    public void setHTTPProxy(String host, int port, List<String> noProxyHosts) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyHost(host);
        proxyConfig.setProxyPort(port);
        if (noProxyHosts != null && noProxyHosts.size() > 0) {
            for (String noProxyHost : noProxyHosts) {
                proxyConfig.addHostsToProxyBypass(noProxyHost);
            }
        }
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public void setSocksProxy(String host, int port) {
        this.setSocksProxy(host, port, null);
    }

    public void setSocksProxy(String host, int port, List<String> noProxyHosts) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyHost(host);
        proxyConfig.setProxyPort(port);
        proxyConfig.setSocksProxy(true);
        if (noProxyHosts != null && noProxyHosts.size() > 0) {
            for (String noProxyHost : noProxyHosts) {
                proxyConfig.addHostsToProxyBypass(noProxyHost);
            }
        }
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public void setExecutor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        this.executor = executor;
    }

    public void setAutoProxy(String autoProxyUrl) {
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.setProxyAutoConfigUrl(autoProxyUrl);
        this.getWebClient().getOptions().setProxyConfig(proxyConfig);
    }

    public Capabilities getCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.setPlatform(Platform.getCurrent());
        capabilities.setJavascriptEnabled(this.isJavascriptEnabled());
        capabilities.setVersion(Version.getProductVersion());
        return capabilities;
    }

    public void get(String url) {
        URL fullUrl;
        try {
            fullUrl = UrlUtils.toUrlUnsafe((String)url);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.runAsync(() -> this.get(fullUrl));
    }

    protected void get(URL fullUrl) {
        this.getAlert().close();
        this.getAlert().setAutoAccept(false);
        try {
            BrowserVersion browser = this.getBrowserVersion();
            WebRequest request = new WebRequest(fullUrl, browser.getHtmlAcceptHeader(), browser.getAcceptEncodingHeader());
            request.setCharset(StandardCharsets.UTF_8);
            this.getWebClient().getPage(this.getCurrentWindow().getTopWindow(), request);
            this.setCurrentWindow(this.getCurrentWindow().getTopWindow());
        }
        catch (UnknownHostException e) {
            this.getCurrentWindow().getTopWindow().setEnclosedPage((Page)new UnexpectedPage((WebResponse)new StringWebResponse("Unknown host", fullUrl), this.getCurrentWindow().getTopWindow()));
        }
        catch (ConnectException e) {
        }
        catch (SocketTimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
        catch (NoSuchSessionException e) {
            throw e;
        }
        catch (SSLHandshakeException e) {
            return;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.gotPage = true;
        this.resetKeyboardAndMouseState();
    }

    private void resetKeyboardAndMouseState() {
        this.keyboard = new HtmlUnitKeyboard(this);
        this.mouse = new HtmlUnitMouse(this, this.keyboard);
    }

    public String getCurrentUrl() {
        this.getWebClient();
        Page page = this.getCurrentWindow().getTopWindow().getEnclosedPage();
        if (page == null) {
            return null;
        }
        URL url = page.getUrl();
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    public String getTitle() {
        this.alert.ensureUnlocked();
        Page page = this.getWindowManager().lastPage();
        if (!(page instanceof HtmlPage)) {
            return null;
        }
        if (this.getCurrentWindow() instanceof FrameWindow) {
            page = this.getCurrentWindow().getTopWindow().getEnclosedPage();
        }
        return ((HtmlPage)page).getTitleText();
    }

    public WebElement findElement(By by) {
        this.alert.ensureUnlocked();
        return this.implicitlyWaitFor(() -> this.elementFinder.findElement(this, by));
    }

    public List<WebElement> findElements(By by) {
        List<WebElement> found;
        long implicitWait = this.options.timeouts().getImplicitWaitTimeout().toMillis();
        if (implicitWait < 200L) {
            return this.elementFinder.findElements(this, by);
        }
        long end = System.currentTimeMillis() + implicitWait;
        do {
            if (!(found = this.elementFinder.findElements(this, by)).isEmpty()) {
                return found;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        return found;
    }

    public WebElement findElement(HtmlUnitWebElement element, By by) {
        this.alert.ensureUnlocked();
        return this.implicitlyWaitFor(() -> this.elementFinder.findElement(element, by));
    }

    public List<WebElement> findElements(HtmlUnitWebElement element, By by) {
        List<WebElement> found;
        long implicitWait = this.options.timeouts().getImplicitWaitTimeout().toMillis();
        if (implicitWait < 200L) {
            return this.elementFinder.findElements(element, by);
        }
        long end = System.currentTimeMillis() + implicitWait;
        do {
            if (!(found = this.elementFinder.findElements(element, by)).isEmpty()) {
                return found;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        return found;
    }

    public String getPageSource() {
        Page page = this.windowManager.lastPage();
        if (page == null) {
            return null;
        }
        if (page instanceof SgmlPage) {
            return ((SgmlPage)page).asXml();
        }
        WebResponse response = page.getWebResponse();
        return response.getContentAsString();
    }

    public void close() {
        this.getWebClient();
        if (this.getWebClient().getWebWindows().size() == 1) {
            this.quit();
        } else {
            WebWindow thisWindow = this.getCurrentWindow();
            if (thisWindow != null) {
                this.alert.close();
                ((TopLevelWindow)thisWindow.getTopWindow()).close();
            }
            if (this.getWebClient().getWebWindows().size() == 0) {
                this.quit();
            }
        }
    }

    public void quit() {
        if (this.webClient != null) {
            this.alert.close();
            this.webClient.close();
            this.webClient = null;
        }
        this.defaultExecutor.shutdown();
    }

    public Set<String> getWindowHandles() {
        HashSet allHandles = Sets.newHashSet();
        for (WebWindow window : this.getWebClient().getTopLevelWindows()) {
            allHandles.add(String.valueOf(System.identityHashCode(window)));
        }
        return allHandles;
    }

    public String getWindowHandle() {
        WebWindow topWindow = this.getCurrentWindow().getTopWindow();
        if (topWindow.isClosed()) {
            throw new NoSuchWindowException("Window is closed");
        }
        return String.valueOf(System.identityHashCode(topWindow));
    }

    public Object executeScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        script = "function() {" + script + "\n};";
        ScriptResult result = page.executeJavaScript(script);
        Object function = result.getJavaScriptResult();
        Object[] parameters = this.convertScriptArgs(page, args);
        try {
            result = page.executeJavaScriptFunction(function, this.getCurrentWindow().getScriptableObject(), parameters, (DomNode)page.getDocumentElement());
            return this.parseNativeJavascriptResult(result);
        }
        catch (Throwable ex) {
            throw new WebDriverException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeAsyncScript(String script, Object ... args) {
        HtmlPage page = this.getPageToInjectScriptInto();
        args = this.convertScriptArgs(page, args);
        this.asyncScriptExecutor = new AsyncScriptExecutor(page, this.options.timeouts().getScriptTimeout().toMillis());
        try {
            Object result = this.asyncScriptExecutor.execute(script, args);
            this.alert.ensureUnlocked();
            Object object = this.parseNativeJavascriptResult(result);
            return object;
        }
        finally {
            this.asyncScriptExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] convertScriptArgs(HtmlPage page, Object[] args) {
        Object scope = page.getEnclosingWindow().getScriptableObject();
        if (!(scope instanceof Scriptable)) {
            return args;
        }
        Object[] parameters = new Object[args.length];
        Context.enter();
        try {
            for (int i = 0; i < args.length; ++i) {
                parameters[i] = this.parseArgumentIntoJavascriptParameter((Scriptable)scope, args[i]);
            }
        }
        finally {
            Context.exit();
        }
        return parameters;
    }

    private HtmlPage getPageToInjectScriptInto() {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("Javascript is not enabled for this HtmlUnitDriver instance");
        }
        Page lastPage = this.windowManager.lastPage();
        if (!(lastPage instanceof HtmlPage)) {
            throw new UnsupportedOperationException("Cannot execute JS against a plain text page");
        }
        if (!this.gotPage) {
            throw new WebDriverException("Can't execute JavaScript before a page has been loaded!");
        }
        return (HtmlPage)lastPage;
    }

    private Object parseArgumentIntoJavascriptParameter(Scriptable scope, Object arg) {
        while (arg instanceof WrapsElement) {
            arg = ((WrapsElement)arg).getWrappedElement();
        }
        if (!(arg instanceof HtmlUnitWebElement || arg instanceof HtmlElement || arg instanceof Number || arg instanceof String || arg instanceof Boolean || arg.getClass().isArray() || arg instanceof Collection || arg instanceof Map)) {
            throw new IllegalArgumentException("Argument must be a string, number, boolean or WebElement: " + arg + " (" + arg.getClass() + ")");
        }
        if (arg instanceof HtmlUnitWebElement) {
            HtmlUnitWebElement webElement = (HtmlUnitWebElement)arg;
            this.assertElementNotStale(webElement.getElement());
            return webElement.getElement().getScriptableObject();
        }
        if (arg instanceof HtmlElement) {
            HtmlElement element = (HtmlElement)arg;
            this.assertElementNotStale((DomElement)element);
            return element.getScriptableObject();
        }
        if (arg instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Collection)arg) {
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Object[])arg) {
                list.add(this.parseArgumentIntoJavascriptParameter(scope, o));
            }
            return Context.getCurrentContext().newArray(scope, list.toArray());
        }
        if (arg instanceof Map) {
            Map argmap = (Map)arg;
            Scriptable map = Context.getCurrentContext().newObject(scope);
            for (Object key : argmap.keySet()) {
                map.put((String)key, map, this.parseArgumentIntoJavascriptParameter(scope, argmap.get(key)));
            }
            return map;
        }
        return arg;
    }

    protected void assertElementNotStale(DomElement element) {
        DomElement parentElement;
        SgmlPage elementPage = element.getPage();
        Page lastPage = this.windowManager.lastPage();
        if (!lastPage.equals(elementPage)) {
            throw new StaleElementReferenceException("Element appears to be stale. Did you navigate away from the page that contained it?  And is the current window focussed the same as the one holding this element?");
        }
        for (parentElement = element; parentElement != null && !(parentElement instanceof SgmlPage); parentElement = parentElement.getParentNode()) {
        }
        if (parentElement == null) {
            throw new StaleElementReferenceException("The element seems to be disconnected from the DOM.  This means that a user cannot interact with it.");
        }
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    private Object parseNativeJavascriptResult(Object result) {
        Object value = result instanceof ScriptResult ? ((ScriptResult)result).getJavaScriptResult() : result;
        if (value instanceof HTMLElement) {
            return this.toWebElement((DomElement)((HTMLElement)value).getDomNodeOrDie());
        }
        if (value instanceof DocumentProxy) {
            Element element = ((DocumentProxy)value).getDelegee().getDocumentElement();
            if (element instanceof HTMLElement) {
                return this.toWebElement((DomElement)((HTMLElement)element).getDomNodeOrDie());
            }
            throw new WebDriverException("Do not know how to coerce to an HTMLElement: " + element);
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            String s = n.toString();
            if (!s.contains(".") || s.endsWith(".0")) {
                return n.longValue();
            }
            return n.doubleValue();
        }
        if (value instanceof NativeObject) {
            HashMap map = Maps.newHashMap((Map)((NativeObject)value));
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(this.parseNativeJavascriptResult(entry.getValue()));
            }
            return map;
        }
        if (value instanceof Location) {
            return HtmlUnitDriver.convertLocationToMap((Location)value);
        }
        if (value instanceof NativeArray) {
            final NativeArray array = (NativeArray)value;
            JavaScriptResultsCollection collection = new JavaScriptResultsCollection(){

                @Override
                public int getLength() {
                    return (int)array.getLength();
                }

                @Override
                public Object item(int index) {
                    return array.get(index);
                }
            };
            return this.parseJavascriptResultsList(collection);
        }
        if (value instanceof HTMLCollection) {
            final HTMLCollection array = (HTMLCollection)value;
            JavaScriptResultsCollection collection = new JavaScriptResultsCollection(){

                @Override
                public int getLength() {
                    return array.getLength();
                }

                @Override
                public Object item(int index) {
                    return array.get((Object)index);
                }
            };
            return this.parseJavascriptResultsList(collection);
        }
        if (value instanceof IdScriptableObject && value.getClass().getSimpleName().equals("NativeDate")) {
            long l = ((Number)HtmlUnitDriver.getPrivateField(value, "date")).longValue();
            return Instant.ofEpochMilli(l).toString();
        }
        if (value instanceof Undefined) {
            return null;
        }
        return value;
    }

    private static Object getPrivateField(Object o, String fieldName) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> convertLocationToMap(Location location) {
        HashMap map = Maps.newHashMap();
        map.put("href", location.getHref());
        map.put("protocol", location.getProtocol());
        map.put("host", location.getHost());
        map.put("hostname", location.getHostname());
        map.put("port", location.getPort());
        map.put("pathname", location.getPathname());
        map.put("search", location.getSearch());
        map.put("hash", location.getHash());
        map.put("href", location.getHref());
        return map;
    }

    private List<Object> parseJavascriptResultsList(JavaScriptResultsCollection array) {
        ArrayList<Object> list = new ArrayList<Object>(array.getLength());
        for (int i = 0; i < array.getLength(); ++i) {
            list.add(this.parseNativeJavascriptResult(array.item(i)));
        }
        return list;
    }

    public WebDriver.TargetLocator switchTo() {
        return this.targetLocator;
    }

    public WebDriver.Navigation navigate() {
        return new HtmlUnitNavigation();
    }

    protected HtmlUnitWebElement toWebElement(DomElement element) {
        return this.getElementsMap().addIfAbsent(this, element);
    }

    public boolean isJavascriptEnabled() {
        return this.getWebClient().getOptions().isJavaScriptEnabled();
    }

    public void setJavascriptEnabled(boolean enableJavascript) {
        this.getWebClient().getOptions().setJavaScriptEnabled(enableJavascript);
    }

    public boolean isDownloadImages() {
        return this.getWebClient().getOptions().isDownloadImages();
    }

    public void setDownloadImages(boolean downloadImages) {
        this.getWebClient().getOptions().setDownloadImages(downloadImages);
    }

    public void setAcceptSslCertificates(boolean accept) {
        this.getWebClient().getOptions().setUseInsecureSSL(accept);
    }

    public boolean isAcceptSslCertificates() {
        return this.getWebClient().getOptions().isUseInsecureSSL();
    }

    protected <X> X implicitlyWaitFor(Callable<X> condition) {
        long implicitWait = this.options.timeouts().getImplicitWaitTimeout().toMillis();
        if (implicitWait < 200L) {
            try {
                return condition.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        long end = System.currentTimeMillis() + implicitWait;
        Exception lastException = null;
        do {
            X toReturn = null;
            try {
                toReturn = condition.call();
            }
            catch (Exception e) {
                lastException = e;
            }
            if (toReturn instanceof Boolean && !((Boolean)toReturn).booleanValue()) continue;
            if (toReturn != null) {
                return toReturn;
            }
            HtmlUnitDriver.sleepQuietly(200L);
        } while (System.currentTimeMillis() < end);
        if (lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new WebDriverException((Throwable)lastException);
        }
        return null;
    }

    protected WebClient getWebClient() {
        if (this.webClient == null) {
            throw new NoSuchSessionException("Session is closed");
        }
        return this.webClient;
    }

    protected WebWindow getCurrentWindow() {
        WebWindow currentWindow = this.getWebClient().getCurrentWindow();
        if (currentWindow == null || currentWindow.isClosed()) {
            throw new NoSuchWindowException("Window is closed");
        }
        return currentWindow;
    }

    public WebDriver.Options manage() {
        return this.options;
    }

    private static void sleepQuietly(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static class ElementsMap {
        private final Map<SgmlPage, Map<DomElement, HtmlUnitWebElement>> elementsMap = new WeakHashMap<SgmlPage, Map<DomElement, HtmlUnitWebElement>>();
        private int idCounter = 0;

        public HtmlUnitWebElement addIfAbsent(HtmlUnitDriver driver, DomElement element) {
            Map pageMap = this.elementsMap.computeIfAbsent(element.getPage(), k -> new HashMap());
            HtmlUnitWebElement e = (HtmlUnitWebElement)pageMap.get(element);
            if (e == null) {
                ++this.idCounter;
                e = new HtmlUnitWebElement(driver, this.idCounter, element);
                pageMap.put(element, e);
            }
            return e;
        }

        public void remove(Page page) {
            this.elementsMap.remove(page);
        }
    }

    private static enum PageLoadStrategy {
        NORMAL,
        EAGER,
        NONE;

    }

    private class HtmlUnitNavigation
    implements WebDriver.Navigation {
        private HtmlUnitNavigation() {
        }

        public void back() {
            HtmlUnitDriver.this.runAsync(() -> {
                try {
                    HtmlUnitDriver.this.getCurrentWindow().getHistory().back();
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            });
        }

        public void forward() {
            HtmlUnitDriver.this.runAsync(() -> {
                try {
                    HtmlUnitDriver.this.getCurrentWindow().getHistory().forward();
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            });
        }

        public void to(String url) {
            HtmlUnitDriver.this.get(url);
        }

        public void to(URL url) {
            HtmlUnitDriver.this.get(url);
        }

        public void refresh() {
            if (HtmlUnitDriver.this.windowManager.lastPage() instanceof HtmlPage) {
                HtmlUnitDriver.this.runAsync(() -> {
                    try {
                        ((HtmlPage)HtmlUnitDriver.this.windowManager.lastPage()).refresh();
                    }
                    catch (SocketTimeoutException e) {
                        throw new TimeoutException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new WebDriverException((Throwable)e);
                    }
                });
            }
        }
    }

    protected static interface JavaScriptResultsCollection {
        public int getLength();

        public Object item(int var1);
    }
}

