/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.Browser;

public class BrowserVersionDeterminer {
    protected static final List<BrowserInfo> browsers = new ArrayList<BrowserInfo>();

    public static BrowserVersion determine(Capabilities capabilities) {
        String browserVersion;
        String browserName;
        String[] splitVersion;
        if (!Browser.HTMLUNIT.is(capabilities)) {
            throw new IllegalArgumentException("When building an HtmlUntDriver, the capability browser name must be set to '" + Browser.HTMLUNIT.browserName() + "' but was '" + capabilities.getBrowserName() + "'.");
        }
        String rawVersion = capabilities.getBrowserVersion();
        String[] stringArray = splitVersion = rawVersion == null ? new String[]{} : rawVersion.split("-");
        if (splitVersion.length > 1) {
            browserName = splitVersion[0];
            browserVersion = splitVersion[1];
        } else {
            browserName = capabilities.getBrowserVersion();
            browserVersion = null;
        }
        if (browserName == null) {
            return BrowserVersion.getDefault();
        }
        BrowserVersion result = browsers.stream().filter(Objects::nonNull).filter(item -> item.getBrowser().is(browserName)).findFirst().map(item -> item.getBrowserVersion(browserVersion)).orElse(BrowserVersion.getDefault());
        Object rawLanguage = capabilities.getCapability("browserLanguage");
        if (rawLanguage instanceof String) {
            return new BrowserVersion.BrowserVersionBuilder(result).setBrowserLanguage((String)rawLanguage).build();
        }
        return result;
    }

    static {
        browsers.add(new Chrome());
        browsers.add(new Edge());
        browsers.add(new Firefox());
        browsers.add(new IE());
    }

    protected static class Firefox
    implements BrowserInfo {
        protected Firefox() {
        }

        @Override
        public Browser getBrowser() {
            return Browser.FIREFOX;
        }

        @Override
        public BrowserVersion getBrowserVersion() {
            return BrowserVersion.FIREFOX;
        }

        @Override
        public BrowserVersion getBrowserVersion(String versionNumeric) {
            try {
                int version = Integer.parseInt(versionNumeric);
                return BrowserVersion.FIREFOX_78.getBrowserVersionNumeric() == version ? BrowserVersion.FIREFOX_78 : BrowserVersion.FIREFOX;
            }
            catch (NumberFormatException e) {
                return BrowserVersion.FIREFOX;
            }
        }
    }

    protected static class IE
    implements BrowserInfo {
        protected IE() {
        }

        @Override
        public Browser getBrowser() {
            return Browser.IE;
        }

        @Override
        public BrowserVersion getBrowserVersion() {
            return BrowserVersion.INTERNET_EXPLORER;
        }
    }

    protected static class Edge
    implements BrowserInfo {
        protected Edge() {
        }

        @Override
        public Browser getBrowser() {
            return Browser.EDGE;
        }

        @Override
        public BrowserVersion getBrowserVersion() {
            return BrowserVersion.EDGE;
        }
    }

    protected static class Chrome
    implements BrowserInfo {
        protected Chrome() {
        }

        @Override
        public Browser getBrowser() {
            return Browser.CHROME;
        }

        @Override
        public BrowserVersion getBrowserVersion() {
            return BrowserVersion.CHROME;
        }
    }

    protected static interface BrowserInfo {
        public Browser getBrowser();

        public BrowserVersion getBrowserVersion();

        default public BrowserVersion getBrowserVersion(String versionNumeric) {
            return this.getBrowserVersion();
        }
    }
}

