/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.UrlTemplate;

public class SpecificRoute
extends Route<SpecificRoute> {
    private final HttpMethod method;
    private final UrlTemplate template;
    private Function<Map<String, String>, CommandHandler> handlerFunc;

    SpecificRoute(HttpMethod method, String template) {
        this.method = Objects.requireNonNull(method);
        this.template = new UrlTemplate(Objects.requireNonNull(template));
    }

    public SpecificRoute using(Supplier<CommandHandler> handlerSupplier) {
        Objects.requireNonNull(handlerSupplier);
        this.handlerFunc = params -> (CommandHandler)handlerSupplier.get();
        return this;
    }

    public SpecificRoute using(Function<Map<String, String>, CommandHandler> handlerGenerator) {
        Objects.requireNonNull(handlerGenerator);
        this.handlerFunc = handlerGenerator;
        return this;
    }

    public SpecificRoute using(CommandHandler handlerInstance) {
        Objects.requireNonNull(handlerInstance);
        this.handlerFunc = params -> handlerInstance;
        return this;
    }

    @Override
    protected void validate() {
        if (this.handlerFunc == null) {
            throw new IllegalStateException("Handler for route is required");
        }
    }

    @Override
    protected CommandHandler newHandler(HttpRequest request) {
        if (request.getMethod() != this.method) {
            return this.getFallback();
        }
        UrlTemplate.Match match = this.template.match(request.getUri());
        if (match == null) {
            return this.getFallback();
        }
        Map params = match.getParameters();
        return this.handlerFunc.apply(params);
    }
}

