/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.net.MediaType;
import java.util.Objects;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.ErrorCodec;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class W3CCommandHandler
implements CommandHandler {
    public static final Json JSON = new Json();
    private final ErrorCodec errors = ErrorCodec.createDefault();
    private final CommandHandler delegate;

    public W3CCommandHandler(CommandHandler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) {
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Cache-Control", "none");
        try {
            this.delegate.execute(req, resp);
        }
        catch (Throwable cause) {
            resp.setStatus(this.errors.getHttpStatusCode(cause));
            resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
            resp.setHeader("Cache-Control", "none");
            resp.setContent(Contents.utf8String((CharSequence)JSON.toJson(this.errors.encode(cause))));
        }
    }
}

