/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;

public class ServletResponseWrappingHttpResponse
extends HttpResponse {
    private final HttpServletResponse resp;

    public ServletResponseWrappingHttpResponse(HttpServletResponse resp) {
        this.resp = (HttpServletResponse)Preconditions.checkNotNull((Object)resp, (Object)"Response to wrap must not be null");
    }

    public int getStatus() {
        return this.resp.getStatus();
    }

    public ServletResponseWrappingHttpResponse setStatus(int status) {
        this.resp.setStatus(status);
        return this;
    }

    public Iterable<String> getHeaderNames() {
        return this.resp.getHeaderNames();
    }

    public Iterable<String> getHeaders(String name) {
        return this.resp.getHeaders(name);
    }

    public String getHeader(String name) {
        return this.resp.getHeader(name);
    }

    public ServletResponseWrappingHttpResponse setHeader(String name, String value) {
        this.resp.setHeader(name, value);
        return this;
    }

    public ServletResponseWrappingHttpResponse addHeader(String name, String value) {
        this.resp.addHeader(name, value);
        return this;
    }

    public ServletResponseWrappingHttpResponse removeHeader(String name) {
        throw new UnsupportedOperationException("removeHeader");
    }

    public ServletResponseWrappingHttpResponse setContent(Supplier<InputStream> supplier) {
        byte[] bytes = Contents.bytes(supplier);
        this.resp.setContentLength(bytes.length);
        try (InputStream is = supplier.get();
             ServletOutputStream os = this.resp.getOutputStream();){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public Supplier<InputStream> getContent() {
        throw new UnsupportedOperationException("getContent");
    }
}

