/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.DistributedTracer;
import org.openqa.selenium.remote.tracing.Span;

class HandleSession
implements CommandHandler {
    private final LoadingCache<SessionId, CommandHandler> knownSessions;
    private final DistributedTracer tracer;

    public HandleSession(DistributedTracer tracer, final HttpClient.Factory httpClientFactory, final SessionMap sessions) {
        this.tracer = Objects.requireNonNull(tracer);
        Objects.requireNonNull(sessions);
        this.knownSessions = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).build((CacheLoader)new CacheLoader<SessionId, CommandHandler>(){

            public CommandHandler load(SessionId id) {
                Session session = sessions.get(id);
                if (session instanceof CommandHandler) {
                    return (CommandHandler)((Object)session);
                }
                HttpClient client = httpClientFactory.createClient(Urls.fromUri((URI)session.getUri()));
                return new ReverseProxyHandler(client);
            }
        });
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        try (Span span = this.tracer.createSpan("router.webdriver-command", this.tracer.getActiveSpan());){
            span.addTag("http.method", (Object)req.getMethod());
            span.addTag("http.url", (Object)req.getUri());
            SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + req));
            span.addTag("session.id", (Object)id);
            try {
                ((CommandHandler)this.knownSessions.get((Object)id)).execute(req, resp);
                span.addTag("http.status", (Number)resp.getStatus());
            }
            catch (ExecutionException e) {
                span.addTag("exception", (Object)e.getMessage());
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }
}

