/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.local;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class SessionSlot
implements CommandHandler,
Function<CreateSessionRequest, Optional<ActiveSession>>,
Predicate<Capabilities> {
    public static final Logger LOG = Logger.getLogger(SessionSlot.class.getName());
    private final EventBus bus;
    private final Capabilities stereotype;
    private final SessionFactory factory;
    private ActiveSession currentSession;

    public SessionSlot(EventBus bus, Capabilities stereotype, SessionFactory factory) {
        this.bus = Objects.requireNonNull(bus);
        this.stereotype = ImmutableCapabilities.copyOf((Capabilities)Objects.requireNonNull(stereotype));
        this.factory = Objects.requireNonNull(factory);
    }

    public Capabilities getStereotype() {
        return this.stereotype;
    }

    public boolean isAvailable() {
        return this.currentSession == null;
    }

    public ActiveSession getSession() {
        if (this.isAvailable()) {
            throw new NoSuchSessionException("Session is not running");
        }
        return this.currentSession;
    }

    public void stop() {
        if (this.isAvailable()) {
            return;
        }
        SessionId id = this.currentSession.getId();
        this.currentSession.stop();
        this.currentSession = null;
        this.bus.fire(new SessionClosedEvent(id));
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        if (this.currentSession == null) {
            throw new NoSuchSessionException("No session currently running: " + req.getUri());
        }
        this.currentSession.execute(req, resp);
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.factory.test(capabilities);
    }

    @Override
    public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        try {
            Optional possibleSession = (Optional)this.factory.apply(sessionRequest);
            possibleSession.ifPresent(session -> {
                this.currentSession = session;
            });
            return possibleSession;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to create session", e);
            return Optional.empty();
        }
    }
}

