/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class StatusHandler
implements CommandHandler {
    private final Node node;
    private final Json json;

    public StatusHandler(Node node, Json json) {
        this.node = Objects.requireNonNull(node);
        this.json = Objects.requireNonNull(json);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) {
        NodeStatus status = this.node.getStatus();
        ImmutableMap report = ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)status.hasCapacity(), (Object)"message", (Object)(status.hasCapacity() ? "Ready" : "No free slots available"), (Object)"node", (Object)status));
        resp.setContent(Contents.utf8String((CharSequence)this.json.toJson((Object)report)));
    }
}

