/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.distributor.local.Slot;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.remote.SessionId;

class Host {
    private static final Logger LOG = Logger.getLogger("Selenium Distributor");
    private final Node node;
    private final UUID nodeId;
    private final URI uri;
    private final Runnable performHealthCheck;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private Status status;
    private List<Slot> slots;
    private int maxSessionCount;

    public Host(EventBus bus, Node node) {
        this.node = Objects.requireNonNull(node);
        this.nodeId = node.getId();
        this.uri = node.getUri();
        this.status = Status.DOWN;
        this.slots = ImmutableList.of();
        HealthCheck healthCheck = node.getHealthCheck();
        this.performHealthCheck = () -> {
            HealthCheck.Result result = healthCheck.check();
            Status current = result.isAlive() ? Status.UP : Status.DOWN;
            Status previous = this.setHostStatus(current);
            if (previous == Status.DRAINING) {
                this.setHostStatus(Status.DRAINING);
                return;
            }
            if (current != previous) {
                LOG.info(String.format("Changing status of node %s from %s to %s. Reason: %s", new Object[]{node.getId(), previous, current, result.getMessage()}));
            }
        };
        bus.addListener(SessionClosedEvent.SESSION_CLOSED, event -> {
            SessionId id = (SessionId)event.getData((Type)((Object)SessionId.class));
            this.slots.forEach(slot -> slot.onEnd(id));
        });
        this.update(node.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(NodeStatus status) {
        Objects.requireNonNull(status);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Set<NodeStatus.Active> sessions = status.getCurrentSessions();
            Map<Capabilities, Integer> actives = sessions.parallelStream().collect(Collectors.groupingBy(NodeStatus.Active::getStereotype, Collectors.summingInt(active -> 1)));
            ImmutableList.Builder slots = ImmutableList.builder();
            status.getStereotypes().forEach((caps, count) -> {
                if (actives.containsKey(caps)) {
                    Integer activeCount = (Integer)actives.get(caps);
                    for (int i = 0; i < activeCount; ++i) {
                        slots.add((Object)new Slot(this.node, (Capabilities)caps, Slot.Status.ACTIVE));
                    }
                    count = count - activeCount;
                }
                for (int i = 0; i < count; ++i) {
                    slots.add((Object)new Slot(this.node, (Capabilities)caps, Slot.Status.AVAILABLE));
                }
            });
            this.slots = slots.build();
            this.maxSessionCount = Math.min(this.slots.size(), status.getMaxSessionCount());
        }
        finally {
            writeLock.unlock();
        }
    }

    public UUID getId() {
        return this.nodeId;
    }

    public DistributorStatus.NodeSummary asSummary() {
        HashMap<Capabilities, Integer> stereotypes = new HashMap<Capabilities, Integer>();
        HashMap<Capabilities, Integer> used = new HashMap<Capabilities, Integer>();
        this.slots.forEach(slot -> {
            stereotypes.compute(slot.getStereotype(), (key, curr) -> curr == null ? 1 : curr + 1);
            if (slot.getStatus() != Slot.Status.AVAILABLE) {
                used.compute(slot.getStereotype(), (key, curr) -> curr == null ? 1 : curr + 1);
            }
        });
        return new DistributorStatus.NodeSummary(this.nodeId, this.uri, this.getHostStatus() == Status.UP, this.maxSessionCount, stereotypes, used);
    }

    public Status getHostStatus() {
        return this.status;
    }

    private Status setHostStatus(Status status) {
        Status toReturn = this.status;
        this.status = Objects.requireNonNull(status, "Status must be set.");
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCapacity(Capabilities caps) {
        Lock read = this.lock.readLock();
        read.lock();
        try {
            long count = this.slots.stream().filter(slot -> slot.isSupporting(caps)).filter(slot -> slot.getStatus() == Slot.Status.AVAILABLE).count();
            boolean bl = count > 0L;
            return bl;
        }
        finally {
            read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getLoad() {
        Lock read = this.lock.readLock();
        read.lock();
        try {
            float inUse = this.slots.parallelStream().filter(slot -> slot.getStatus() != Slot.Status.AVAILABLE).count();
            float f = inUse / (float)this.maxSessionCount * 100.0f;
            return f;
        }
        finally {
            read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastSessionCreated() {
        Lock read = this.lock.readLock();
        read.lock();
        try {
            long l = this.slots.parallelStream().mapToLong(Slot::getLastSessionCreated).max().orElse(0L);
            return l;
        }
        finally {
            read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Supplier<CreateSessionResponse> reserve(CreateSessionRequest sessionRequest) {
        Objects.requireNonNull(sessionRequest);
        Lock write = this.lock.writeLock();
        write.lock();
        try {
            Slot toReturn = this.slots.stream().filter(slot -> slot.isSupporting(sessionRequest.getCapabilities())).filter(slot -> slot.getStatus() == Slot.Status.AVAILABLE).findFirst().orElseThrow(() -> new SessionNotCreatedException("Unable to reserve an instance"));
            Supplier<CreateSessionResponse> supplier = toReturn.onReserve(sessionRequest);
            return supplier;
        }
        finally {
            write.unlock();
        }
    }

    @VisibleForTesting
    void runHealthCheck() {
        this.performHealthCheck.run();
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.uri);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Host)) {
            return false;
        }
        Host that = (Host)obj;
        return this.node.equals(that.node);
    }

    public static enum Status {
        UP,
        DRAINING,
        DOWN;

    }
}

