/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.json.JsonInput;

public class DistributorStatus {
    private static final Type SUMMARIES_TYPES = new TypeToken<Set<NodeSummary>>(){}.getType();
    private final Set<NodeSummary> allNodes;

    public DistributorStatus(Collection<NodeSummary> allNodes) {
        this.allNodes = ImmutableSet.copyOf(allNodes);
    }

    public boolean hasCapacity() {
        return this.getNodes().stream().map(summary -> summary.isUp() && summary.hasCapacity()).reduce(Boolean::logicalOr).orElse(false);
    }

    public Set<NodeSummary> getNodes() {
        return this.allNodes;
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"nodes", this.getNodes());
    }

    private static DistributorStatus fromJson(JsonInput input) {
        Set nodes = null;
        input.beginObject();
        block6: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodes": {
                    nodes = (Set)input.read(SUMMARIES_TYPES);
                    continue block6;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DistributorStatus(nodes);
    }

    public static class NodeSummary {
        private final UUID nodeId;
        private final URI uri;
        private final boolean up;
        private final int maxSessionCount;
        private final Map<Capabilities, Integer> stereotypes;
        private final Map<Capabilities, Integer> used;

        public NodeSummary(UUID nodeId, URI uri, boolean up, int maxSessionCount, Map<Capabilities, Integer> stereotypes, Map<Capabilities, Integer> usedStereotypes) {
            this.nodeId = Objects.requireNonNull(nodeId);
            this.uri = Objects.requireNonNull(uri);
            this.up = up;
            this.maxSessionCount = maxSessionCount;
            this.stereotypes = ImmutableMap.copyOf(Objects.requireNonNull(stereotypes));
            this.used = ImmutableMap.copyOf(Objects.requireNonNull(usedStereotypes));
        }

        public UUID getNodeId() {
            return this.nodeId;
        }

        public URI getUri() {
            return this.uri;
        }

        public boolean isUp() {
            return this.up;
        }

        public int getMaxSessionCount() {
            return this.maxSessionCount;
        }

        public Map<Capabilities, Integer> getStereotypes() {
            return this.stereotypes;
        }

        public Map<Capabilities, Integer> getUsedStereotypes() {
            return this.used;
        }

        public boolean hasCapacity() {
            HashMap<Capabilities, Integer> all = new HashMap<Capabilities, Integer>(this.stereotypes);
            this.used.forEach((caps, count) -> all.computeIfPresent((Capabilities)caps, (ignored, curr) -> curr - count));
            return all.values().stream().map(count -> count > 0).reduce(Boolean::logicalOr).orElse(false);
        }

        private Map<String, Object> toJson() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"nodeId", (Object)this.getNodeId());
            builder.put((Object)"uri", (Object)this.getUri());
            builder.put((Object)"up", (Object)this.isUp());
            builder.put((Object)"maxSessionCount", (Object)this.getMaxSessionCount());
            builder.put((Object)"stereotypes", this.getStereotypes().entrySet().stream().map(entry -> ImmutableMap.of((Object)"capabilities", entry.getKey(), (Object)"count", entry.getValue())).collect(ImmutableList.toImmutableList()));
            builder.put((Object)"usedStereotypes", this.getUsedStereotypes().entrySet().stream().map(entry -> ImmutableMap.of((Object)"capabilities", entry.getKey(), (Object)"count", entry.getValue())).collect(ImmutableList.toImmutableList()));
            return builder.build();
        }

        private static NodeSummary fromJson(JsonInput input) {
            UUID nodeId = null;
            URI uri = null;
            boolean up = false;
            int maxSessionCount = 0;
            Map<Capabilities, Integer> stereotypes = new HashMap<Capabilities, Integer>();
            Map<Capabilities, Integer> used = new HashMap<Capabilities, Integer>();
            input.beginObject();
            block16: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "maxSessionCount": {
                        maxSessionCount = input.nextNumber().intValue();
                        continue block16;
                    }
                    case "nodeId": {
                        nodeId = (UUID)input.read(UUID.class);
                        continue block16;
                    }
                    case "stereotypes": {
                        stereotypes = NodeSummary.readCapabilityCounts(input);
                        continue block16;
                    }
                    case "up": {
                        up = input.nextBoolean();
                        continue block16;
                    }
                    case "uri": {
                        uri = (URI)input.read(URI.class);
                        continue block16;
                    }
                    case "usedStereotypes": {
                        used = NodeSummary.readCapabilityCounts(input);
                        continue block16;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new NodeSummary(nodeId, uri, up, maxSessionCount, stereotypes, used);
        }

        private static Map<Capabilities, Integer> readCapabilityCounts(JsonInput input) {
            HashMap<Capabilities, Integer> toReturn = new HashMap<Capabilities, Integer>();
            input.beginArray();
            while (input.hasNext()) {
                Capabilities caps = null;
                int count = 0;
                input.beginObject();
                block9: while (input.hasNext()) {
                    switch (input.nextName()) {
                        case "capabilities": {
                            caps = (Capabilities)input.read(Capabilities.class);
                            continue block9;
                        }
                        case "count": {
                            count = input.nextNumber().intValue();
                            continue block9;
                        }
                    }
                    input.skipValue();
                }
                input.endObject();
                toReturn.put(caps, count);
            }
            input.endArray();
            return toReturn;
        }
    }
}

