/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.local;

import com.google.common.eventbus.Subscribe;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.Type;
import org.openqa.selenium.grid.config.Config;

public class GuavaEventBus
implements EventBus {
    private final com.google.common.eventbus.EventBus guavaBus;
    private final List<Listener> allListeners = new LinkedList<Listener>();

    public GuavaEventBus() {
        this.guavaBus = new com.google.common.eventbus.EventBus();
    }

    @Override
    public void addListener(Type type, Consumer<Event> onType) {
        Listener listener = new Listener(type, onType);
        this.allListeners.add(listener);
        this.guavaBus.register((Object)listener);
    }

    @Override
    public void fire(Event event) {
        Objects.requireNonNull(event);
        this.guavaBus.post((Object)event);
    }

    @Override
    public void close() {
        this.allListeners.forEach(arg_0 -> ((com.google.common.eventbus.EventBus)this.guavaBus).unregister(arg_0));
        this.allListeners.clear();
    }

    public static GuavaEventBus create(Config config) {
        return new GuavaEventBus();
    }

    private static class Listener {
        private final Type type;
        private final Consumer<Event> onType;

        public Listener(Type type, Consumer<Event> onType) {
            this.type = Objects.requireNonNull(type);
            this.onType = Objects.requireNonNull(onType);
        }

        @Subscribe
        public void handle(Event event) {
            if (this.type.equals(event.getType())) {
                this.onType.accept(event);
            }
        }
    }
}

