/*
 * Decompiled with CFR 0.152.
 */
package org.securegraph.cli.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.securegraph.Authorizations;
import org.securegraph.Direction;
import org.securegraph.Edge;
import org.securegraph.Property;
import org.securegraph.Vertex;
import org.securegraph.cli.SecuregraphScript;
import org.securegraph.cli.model.LazyEdge;
import org.securegraph.cli.model.LazyVertexProperty;
import org.securegraph.cli.model.ModelBase;

public class LazyVertex
extends ModelBase {
    private final String vertexId;

    public LazyVertex(String vertexId) {
        this.vertexId = vertexId;
    }

    public String toString() {
        Vertex v = this.getV();
        if (v == null) {
            return null;
        }
        return LazyVertex.toString(v, this.getAuthorizations());
    }

    public static String toString(Vertex v, Authorizations authorizations) {
        LazyEdge lazyEdge;
        String edgeIndexString;
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("@|bold " + v.getId() + "|@");
        writer.println("  @|bold visibility:|@ " + v.getVisibility());
        writer.println("  @|bold properties:|@");
        SecuregraphScript.getContextProperties().clear();
        int propIndex = 0;
        for (Property prop : v.getProperties()) {
            String propertyIndexString = "p" + propIndex;
            String valueString = SecuregraphScript.valueToString(prop.getValue(), false);
            writer.println("    @|bold " + propertyIndexString + ":|@ " + prop.getName() + ":" + prop.getKey() + "[" + prop.getVisibility().getVisibilityString() + "] = " + valueString);
            LazyVertexProperty lazyProperty = new LazyVertexProperty(v.getId(), prop.getKey(), prop.getName(), prop.getVisibility());
            SecuregraphScript.getContextProperties().put(propertyIndexString, lazyProperty);
            ++propIndex;
        }
        SecuregraphScript.getContextEdges().clear();
        int edgeIndex = 0;
        writer.println("  @|bold out edges:|@");
        for (Edge edge : v.getEdges(Direction.OUT, authorizations)) {
            edgeIndexString = "e" + edgeIndex;
            writer.println("    @|bold " + edgeIndexString + ":|@ " + edge.getId() + ": " + edge.getLabel() + " -> " + edge.getOtherVertexId(v.getId()));
            lazyEdge = new LazyEdge(edge.getId());
            SecuregraphScript.getContextEdges().put(edgeIndexString, lazyEdge);
            ++edgeIndex;
        }
        writer.println("  @|bold in edges:|@");
        for (Edge edge : v.getEdges(Direction.IN, authorizations)) {
            edgeIndexString = "e" + edgeIndex;
            writer.println("    @|bold " + edgeIndexString + ":|@ " + edge.getId() + ": " + edge.getLabel() + " -> " + edge.getOtherVertexId(v.getId()));
            lazyEdge = new LazyEdge(edge.getId());
            SecuregraphScript.getContextEdges().put(edgeIndexString, lazyEdge);
            ++edgeIndex;
        }
        return out.toString();
    }

    private Vertex getV() {
        return this.getGraph().getVertex(this.getId(), this.getAuthorizations());
    }

    public String getId() {
        return this.vertexId;
    }
}

