/*
 * Decompiled with CFR 0.152.
 */
package org.securegraph.cli.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.securegraph.Metadata;
import org.securegraph.Property;
import org.securegraph.Visibility;
import org.securegraph.cli.SecuregraphScript;
import org.securegraph.cli.model.ModelBase;

public abstract class LazyProperty
extends ModelBase {
    private final String propertyKey;
    private final String propertyName;
    private final Visibility propertyVisibility;

    public LazyProperty(String propertyKey, String propertyName, Visibility propertyVisibility) {
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyVisibility = propertyVisibility;
    }

    public String toString() {
        Property prop = this.getP();
        if (prop == null) {
            return null;
        }
        return LazyProperty.toString(prop, this.getToStringHeaderLine());
    }

    public static String toString(Property prop, String headerLine) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        if (headerLine != null) {
            writer.println(headerLine);
        }
        writer.println("  @|bold key:|@ " + prop.getKey());
        writer.println("  @|bold name:|@ " + prop.getName());
        writer.println("  @|bold visibility:|@ " + prop.getVisibility());
        writer.println("  @|bold metadata:|@");
        for (Metadata.Entry m : prop.getMetadata().entrySet()) {
            writer.println("    " + m.getKey() + "[" + m.getVisibility() + "]: " + SecuregraphScript.valueToString(m.getValue(), false));
        }
        writer.println("  @|bold value:|@");
        writer.println(SecuregraphScript.valueToString(prop.getValue(), true));
        return out.toString();
    }

    protected abstract String getToStringHeaderLine();

    protected abstract Property getP();

    public String getKey() {
        return this.propertyKey;
    }

    public String getName() {
        return this.propertyName;
    }

    public Visibility getVisibility() {
        return this.propertyVisibility;
    }
}

