/*
 * Decompiled with CFR 0.152.
 */
package org.securegraph.cli.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.securegraph.Direction;
import org.securegraph.Edge;
import org.securegraph.Property;
import org.securegraph.cli.SecuregraphScript;
import org.securegraph.cli.model.LazyEdgeProperty;
import org.securegraph.cli.model.LazyVertex;
import org.securegraph.cli.model.ModelBase;

public class LazyEdge
extends ModelBase {
    private final String edgeId;

    public LazyEdge(String edgeId) {
        this.edgeId = edgeId;
    }

    public String toString() {
        Edge e = this.getE();
        if (e == null) {
            return null;
        }
        return LazyEdge.toString(e);
    }

    public static String toString(Edge e) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("@|bold " + e.getId() + "|@");
        writer.println("  @|bold visibility:|@ " + e.getVisibility());
        writer.println("  @|bold label:|@ " + e.getLabel());
        writer.println("  @|bold properties:|@");
        SecuregraphScript.getContextProperties().clear();
        int propIndex = 0;
        for (Property prop : e.getProperties()) {
            String propertyIndexString = "p" + propIndex;
            String valueString = SecuregraphScript.valueToString(prop.getValue(), false);
            writer.println("    @|bold " + propertyIndexString + ":|@ " + prop.getName() + ":" + prop.getKey() + "[" + prop.getVisibility().getVisibilityString() + "] = " + valueString);
            LazyEdgeProperty lazyProperty = new LazyEdgeProperty(e.getId(), prop.getKey(), prop.getName(), prop.getVisibility());
            SecuregraphScript.getContextProperties().put(propertyIndexString, lazyProperty);
            ++propIndex;
        }
        SecuregraphScript.getContextVertices().clear();
        int vertexIndex = 0;
        writer.println("  @|bold out vertex:|@");
        String vertexIndexString = "v" + vertexIndex;
        writer.println("    @|bold " + vertexIndexString + ":|@ " + e.getVertexId(Direction.OUT));
        LazyVertex lazyVertex = new LazyVertex(e.getVertexId(Direction.OUT));
        SecuregraphScript.getContextVertices().put(vertexIndexString, lazyVertex);
        writer.println("  @|bold in vertex:|@");
        vertexIndexString = "v" + ++vertexIndex;
        writer.println("    @|bold " + vertexIndexString + ":|@ " + e.getVertexId(Direction.IN));
        lazyVertex = new LazyVertex(e.getVertexId(Direction.IN));
        SecuregraphScript.getContextVertices().put(vertexIndexString, lazyVertex);
        ++vertexIndex;
        return out.toString();
    }

    private Edge getE() {
        return this.getGraph().getEdge(this.getId(), this.getAuthorizations());
    }

    public String getId() {
        return this.edgeId;
    }
}

