/*
 * Decompiled with CFR 0.152.
 */
package org.securegraph.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import jline.UnixTerminal;
import jline.UnsupportedTerminal;
import jline.WindowsTerminal;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.shell.AnsiDetector;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.Interpreter;
import org.codehaus.groovy.tools.shell.util.Logger;
import org.codehaus.groovy.tools.shell.util.NoExitSecurityManager;
import org.codehaus.groovy.tools.shell.util.Preferences;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.securegraph.Graph;
import org.securegraph.GraphFactory;
import org.securegraph.cli.SecuregraphScript;

public class SecuregraphShell {
    private final Groovysh groovysh;
    @Parameter(names={"-C"}, description="Suppress colors")
    private boolean suppressColor;
    @Parameter(names={"-T"}, description="Terminal type")
    private String terminalType = "auto";
    @Parameter(names={"-e"}, description="String to evaluate")
    private String evalString = null;
    @Parameter(names={"-c"}, description="Configuration file name", required=true)
    private String configFileName = null;
    @Parameter(names={"-cp"}, description="Configuration property prefix")
    private String configPropertyPrefix = null;
    @Parameter(names={"-a"}, description="Authorizations")
    private String authorizations = null;
    @Parameter(description="File names to execute")
    private List<String> fileNames = new ArrayList<String>();

    public SecuregraphShell(String[] args) throws Exception {
        IO io;
        new JCommander((Object)this, args);
        SecuregraphShell.setTerminalType(this.terminalType, this.suppressColor);
        Map config = this.loadConfig();
        Graph graph = new GraphFactory().createGraph(config);
        System.setProperty("groovysh.prompt", "securegraph");
        Logger.io = io = new IO();
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        SecuregraphScript.setGraph(graph);
        if (this.authorizations != null) {
            SecuregraphScript.setAuthorizations(graph.createAuthorizations(this.authorizations.split(",")));
        }
        compilerConfiguration.setScriptBaseClass(SecuregraphScript.class.getName());
        Binding binding = new Binding();
        GroovyShell groovyShell = new GroovyShell(this.getClass().getClassLoader(), binding, compilerConfiguration);
        Closure<Object> resultHook = new Closure<Object>((Object)this){

            public Object call(Object ... args) {
                boolean showLastResult;
                Object obj = args[0];
                boolean bl = showLastResult = !io.isQuiet() && (io.isVerbose() || Preferences.getShowLastResult());
                if (showLastResult) {
                    io.out.println("@|bold ===>|@ " + SecuregraphScript.resultToString(obj));
                }
                return null;
            }
        };
        this.groovysh = new Groovysh(io);
        this.setGroovyShell(this.groovysh, groovyShell);
        this.setResultHook(this.groovysh, resultHook);
        this.startGroovysh(this.evalString, this.fileNames);
    }

    private Map loadConfig() throws IOException {
        File configFile = new File(this.configFileName);
        if (!configFile.exists()) {
            throw new RuntimeException("Could not load config file: " + configFile.getAbsolutePath());
        }
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(configFile);){
            props.load(in);
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (this.configPropertyPrefix == null) {
            result.putAll(props);
        } else {
            for (Map.Entry<Object, Object> p : props.entrySet()) {
                String key = (String)p.getKey();
                String val = (String)p.getValue();
                if (key.startsWith(this.configPropertyPrefix + ".")) {
                    result.put(key.substring((this.configPropertyPrefix + ".").length()), val);
                    continue;
                }
                if (!key.startsWith(this.configPropertyPrefix)) continue;
                result.put(key.substring(this.configPropertyPrefix.length()), val);
            }
        }
        return result;
    }

    private void setGroovyShell(Groovysh groovysh, GroovyShell groovyShell) throws NoSuchFieldException, IllegalAccessException {
        Field interpField = groovysh.getClass().getDeclaredField("interp");
        interpField.setAccessible(true);
        Field shellField = Interpreter.class.getDeclaredField("shell");
        shellField.setAccessible(true);
        Interpreter interpreter = (Interpreter)interpField.get(groovysh);
        shellField.set(interpreter, groovyShell);
    }

    private void setResultHook(Groovysh groovysh, Closure<Object> resultHook) throws NoSuchFieldException, IllegalAccessException {
        Field resultHookField = Groovysh.class.getDeclaredField("resultHook");
        resultHookField.setAccessible(true);
        resultHookField.set(groovysh, resultHook);
    }

    public Groovysh getGroovysh() {
        return this.groovysh;
    }

    public static void main(String[] args) throws Exception {
        new SecuregraphShell(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startGroovysh(String evalString, List<String> filenames) throws IOException {
        int code;
        final Groovysh shell = this.getGroovysh();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (shell.getHistory() != null) {
                    try {
                        shell.getHistory().flush();
                    }
                    catch (IOException e) {
                        System.out.println("Could not flush history.");
                    }
                }
            }
        });
        SecurityManager psm = System.getSecurityManager();
        System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
        try {
            code = shell.run(evalString, filenames);
        }
        finally {
            System.setSecurityManager(psm);
        }
        System.exit(code);
    }

    static void setTerminalType(String type, boolean suppressColor) {
        assert (type != null);
        type = type.toLowerCase();
        boolean enableAnsi = true;
        switch (type) {
            case "auto": {
                type = null;
                break;
            }
            case "unix": {
                type = UnixTerminal.class.getCanonicalName();
                break;
            }
            case "win": 
            case "windows": {
                type = WindowsTerminal.class.getCanonicalName();
                break;
            }
            case "false": 
            case "off": 
            case "none": {
                type = UnsupportedTerminal.class.getCanonicalName();
                enableAnsi = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Terminal type: $type");
            }
        }
        if (enableAnsi) {
            SecuregraphShell.installAnsi();
            Ansi.setEnabled((!suppressColor ? 1 : 0) != 0);
        } else {
            Ansi.setEnabled((boolean)false);
        }
        if (type != null) {
            System.setProperty("jline.terminal", type);
        }
    }

    static void installAnsi() {
        AnsiConsole.systemInstall();
        Ansi.setDetector((Callable)new AnsiDetector());
    }

    static void setSystemProperty(String nameValue) {
        String value;
        String name;
        if (nameValue.indexOf(61) > 0) {
            String[] tmp = nameValue.split("=", 2);
            name = tmp[0];
            value = tmp[1];
        } else {
            name = nameValue;
            value = Boolean.TRUE.toString();
        }
        System.setProperty(name, value);
    }
}

