/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.resolver.DependencyResolver;

public class DefaultResolutionCacheManager
implements ResolutionCacheManager,
IvySettingsAware {
    private String resolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String resolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private File basedir;
    private String name = "resolution-cache";
    private IvySettings settings;

    public DefaultResolutionCacheManager() {
    }

    public DefaultResolutionCacheManager(File file) {
        this.setBasedir(file);
    }

    @Override
    public void setSettings(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    public File getResolutionCacheRoot() {
        return this.basedir;
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public String getResolvedIvyPattern() {
        return this.resolvedIvyPattern;
    }

    public String getResolvedIvyPropertiesPattern() {
        return this.resolvedIvyPropertiesPattern;
    }

    public File getResolvedIvyFileInCache(ModuleRevisionId object) {
        object = IvyPatternHelper.substitute(this.getResolvedIvyPattern(), ((ModuleRevisionId)object).getOrganisation(), ((ModuleRevisionId)object).getName(), ((ModuleRevisionId)object).getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), (String)object);
    }

    @Override
    public File getResolvedIvyPropertiesInCache(ModuleRevisionId object) {
        object = IvyPatternHelper.substitute(this.getResolvedIvyPropertiesPattern(), ((ModuleRevisionId)object).getOrganisation(), ((ModuleRevisionId)object).getName(), ((ModuleRevisionId)object).getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), (String)object);
    }

    @Override
    public File getConfigurationResolveReportInCache(String string, String string2) {
        return new File(this.getResolutionCacheRoot(), string + "-" + string2 + ".xml");
    }

    @Override
    public ModuleDescriptor getResolvedModuleDescriptor(ModuleRevisionId object) throws ParseException, IOException {
        Serializable serializable = this.getResolvedIvyFileInCache((ModuleRevisionId)object);
        if (!serializable.exists()) {
            throw new IllegalStateException("Ivy file not found in cache for " + object + "!");
        }
        Properties properties = new Properties();
        if (((File)(object = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance((ModuleRevisionId)object, ((ModuleRevisionId)object).getRevision() + "-parents")))).exists()) {
            object = new FileInputStream((File)object);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        object = new CacheParserSettings(this.settings, properties);
        serializable = serializable.toURI().toURL();
        return XmlModuleDescriptorParser.getInstance().parseDescriptor((ParserSettings)object, (URL)serializable, false);
    }

    @Override
    public void saveResolvedModuleDescriptor(ModuleDescriptor object) throws ParseException, IOException {
        ModuleRevisionId moduleRevisionId = object.getResolvedModuleRevisionId();
        File file = this.getResolvedIvyFileInCache(moduleRevisionId);
        object.toIvyFile(file);
        Properties properties = new Properties();
        this.saveLocalParents(moduleRevisionId, (ModuleDescriptor)object, file, properties);
        if (!properties.isEmpty()) {
            object = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision() + "-parents"));
            object = new FileOutputStream((File)object);
            properties.store((OutputStream)object, null);
            ((FileOutputStream)object).close();
        }
    }

    private void saveLocalParents(ModuleRevisionId moduleRevisionId, ModuleDescriptor extendsDescriptorArray, File file, Properties properties) throws ParseException, IOException {
        extendsDescriptorArray = extendsDescriptorArray.getInheritedDescriptors();
        for (int i = 0; i < extendsDescriptorArray.length; ++i) {
            if (!extendsDescriptorArray[i].isLocal()) continue;
            ModuleDescriptor moduleDescriptor = extendsDescriptorArray[i].getParentMd();
            Object object = ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision() + "-parent." + properties.size());
            object = this.getResolvedIvyFileInCache((ModuleRevisionId)object);
            moduleDescriptor.toIvyFile((File)object);
            properties.setProperty(file.getName() + "|" + extendsDescriptorArray[i].getLocation(), ((File)object).getAbsolutePath());
            this.saveLocalParents(moduleRevisionId, moduleDescriptor, (File)object, properties);
        }
    }

    public String toString() {
        return this.name;
    }

    private static class MapURLResolver
    extends RelativeUrlResolver {
        private Map paths;
        private RelativeUrlResolver delegate;

        private MapURLResolver(Map map, RelativeUrlResolver relativeUrlResolver) {
            this.paths = map;
            this.delegate = relativeUrlResolver;
        }

        @Override
        public URL getURL(URL serializable, String string) throws MalformedURLException {
            String string2 = serializable.getPath();
            if (string2.indexOf(47) >= 0) {
                String string3 = string2;
                string2 = string3.substring(string3.lastIndexOf(47) + 1);
                if (this.paths.containsKey(string2 + "|" + string)) {
                    serializable = new File(this.paths.get(string2 + "|" + string).toString());
                    return ((File)serializable).toURI().toURL();
                }
            }
            return this.delegate.getURL((URL)serializable, string);
        }
    }

    private static class CacheParserSettings
    implements ParserSettings {
        private ParserSettings delegate;
        private Map parentPaths;

        public CacheParserSettings(ParserSettings parserSettings, Map map) {
            this.delegate = parserSettings;
            this.parentPaths = map;
        }

        @Override
        public String substitute(String string) {
            return this.delegate.substitute(string);
        }

        @Override
        public ResolutionCacheManager getResolutionCacheManager() {
            return this.delegate.getResolutionCacheManager();
        }

        @Override
        public ConflictManager getConflictManager(String string) {
            return this.delegate.getConflictManager(string);
        }

        @Override
        public PatternMatcher getMatcher(String string) {
            return this.delegate.getMatcher(string);
        }

        @Override
        public Namespace getNamespace(String string) {
            return this.delegate.getNamespace(string);
        }

        @Override
        public StatusManager getStatusManager() {
            return this.delegate.getStatusManager();
        }

        @Override
        public RelativeUrlResolver getRelativeUrlResolver() {
            return new MapURLResolver(this.parentPaths, this.delegate.getRelativeUrlResolver());
        }

        @Override
        public DependencyResolver getResolver(ModuleRevisionId moduleRevisionId) {
            return this.delegate.getResolver(moduleRevisionId);
        }

        @Override
        public File resolveFile(String string) {
            return this.delegate.resolveFile(string);
        }

        @Override
        public Namespace getContextNamespace() {
            return this.delegate.getContextNamespace();
        }
    }
}

