/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import xsbt.boot.AppConfiguration;
import xsbt.boot.BootException;
import xsbt.boot.Configuration$;
import xsbt.boot.ConfigurationStorageState$;
import xsbt.boot.Enumeration;
import xsbt.boot.Find$;
import xsbt.boot.IO;
import xsbt.boot.Initialize$;
import xsbt.boot.JAnsi$;
import xsbt.boot.LaunchConfiguration;
import xsbt.boot.LaunchConfiguration$;
import xsbt.boot.Launcher$;
import xsbt.boot.LauncherArguments;
import xsbt.boot.Pre$;
import xsbt.boot.ResolveValues$;
import xsbt.boot.RunConfiguration;
import xsbt.boot.ServerConfiguration;
import xsbt.boot.ServerLocator$;
import xsbti.AppMain;
import xsbti.AppProvider;
import xsbti.Continue;
import xsbti.Exit;
import xsbti.FullReload;
import xsbti.Launcher;
import xsbti.MainResult;
import xsbti.Reboot;
import xsbti.ServerMain;

public final class Launch$ {
    public static final Launch$ MODULE$ = new Launch$();
    private static final Class<ServerMain> ServerMainClass = ServerMain.class;
    private static final Class<AppMain> AppMainClass = AppMain.class;

    /*
     * WARNING - void declaration
     */
    public final Option<Object> apply(LauncherArguments arguments) {
        void var1_1;
        return this.apply(new File("").getAbsoluteFile(), (LauncherArguments)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Option<Object> apply(File currentDirectory, LauncherArguments arguments) {
        void var1_1;
        void config2;
        Launcher launcher;
        Serializable state;
        if (arguments.isExportRt()) {
            if (arguments.args().size() != 1) {
                throw package$.MODULE$.error("destination expected: --export-rt <dest>");
            }
            return this.exportRt((String)arguments.args().head());
        }
        Tuple3<URL, List<String>, Enumeration.Value> tuple3 = Configuration$.MODULE$.find(arguments.args(), currentDirectory);
        if (tuple3 == null) {
            throw new MatchError(state);
        }
        URL configLocation = tuple3._1();
        List newArgs2 = tuple3._2();
        state = tuple3._3();
        state = new Tuple3<URL, List<String>, Enumeration.Value>(configLocation, newArgs2, (Enumeration.Value)state);
        configLocation = (URL)((Tuple3)state)._1();
        newArgs2 = (List)((Tuple3)state)._2();
        state = (Enumeration.Value)((Tuple3)state)._3();
        Enumeration.Value value = ConfigurationStorageState$.MODULE$.SerializedFile();
        Serializable serializable = state;
        if (!(value != null ? !value.equals(serializable) : serializable != null)) {
            state = LaunchConfiguration$.MODULE$.restore(configLocation);
        } else {
            Enumeration.Value value2 = ConfigurationStorageState$.MODULE$.PropertiesFile();
            serializable = state;
            if (!(value2 != null ? !value2.equals(serializable) : serializable != null)) {
                state = this.parseAndInitializeConfig(configLocation, currentDirectory);
            } else {
                throw new MatchError(state);
            }
        }
        if (((LauncherArguments)((Object)launcher)).isLocate()) {
            if (!newArgs2.isEmpty()) {
                Console$.MODULE$.err().println("[warn] [launcher] --locate option ignores arguments");
            }
            return this.locate(currentDirectory, (LaunchConfiguration)config2);
        }
        this.updateProperties((LaunchConfiguration)config2);
        launcher = Launcher$.MODULE$.apply((LaunchConfiguration)config2);
        return this.launch((Function1<RunConfiguration, MainResult> & Serializable)config -> {
            void var1_1;
            Launcher launcher;
            return MODULE$.run(launcher, (RunConfiguration)var1_1);
        }, this.makeRunConfig((File)var1_1, (LaunchConfiguration)((Object)tuple3), newArgs2));
    }

    /*
     * WARNING - void declaration
     */
    public final Option<Object> exportRt(String destination) {
        void var1_1;
        Path path;
        FileSystem fileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
        Path path2 = fileSystem.getPath("/modules", new String[0]);
        Path destPath = Paths.get(destination, new String[0]);
        URI uri = URI.create(new StringBuilder(4).append("jar:").append(destPath.toUri()).toString());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        FileSystem zipfs = FileSystems.newFileSystem(uri, path);
        try {
            Iterator iterator = Files.list(path2).iterator();
            while (iterator.hasNext()) {
                path = (Path)iterator.next();
                IO.copyDirectory(path, zipfs.getPath("/", new String[0]));
            }
        }
        catch (Throwable throwable) {
            zipfs.close();
            throw throwable;
        }
        var1_1.close();
        return new Some<Object>(BoxesRunTime.boxToInteger(0));
    }

    /*
     * WARNING - void declaration
     */
    public final Option<Object> locate(File currentDirectory, LaunchConfiguration config) {
        Some<Object> some;
        Option<ServerConfiguration> option = config.serverConfig();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                void var2_2;
                throw package$.MODULE$.error(new StringBuilder(32).append(config.app().groupID()).append("-").append(var2_2.app().main()).append(" is not configured as a server.").toString());
            }
            throw new MatchError(option);
        }
        URI uri = ServerLocator$.MODULE$.locate(currentDirectory, config);
        Console$.MODULE$.err().println(((URI)((Object)some)).toASCIIString());
        some = new Some<Object>(BoxesRunTime.boxToInteger(0));
        return some;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateProperties(LaunchConfiguration config) {
        void var1_1;
        if ((config = config.serverConfig()) instanceof Some) {
            File file;
            config = (Some)config;
            config = (ServerConfiguration)((Some)config).value();
            if ((config = ((ServerConfiguration)config).jvmPropsFile()) instanceof Some && (file = (File)((Some)(config = (Some)config)).value()).exists()) {
                try {
                    Pre$ pre$ = Pre$.MODULE$;
                    pre$.setSystemProperties(pre$.readProperties(file));
                }
                catch (Exception e) {
                    void var2_2;
                    throw new RuntimeException(new StringBuilder(39).append("unable to load server properties file: ").append(var1_1).toString(), (Throwable)var2_2);
                }
            }
            return;
        }
        if (None$.MODULE$.equals(var1_1)) {
            return;
        }
        throw new MatchError(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final LaunchConfiguration parseAndInitializeConfig(URL configLocation, File currentDirectory) {
        void var2_2;
        Tuple2<LaunchConfiguration, void> tuple2;
        if ((configLocation = this.parseConfiguration((URL)configLocation, currentDirectory)) == null) {
            throw new MatchError(tuple2);
        }
        LaunchConfiguration parsed = (LaunchConfiguration)((Tuple2)configLocation)._1();
        File bd = (File)((Tuple2)configLocation)._2();
        tuple2 = new Tuple2<LaunchConfiguration, void>(parsed, (void)tuple2);
        parsed = tuple2._1();
        tuple2._2();
        return this.resolveConfig((LaunchConfiguration)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final Tuple2<LaunchConfiguration, File> parseConfiguration(URL configLocation, File currentDirectory) {
        void var2_2;
        void var1_1;
        return Find$.MODULE$.apply(Configuration$.MODULE$.parse((URL)var1_1, currentDirectory), (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final LaunchConfiguration resolveConfig(LaunchConfiguration parsed) {
        void var1_1;
        File propertiesFile = parsed.boot().properties();
        if (Pre$.MODULE$.isNonEmpty(parsed.boot().promptCreate()) && !propertiesFile.exists()) {
            Initialize$.MODULE$.create(propertiesFile, parsed.boot().promptCreate(), parsed.boot().enableQuick(), parsed.appProperties());
        } else if (parsed.boot().promptFill()) {
            void var2_2;
            Initialize$.MODULE$.fill((File)var2_2, parsed.appProperties());
        }
        parsed.logging().debug((Function0<String> & Serializable)() -> {
            LaunchConfiguration launchConfiguration;
            return new StringBuilder(22).append("parsed configuration: ").append(launchConfiguration).toString();
        });
        LaunchConfiguration resolved = ResolveValues$.MODULE$.apply(parsed);
        resolved.logging().debug((Function0<String> & Serializable)() -> {
            LaunchConfiguration launchConfiguration;
            return new StringBuilder(24).append("resolved configuration: ").append(launchConfiguration).toString();
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final RunConfiguration makeRunConfig(File currentDirectory, LaunchConfiguration config, List<String> arguments) {
        void var3_3;
        void var1_1;
        void var2_2;
        return new RunConfiguration(config.getScalaVersion(), var2_2.app().toID(), (File)var1_1, (List<String>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final MainResult run(Launcher launcher, RunConfiguration config) {
        void var1_1;
        MainResult mainResult;
        AppProvider appProvider = launcher.app(config.app(), Pre$.MODULE$.orNull(config.scalaVersion()));
        AppConfiguration appConfig = new AppConfiguration((String[])Pre$.MODULE$.toArray(config.arguments(), ClassTag$.MODULE$.apply(String.class)), config.workingDirectory(), appProvider);
        JAnsi$.MODULE$.install(launcher.topLoader());
        try {
            AppMain main = appProvider.newMain();
            try {
                void var3_4;
                mainResult = (MainResult)this.withContextLoader(var3_4.loader(), (Function0<MainResult> & Serializable)() -> {
                    void var1_1;
                    return main.run((xsbti.AppConfiguration)var1_1);
                });
            }
            catch (FullReload fullReload) {
                void var2_2;
                FullReload e = fullReload;
                if (fullReload.clean()) {
                    Pre$.MODULE$.delete(launcher.bootDirectory());
                }
                throw var2_2;
            }
        }
        catch (Throwable throwable) {
            JAnsi$.MODULE$.uninstall(launcher.topLoader());
            throw throwable;
        }
        JAnsi$.MODULE$.uninstall(var1_1.topLoader());
        return mainResult;
    }

    /*
     * WARNING - void declaration
     */
    public final Option<Object> launch(Function1<RunConfiguration, MainResult> run, RunConfiguration config) {
        void var1_1;
        block3: {
            void var2_2;
            while (true) {
                if ((config = run.apply((RunConfiguration)config)) instanceof Exit) {
                    run = (Exit)config;
                    run = new Some<Integer>(BoxesRunTime.boxToInteger(run.code()));
                    break block3;
                }
                if (config instanceof Continue) {
                    run = None$.MODULE$;
                    break block3;
                }
                if (!(config instanceof Reboot)) break;
                config = (Reboot)config;
                config = new RunConfiguration(Option$.MODULE$.apply(config.scalaVersion()), config.app(), config.baseDirectory(), Predef$.MODULE$.wrapRefArray((Object[])config.arguments()).toList());
            }
            throw new BootException(new StringBuilder(21).append("invalid main result: ").append(var2_2).append((Object)(var2_2 == null ? "" : new StringBuilder(10).append(" (class: ").append(var2_2.getClass()).append(")").toString())).toString());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T withContextLoader(ClassLoader loader, Function0<T> eval) {
        void var3_4;
        Object r;
        void var1_1;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)var1_1);
        try {
            void var2_3;
            r = var2_3.apply();
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw throwable;
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)var3_4);
        return (T)r;
    }

    public final Class<AppMain> AppMainClass() {
        return AppMainClass;
    }

    private Launch$() {
    }
}

