/*
 * Decompiled with CFR 0.152.
 */
package xsbti.api;

import java.util.function.Supplier;
import xsbti.api.AbstractLazy;
import xsbti.api.Lazy;

public final class SafeLazy {
    public static <T> Lazy<T> apply(Supplier<T> sbtThunk) {
        return new Impl<T>(sbtThunk);
    }

    public static <T> Lazy<T> strict(T value) {
        return new StrictImpl<T>(value);
    }

    private static final class StrictImpl<T>
    extends AbstractLazy<T> {
        private final T value;

        StrictImpl(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }
    }

    private static final class Impl<T>
    extends AbstractLazy<T> {
        private Thunky<T> thunky;

        Impl(Supplier<T> thunk) {
            this.thunky = new Thunky<Object>(thunk, null);
        }

        @Override
        public T get() {
            Thunky<T> t = this.thunky;
            if (t.result == null) {
                Object r = t.thunk.get();
                this.thunky = t = new Thunky(null, r);
            }
            return t.result;
        }
    }

    private static final class Thunky<T> {
        final Supplier<T> thunk;
        final T result;

        Thunky(Supplier<T> thunk, T result) {
            this.thunk = thunk;
            this.result = result;
        }
    }
}

