/*
 * Decompiled with CFR 0.152.
 */
package xsbti.api;

import java.io.Serializable;
import xsbti.api.AnalyzedClass;
import xsbti.api.DependencyContext;

public final class ExternalDependency
implements Serializable {
    private String sourceClassName;
    private String targetProductClassName;
    private AnalyzedClass targetClass;
    private DependencyContext context;

    public static ExternalDependency create(String _sourceClassName, String _targetProductClassName, AnalyzedClass _targetClass, DependencyContext _context) {
        return new ExternalDependency(_sourceClassName, _targetProductClassName, _targetClass, _context);
    }

    public static ExternalDependency of(String _sourceClassName, String _targetProductClassName, AnalyzedClass _targetClass, DependencyContext _context) {
        return new ExternalDependency(_sourceClassName, _targetProductClassName, _targetClass, _context);
    }

    protected ExternalDependency(String _sourceClassName, String _targetProductClassName, AnalyzedClass _targetClass, DependencyContext _context) {
        this.sourceClassName = _sourceClassName;
        this.targetProductClassName = _targetProductClassName;
        this.targetClass = _targetClass;
        this.context = _context;
    }

    public String sourceClassName() {
        return this.sourceClassName;
    }

    public String targetProductClassName() {
        return this.targetProductClassName;
    }

    public AnalyzedClass targetClass() {
        return this.targetClass;
    }

    public DependencyContext context() {
        return this.context;
    }

    public ExternalDependency withSourceClassName(String sourceClassName) {
        return new ExternalDependency(sourceClassName, this.targetProductClassName, this.targetClass, this.context);
    }

    public ExternalDependency withTargetProductClassName(String targetProductClassName) {
        return new ExternalDependency(this.sourceClassName, targetProductClassName, this.targetClass, this.context);
    }

    public ExternalDependency withTargetClass(AnalyzedClass targetClass) {
        return new ExternalDependency(this.sourceClassName, this.targetProductClassName, targetClass, this.context);
    }

    public ExternalDependency withContext(DependencyContext context) {
        return new ExternalDependency(this.sourceClassName, this.targetProductClassName, this.targetClass, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalDependency)) {
            return false;
        }
        ExternalDependency o = (ExternalDependency)obj;
        return this.sourceClassName().equals(o.sourceClassName()) && this.targetProductClassName().equals(o.targetProductClassName()) && this.targetClass().equals(o.targetClass()) && this.context().equals((Object)o.context());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (17 + "xsbti.api.ExternalDependency".hashCode()) + this.sourceClassName().hashCode()) + this.targetProductClassName().hashCode()) + this.targetClass().hashCode()) + this.context().hashCode());
    }

    public String toString() {
        return "ExternalDependency(sourceClassName: " + this.sourceClassName() + ", targetProductClassName: " + this.targetProductClassName() + ", targetClass: " + this.targetClass() + ", context: " + (Object)((Object)this.context()) + ")";
    }
}

