/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.util.Optional;
import xsbti.compile.AnalysisContents;

public interface AnalysisStore {
    public static AnalysisStore getCachedStore(AnalysisStore analysisStore) {
        return new CachedAnalysisStore(analysisStore);
    }

    public static AnalysisStore cached(AnalysisStore analysisStore) {
        return AnalysisStore.getCachedStore(analysisStore);
    }

    public static AnalysisStore getThreadSafeStore(AnalysisStore analysisStore) {
        return new SyncedAnalysisStore(analysisStore);
    }

    public static AnalysisStore sync(AnalysisStore analysisStore) {
        return AnalysisStore.getThreadSafeStore(analysisStore);
    }

    public Optional<AnalysisContents> get();

    public AnalysisContents unsafeGet();

    public void set(AnalysisContents var1);

    public static final class SyncedAnalysisStore
    implements AnalysisStore {
        private AnalysisStore underlying;

        SyncedAnalysisStore(AnalysisStore analysisStore) {
            this.underlying = analysisStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<AnalysisContents> get() {
            SyncedAnalysisStore syncedAnalysisStore = this;
            synchronized (syncedAnalysisStore) {
                return this.underlying.get();
            }
        }

        @Override
        public AnalysisContents unsafeGet() {
            return this.get().get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(AnalysisContents analysisContents) {
            SyncedAnalysisStore syncedAnalysisStore = this;
            synchronized (syncedAnalysisStore) {
                this.underlying.set(analysisContents);
            }
        }
    }

    public static final class CachedAnalysisStore
    implements AnalysisStore {
        private AnalysisStore underlying;
        private Optional<AnalysisContents> lastStore = Optional.empty();

        CachedAnalysisStore(AnalysisStore analysisStore) {
            this.underlying = analysisStore;
        }

        @Override
        public Optional<AnalysisContents> get() {
            if (!this.lastStore.isPresent()) {
                this.lastStore = this.underlying.get();
            }
            return this.lastStore;
        }

        @Override
        public AnalysisContents unsafeGet() {
            return this.get().get();
        }

        @Override
        public void set(AnalysisContents analysisContents) {
            this.underlying.set(analysisContents);
            this.lastStore = Optional.of(analysisContents);
        }
    }
}

