/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import xsbti.F1;
import xsbti.Position;
import xsbti.compile.CompileOrder;

public final class CompileOptions
implements Serializable {
    private File[] classpath;
    private File[] sources;
    private File classesDirectory;
    private String[] scalacOptions;
    private String[] javacOptions;
    private int maxErrors;
    private F1<Position, Position> sourcePositionMapper;
    private CompileOrder order;

    public CompileOptions(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, int n, F1<Position, Position> f1, CompileOrder compileOrder) {
        this.classpath = fileArray;
        this.sources = fileArray2;
        this.classesDirectory = file;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.maxErrors = n;
        this.sourcePositionMapper = f1;
        this.order = compileOrder;
    }

    public File[] classpath() {
        return this.classpath;
    }

    public File[] sources() {
        return this.sources;
    }

    public File classesDirectory() {
        return this.classesDirectory;
    }

    public String[] scalacOptions() {
        return this.scalacOptions;
    }

    public String[] javacOptions() {
        return this.javacOptions;
    }

    public int maxErrors() {
        return this.maxErrors;
    }

    public F1<Position, Position> sourcePositionMapper() {
        return this.sourcePositionMapper;
    }

    public CompileOrder order() {
        return this.order;
    }

    public CompileOptions withClasspath(File[] fileArray) {
        return new CompileOptions(fileArray, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order);
    }

    public CompileOptions withSources(File[] fileArray) {
        return new CompileOptions(this.classpath, fileArray, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order);
    }

    public CompileOptions withClassesDirectory(File file) {
        return new CompileOptions(this.classpath, this.sources, file, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order);
    }

    public CompileOptions withScalacOptions(String[] stringArray) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, stringArray, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order);
    }

    public CompileOptions withJavacOptions(String[] stringArray) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, stringArray, this.maxErrors, this.sourcePositionMapper, this.order);
    }

    public CompileOptions withMaxErrors(int n) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, n, this.sourcePositionMapper, this.order);
    }

    public CompileOptions withSourcePositionMapper(F1<Position, Position> f1) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, f1, this.order);
    }

    public CompileOptions withOrder(CompileOrder compileOrder) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, compileOrder);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompileOptions)) {
            return false;
        }
        CompileOptions compileOptions = (CompileOptions)object;
        return Arrays.deepEquals(this.classpath(), compileOptions.classpath()) && Arrays.deepEquals(this.sources(), compileOptions.sources()) && this.classesDirectory().equals(compileOptions.classesDirectory()) && Arrays.deepEquals(this.scalacOptions(), compileOptions.scalacOptions()) && Arrays.deepEquals(this.javacOptions(), compileOptions.javacOptions()) && this.maxErrors() == compileOptions.maxErrors() && this.sourcePositionMapper().equals(compileOptions.sourcePositionMapper()) && this.order().equals((Object)compileOptions.order());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + this.classpath().hashCode()) + this.sources().hashCode()) + this.classesDirectory().hashCode()) + this.scalacOptions().hashCode()) + this.javacOptions().hashCode()) + new Integer(this.maxErrors()).hashCode()) + this.sourcePositionMapper().hashCode()) + this.order().hashCode());
    }

    public String toString() {
        return "CompileOptions(classpath: " + this.classpath() + ", sources: " + this.sources() + ", classesDirectory: " + this.classesDirectory() + ", scalacOptions: " + this.scalacOptions() + ", javacOptions: " + this.javacOptions() + ", maxErrors: " + this.maxErrors() + ", sourcePositionMapper: " + this.sourcePositionMapper() + ", order: " + (Object)((Object)this.order()) + ")";
    }
}

