/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.transform;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.Trees$Annotated$;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.ast.tpd$TreeOps$;
import dotty.tools.dotc.config.Feature$;
import dotty.tools.dotc.config.NoScalaVersion$;
import dotty.tools.dotc.config.ScalaVersion;
import dotty.tools.dotc.config.ScalaVersion$;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Annotations;
import dotty.tools.dotc.core.Constants;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.Types$AnnotatedType$;
import dotty.tools.dotc.core.Types$TermRef$;
import dotty.tools.dotc.core.Types$TypeRef$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.IllegalUnrollPlacement;
import dotty.tools.dotc.reporting.NoExplanation;
import dotty.tools.dotc.reporting.SymbolChangedSemanticsInVersion;
import dotty.tools.dotc.reporting.SymbolHasUnparsableVersionNumber;
import dotty.tools.dotc.transform.CrossVersionChecks$;
import dotty.tools.dotc.transform.MegaPhase;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class CrossVersionChecks
extends MegaPhase.MiniPhase {
    public static void checkDeprecatedRef(Symbols.Symbol symbol, SrcPos srcPos, Contexts.Context context) {
        CrossVersionChecks$.MODULE$.checkDeprecatedRef(symbol, srcPos, context);
    }

    public static void checkExperimentalRef(Symbols.Symbol symbol, SrcPos srcPos, Contexts.Context context) {
        CrossVersionChecks$.MODULE$.checkExperimentalRef(symbol, srcPos, context);
    }

    public static void checkPreviewFeatureRef(Symbols.Symbol symbol, SrcPos srcPos, Contexts.Context context) {
        CrossVersionChecks$.MODULE$.checkPreviewFeatureRef(symbol, srcPos, context);
    }

    public static void checkRef(Symbols.Symbol symbol, SrcPos srcPos, Contexts.Context context) {
        CrossVersionChecks$.MODULE$.checkRef(symbol, srcPos, context);
    }

    public static String name() {
        return CrossVersionChecks$.MODULE$.name();
    }

    @Override
    public String phaseName() {
        return CrossVersionChecks$.MODULE$.name();
    }

    @Override
    public String description() {
        return CrossVersionChecks$.MODULE$.description();
    }

    private void checkUndesiredProperties(Symbols.Symbol sym, SrcPos pos, Contexts.Context x$3) {
        ScalaVersion xMigrationValue;
        CrossVersionChecks$.MODULE$.checkRef(sym, pos, x$3);
        ScalaVersion scalaVersion = xMigrationValue = (ScalaVersion)Settings$Setting$.MODULE$.value(x$3.settings().Xmigration(), x$3);
        NoScalaVersion$ noScalaVersion$ = NoScalaVersion$.MODULE$;
        if (scalaVersion == null ? noScalaVersion$ != null : !scalaVersion.equals(noScalaVersion$)) {
            this.checkMigration(sym, pos, xMigrationValue, x$3);
            return;
        }
    }

    private void checkExperimentalAnnots(Symbols.Symbol sym, Contexts.Context x$2) {
        if (Symbols$.MODULE$.toDenot(sym, x$2).exists() && !Symbols$.MODULE$.isInExperimentalScope(sym, x$2)) {
            Symbols$.MODULE$.toDenot(sym, x$2).annotations(x$2).withFilter((Function1 & Serializable)annot -> Symbols$.MODULE$.isExperimental(annot.symbol(x$2), x$2)).foreach((Function1)(JProcedure1 & Serializable)annot -> Feature$.MODULE$.checkExperimentalDef(annot.symbol(x$2), annot.tree(x$2), x$2));
            return;
        }
    }

    private void checkMigration(Symbols.Symbol sym, SrcPos pos, ScalaVersion xMigrationValue, Contexts.Context x$4) {
        Symbols$.MODULE$.toDenot(sym, x$4).getAnnotation(Symbols$.MODULE$.defn(x$4).MigrationAnnot(), x$4).foreach((Function1)(JProcedure1 & Serializable)annot -> {
            ScalaVersion symVersion;
            Try<ScalaVersion> migrationVersion = ScalaVersion$.MODULE$.parse(((Constants.Constant)annot.argumentConstant(1, x$4).get()).stringValue());
            Try<ScalaVersion> try_ = migrationVersion;
            if (try_ instanceof Success && xMigrationValue.$less(symVersion = (ScalaVersion)((Success)try_).value())) {
                String msg = ((Constants.Constant)annot.argumentConstant(0, x$4).get()).stringValue();
                report$.MODULE$.warning(new SymbolChangedSemanticsInVersion(sym, symVersion, msg, x$4), pos, x$4);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                String x$proxy1 = ex.getMessage();
                if (x$proxy1 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                report$.MODULE$.warning(new SymbolHasUnparsableVersionNumber(sym, x$proxy1, x$4), pos, x$4);
                return;
            }
        });
    }

    private void checkDeprecatedOvers(Trees.Tree<Types.Type> tree, Contexts.Context x$2) {
        Symbols.Symbol symbol = tree.symbol(x$2);
        if (Symbols$.MODULE$.isDeprecated(symbol, x$2)) {
            Iterator concrOvers = Symbols$.MODULE$.toDenot(symbol, x$2).allOverriddenSymbols(x$2).filter((Function1 & Serializable)sym -> !Symbols$.MODULE$.isDeprecated((Symbols.Symbol)sym, x$2) && !Symbols$.MODULE$.toDenot((Symbols.Symbol)sym, x$2).is(Flags$.MODULE$.Deferred(), x$2));
            if (!concrOvers.isEmpty()) {
                report$.MODULE$.deprecationWarning(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " overrides concrete, non-deprecated definition(s):\n              |    ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply((Object)symbol), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)concrOvers.map((Function1 & Serializable)_$1 -> _$1.name(x$2)).mkString(", "))}), x$2), tree.srcPos(), report$.MODULE$.deprecationWarning$default$3(), x$2);
                return;
            }
            return;
        }
    }

    public void checkDeprecatedInheritance(List<Trees.Tree<Types.Type>> parents, Contexts.Context x$2) {
        parents.map((Function1 & Serializable)parent -> {
            Symbols.Symbol psym = ((Types.Type)parent.tpe()).classSymbol(x$2);
            return Tuple2$.MODULE$.apply(parent, (Object)psym);
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            Trees.Tree parent = (Trees.Tree)tuple2._1();
            Symbols.Symbol psym = (Symbols.Symbol)tuple2._2();
            Symbols$.MODULE$.toDenot(psym, x$2).getAnnotation(Symbols$.MODULE$.defn(x$2).DeprecatedInheritanceAnnot(), x$2).withFilter((Function1 & Serializable)annot -> !CrossVersionChecks$.MODULE$.dotty$tools$dotc$transform$CrossVersionChecks$$$skipWarning(psym, x$2)).foreach((Function1)(JProcedure1 & Serializable)annot -> {
                String msg2 = (String)annot.argumentConstantString(0, x$2).map((Function1 & Serializable)msg -> new StringBuilder(2).append(": ").append((String)msg).toString()).getOrElse(CrossVersionChecks::$anonfun$3);
                String since = (String)annot.argumentConstantString(1, x$2).map((Function1 & Serializable)version -> new StringBuilder(10).append(" (since: ").append((String)version).append(")").toString()).getOrElse(CrossVersionChecks::$anonfun$5);
                NoExplanation composed = Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inheritance from ", " is deprecated", "", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply((Object)psym), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)since), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)msg2)}), x$2);
                report$.MODULE$.deprecationWarning(composed, parent.srcPos(), psym.showFullName(x$2), x$2);
            });
        });
    }

    private void unrollError(SrcPos pos, Contexts.Context x$2) {
        report$.MODULE$.error(new IllegalUnrollPlacement((Option<Symbols.Symbol>)None$.MODULE$, x$2), pos, x$2);
    }

    private void checkUnrollAnnot(Symbols.Symbol annotSym, SrcPos pos, Contexts.Context x$3) {
        Symbols.Symbol symbol = annotSym;
        Symbols.ClassSymbol classSymbol = Symbols$.MODULE$.defn(x$3).UnrollAnnot();
        if (!(symbol != null ? !symbol.equals(classSymbol) : classSymbol != null)) {
            this.unrollError(pos, x$3);
            return;
        }
    }

    private void checkUnrollMemberDef(Trees.MemberDef<Types.Type> memberDef, Contexts.Context x$2) {
        Symbols.Symbol sym = memberDef.symbol(x$2);
        if (!(!Symbols$.MODULE$.toDenot(sym, x$2).hasAnnotation(Symbols$.MODULE$.defn(x$2).UnrollAnnot(), x$2) || sym.isTerm(x$2) && Symbols$.MODULE$.toDenot(sym, x$2).is(Flags$.MODULE$.Param(), x$2))) {
            Symbols.Symbol normSym = Symbols$.MODULE$.toDenot(sym, x$2).is(Flags$.MODULE$.ModuleVal(), x$2) ? Symbols$.MODULE$.toDenot(sym, x$2).moduleClass(x$2) : sym;
            this.unrollError(normSym.srcPos(), x$2);
            return;
        }
    }

    public Trees.ValDef<Types.Type> transformValDef(Trees.ValDef<Types.Type> tree, Contexts.Context x$2) {
        this.checkUnrollMemberDef(tree, x$2);
        this.checkDeprecatedOvers(tree, x$2);
        this.checkExperimentalAnnots(tree.symbol(x$2), x$2);
        return tree;
    }

    public Trees.DefDef<Types.Type> transformDefDef(Trees.DefDef<Types.Type> tree, Contexts.Context x$2) {
        this.checkUnrollMemberDef(tree, x$2);
        this.checkDeprecatedOvers(tree, x$2);
        this.checkExperimentalAnnots(tree.symbol(x$2), x$2);
        return tree;
    }

    public Trees.TypeDef<Types.Type> transformTypeDef(Trees.TypeDef<Types.Type> tree, Contexts.Context x$2) {
        this.checkUnrollMemberDef(tree, x$2);
        this.checkExperimentalAnnots(tree.symbol(x$2), x$2);
        return tree;
    }

    @Override
    public Trees.Tree<Types.Type> transformTemplate(Trees.Template<Types.Type> tree, Contexts.Context x$2) {
        this.checkDeprecatedInheritance(tree.parents(x$2), x$2);
        return tree;
    }

    public Trees.Ident<Types.Type> transformIdent(Trees.Ident<Types.Type> tree, Contexts.Context x$2) {
        this.checkUndesiredProperties(tree.symbol(x$2), tree.srcPos(), x$2);
        return tree;
    }

    public Trees.Select<Types.Type> transformSelect(Trees.Select<Types.Type> tree, Contexts.Context x$2) {
        this.checkUndesiredProperties(tree.symbol(x$2), tree.srcPos(), x$2);
        return tree;
    }

    public Trees.New<Types.Type> transformNew(Trees.New<Types.Type> tree, Contexts.Context x$2) {
        this.checkUndesiredProperties(((Types.Type)tree.tpe()).typeSymbol(x$2), tree.srcPos(), x$2);
        return tree;
    }

    public Trees.TypeTree<Types.Type> transformTypeTree(Trees.TypeTree<Types.Type> tree, Contexts.Context x$2) {
        Object tpe = tree.tpe();
        ((Types.Type)tpe).foreachPart((Function1<Types.Type, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
            Types.Type type = x$1;
            if (type instanceof Types.TypeRef) {
                Types.TypeRef typeRef = Types$TypeRef$.MODULE$.unapply((Types.TypeRef)type);
                Types.Type type2 = typeRef._1();
                Names.Designator designator = typeRef._2();
                if (designator instanceof Symbols.Symbol) {
                    Symbols.Symbol sym = (Symbols.Symbol)designator;
                    if (Spans$Span$.MODULE$.isSourceDerived$extension(tree.span())) {
                        CrossVersionChecks$.MODULE$.checkDeprecatedRef(sym, tree.srcPos(), x$2);
                    }
                    CrossVersionChecks$.MODULE$.checkExperimentalRef(sym, tree.srcPos(), x$2);
                    CrossVersionChecks$.MODULE$.checkPreviewFeatureRef(sym, tree.srcPos(), x$2);
                    return;
                }
            }
            if (type instanceof Types.TermRef) {
                Types.TermRef termRef = Types$TermRef$.MODULE$.unapply((Types.TermRef)type);
                Types.Type type3 = termRef._1();
                Names.Designator designator = termRef._2();
                if (designator instanceof Symbols.Symbol) {
                    Symbols.Symbol sym = (Symbols.Symbol)designator;
                    if (Spans$Span$.MODULE$.isSourceDerived$extension(tree.span())) {
                        CrossVersionChecks$.MODULE$.checkDeprecatedRef(sym, tree.srcPos(), x$2);
                    }
                    CrossVersionChecks$.MODULE$.checkExperimentalRef(sym, tree.srcPos(), x$2);
                    CrossVersionChecks$.MODULE$.checkPreviewFeatureRef(sym, tree.srcPos(), x$2);
                    return;
                }
            }
            if (type instanceof Types.AnnotatedType) {
                Annotations.Annotation annotation;
                Types.AnnotatedType annotatedType = Types$AnnotatedType$.MODULE$.unapply((Types.AnnotatedType)type);
                Types.Type type4 = annotatedType._1();
                Annotations.Annotation annot = annotation = annotatedType._2();
                this.checkUnrollAnnot(annot.symbol(x$2), tree.srcPos(), x$2);
                return;
            }
        }, ((Types.Type)tpe).foreachPart$default$2(), x$2);
        return tree;
    }

    @Override
    public Trees.Tree<Types.Type> transformOther(Trees.Tree<Types.Type> tree, Contexts.Context x$2) {
        Trees.Tree<Types.Type> tree2;
        boolean inPackage;
        boolean bl = inPackage = Symbols$.MODULE$.toDenot(x$2.owner(), x$2).is(Flags$.MODULE$.Package(), x$2) || Symbols$.MODULE$.toDenot(x$2.owner(), x$2).isPackageObject(x$2);
        if (!(inPackage && tree instanceof Trees.ImportOrExport && Feature$.MODULE$.isExperimentalEnabledByImport(x$2))) {
            Trees.Tree tree3 = tpd$.MODULE$.TreeOps(tree);
            tpd$TreeOps$.MODULE$.foreachSubTree$extension(tree3, (Function1<Trees.Tree<Types.Type>, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
                Trees.Tree tree = x$1;
                if (tree instanceof Trees.Ident) {
                    Trees.Ident tree2 = (Trees.Ident)tree;
                    this.transformIdent(tree2, x$2);
                    return;
                }
                if (tree instanceof Trees.Select) {
                    Trees.Select tree3 = (Trees.Select)tree;
                    this.transformSelect(tree3, x$2);
                    return;
                }
                if (tree instanceof Trees.TypeTree) {
                    Trees.TypeTree tree4 = (Trees.TypeTree)tree;
                    this.transformTypeTree(tree4, x$2);
                    return;
                }
            }, x$2);
        }
        if ((tree2 = tree) instanceof Trees.Annotated) {
            Trees.Tree tree4;
            Trees.Annotated annotated = Trees$Annotated$.MODULE$.unapply((Trees.Annotated)tree2);
            Trees.Tree tree5 = annotated._1();
            Trees.Tree annot = tree4 = annotated._2();
            this.checkUnrollAnnot(((Types.Type)annot.tpe()).typeSymbol(x$2), tree.srcPos(), x$2);
            return tree;
        }
        Trees.Tree<Types.Type> tree6 = tree2;
        return tree6;
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final String $anonfun$5() {
        return "";
    }
}

