/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.classfile;

import dotty.tools.dotc.core.classfile.DataReader;
import dotty.tools.io.AbstractFile;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class ReusableDataReader
implements DataReader {
    private byte[] data = new byte[32768];
    public ByteBuffer dotty$tools$dotc$core$classfile$ReusableDataReader$$bb = ByteBuffer.wrap(this.data);
    private int size = 0;
    private final DataInputStream reader;

    public ReusableDataReader() {
        InputStream stream = new InputStream(this){
            private final /* synthetic */ ReusableDataReader $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int read() {
                int n;
                try {
                    n = this.$outer.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.get() & 0xFF;
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    n = -1;
                }
                return n;
            }

            public int read(byte[] b, int off, int len) {
                int pos = this.$outer.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position();
                this.$outer.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.get(b, off, len);
                return this.$outer.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position() - pos;
            }

            public boolean markSupported() {
                return false;
            }
        };
        this.reader = new DataInputStream(stream);
    }

    @Override
    public byte[] buf() {
        return this.data;
    }

    private int nextPositivePowerOfTwo(int target) {
        return 1 << -Integer.numberOfLeadingZeros(target - 1);
    }

    public ReusableDataReader reset(AbstractFile file) {
        this.size = 0;
        Option<Object> option = file.sizeOption();
        if (option instanceof Some) {
            int size = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            if (size > this.data.length) {
                this.data = new byte[this.nextPositivePowerOfTwo(size)];
            } else {
                Arrays.fill(this.data, (byte)0);
            }
            try (InputStream input = file.input();){
                boolean endOfInput = false;
                while (!endOfInput) {
                    int remaining = this.data.length - this.size;
                    if (remaining == 0) {
                        endOfInput = true;
                        continue;
                    }
                    int read = input.read(this.data, this.size, remaining);
                    if (read < 0) {
                        endOfInput = true;
                        continue;
                    }
                    this.size += read;
                }
                this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb = ByteBuffer.wrap(this.data, 0, size);
            }
        } else if (None$.MODULE$.equals(option)) {
            try (InputStream input = file.input();){
                boolean endOfInput = false;
                while (!endOfInput) {
                    int read;
                    int remaining = this.data.length - this.size;
                    if (remaining == 0) {
                        this.data = Arrays.copyOf(this.data, this.nextPositivePowerOfTwo(this.size));
                    }
                    if ((read = input.read(this.data, this.size, this.data.length - this.size)) < 0) {
                        endOfInput = true;
                        continue;
                    }
                    this.size += read;
                }
                this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb = ByteBuffer.wrap(this.data, 0, this.size);
            }
        } else {
            throw new MatchError(option);
        }
        return this;
    }

    @Override
    public byte nextByte() throws IndexOutOfBoundsException {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.get();
    }

    @Override
    public byte[] nextBytes(int len) {
        byte[] result = new byte[len];
        this.reader.readFully(result);
        return result;
    }

    @Override
    public char nextChar() {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.getChar();
    }

    @Override
    public int nextInt() {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.getInt();
    }

    @Override
    public char getChar(int mybp) {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.getChar(mybp);
    }

    @Override
    public int getInt(int mybp) {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.getInt(mybp);
    }

    @Override
    public long getLong(int mybp) {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.getLong(mybp);
    }

    @Override
    public float getFloat(int mybp) {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.getFloat(mybp);
    }

    @Override
    public double getDouble(int mybp) {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.getDouble(mybp);
    }

    @Override
    public void skip(int n) {
        this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position(this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position() + n);
    }

    @Override
    public int bp() {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position();
    }

    @Override
    public void bp_$eq(int i) {
        this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position(i);
    }

    @Override
    public byte getByte(int mybp) {
        return this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.get(mybp);
    }

    @Override
    public void getBytes(int mybp, byte[] bytes) {
        int saved = this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position();
        this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position(mybp);
        try {
            this.reader.readFully(bytes);
        }
        finally {
            this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position(saved);
        }
    }

    @Override
    public String getUTF(int mybp, int len) {
        String string;
        int saved = this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position();
        int savedLimit = this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.limit();
        this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position(mybp);
        this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.limit(mybp + len);
        try {
            string = this.reader.readUTF();
        }
        finally {
            this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.limit(savedLimit);
            this.dotty$tools$dotc$core$classfile$ReusableDataReader$$bb.position(saved);
        }
        return string;
    }
}

