/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.dotc.classpath.DirectoryLookup;
import dotty.tools.dotc.classpath.FileUtils$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.PlainFile$;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Scala3RunTime$;

public interface JFileDirectoryLookup<FileEntryType extends ClassRepresentation>
extends DirectoryLookup<FileEntryType> {
    public static void $init$(JFileDirectoryLookup $this) {
        if ((File)$this.dir() == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Directory file in DirectoryFileLookup cannot be null");
        }
    }

    public static File[] emptyFiles$(JFileDirectoryLookup $this) {
        return $this.emptyFiles();
    }

    default public File[] emptyFiles() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public static Option getSubDir$(JFileDirectoryLookup $this, String packageDirName) {
        return $this.getSubDir(packageDirName);
    }

    @Override
    default public Option<File> getSubDir(String packageDirName) {
        File packageDir = new File((File)this.dir(), packageDirName);
        if (packageDir.exists() && packageDir.isDirectory()) {
            return Some$.MODULE$.apply((Object)packageDir);
        }
        return None$.MODULE$;
    }

    public static File[] listChildren$(JFileDirectoryLookup $this, File dir, Option filter) {
        return $this.listChildren(dir, (Option<Function1<File, Object>>)filter);
    }

    default public File[] listChildren(File dir, Option<Function1<File, Object>> filter) {
        File[] fileArray;
        Option<Function1<File, Object>> option = filter;
        if (option instanceof Some) {
            Function1 f = (Function1)((Some)option).value();
            fileArray = dir.listFiles(FileUtils$.MODULE$.mkFileFilter((Function1<File, Object>)f));
        } else if (None$.MODULE$.equals(option)) {
            fileArray = dir.listFiles();
        } else {
            throw new MatchError(option);
        }
        File[] listing = fileArray;
        if (listing != null) {
            Arrays.sort(listing, new Comparator<File>(){

                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return listing;
        }
        return new File[0];
    }

    public static String getName$(JFileDirectoryLookup $this, File f) {
        return $this.getName(f);
    }

    default public String getName(File f) {
        return f.getName();
    }

    public static AbstractFile toAbstractFile$(JFileDirectoryLookup $this, File f) {
        return $this.toAbstractFile(f);
    }

    default public AbstractFile toAbstractFile(File f) {
        return PlainFile$.MODULE$.toPlainFile(f.toPath());
    }

    public static boolean isPackage$(JFileDirectoryLookup $this, File f) {
        return $this.isPackage(f);
    }

    default public boolean isPackage(File f) {
        return FileUtils$.MODULE$.isPackage(f);
    }

    public static Seq asURLs$(JFileDirectoryLookup $this) {
        return $this.asURLs();
    }

    @Override
    default public Seq<URL> asURLs() {
        return (Seq)((SeqOps)new .colon.colon((Object)((File)this.dir()).toURI().toURL(), (List)Nil$.MODULE$));
    }

    public static Seq asClassPathStrings$(JFileDirectoryLookup $this) {
        return $this.asClassPathStrings();
    }

    @Override
    default public Seq<String> asClassPathStrings() {
        return (Seq)((SeqOps)new .colon.colon((Object)((File)this.dir()).getPath(), (List)Nil$.MODULE$));
    }
}

