/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.dotc.Run;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.SourceVersion;
import dotty.tools.dotc.config.SourceVersion$;
import dotty.tools.dotc.core.Annotations;
import dotty.tools.dotc.core.Annotations$ExperimentalAnnotation$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.NameKinds$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.typer.ImportInfo;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public final class Feature$
implements Serializable {
    private static final Names.TermName namedTypeArguments;
    private static final Names.TermName genericNumberLiterals;
    private static final Names.TermName scala2macros;
    private static final Names.TermName dependent;
    private static final Names.TermName erasedDefinitions;
    private static final Names.TermName symbolLiterals;
    private static final Names.TermName fewerBraces;
    private static final Names.TermName saferExceptions;
    private static final Names.TermName clauseInterleaving;
    private static final Names.TermName pureFunctions;
    private static final Names.TermName captureChecking;
    private static final Names.TermName into;
    private static final Names.TermName modularity;
    private static final Names.TermName betterMatchTypeExtractors;
    private static final Names.TermName quotedPatternsWithPolymorphicFunctions;
    private static final Names.TermName betterFors;
    private static final List<Tuple2<Names.TermName, String>> values;
    private static final List<String> legacyFeatures;
    public static final Feature$ MODULE$;

    private Feature$() {
    }

    static {
        MODULE$ = new Feature$();
        namedTypeArguments = MODULE$.experimental("namedTypeArguments");
        genericNumberLiterals = MODULE$.experimental("genericNumberLiterals");
        scala2macros = MODULE$.experimental("macros");
        dependent = MODULE$.experimental("dependent");
        erasedDefinitions = MODULE$.experimental("erasedDefinitions");
        symbolLiterals = MODULE$.deprecated("symbolLiterals");
        fewerBraces = MODULE$.experimental("fewerBraces");
        saferExceptions = MODULE$.experimental("saferExceptions");
        clauseInterleaving = MODULE$.experimental("clauseInterleaving");
        pureFunctions = MODULE$.experimental("pureFunctions");
        captureChecking = MODULE$.experimental("captureChecking");
        into = MODULE$.experimental("into");
        modularity = MODULE$.experimental("modularity");
        betterMatchTypeExtractors = MODULE$.experimental("betterMatchTypeExtractors");
        quotedPatternsWithPolymorphicFunctions = MODULE$.experimental("quotedPatternsWithPolymorphicFunctions");
        betterFors = MODULE$.experimental("betterFors");
        values = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(StdNames$.MODULE$.nme().help(), (Object)"Display all available features"), Tuple2$.MODULE$.apply(StdNames$.MODULE$.nme().noAutoTupling(), (Object)"Disable automatic tupling"), Tuple2$.MODULE$.apply(StdNames$.MODULE$.nme().dynamics(), (Object)"Allow direct or indirect subclasses of scala.Dynamic"), Tuple2$.MODULE$.apply(StdNames$.MODULE$.nme().unsafeNulls(), (Object)"Enable unsafe nulls for explicit nulls"), Tuple2$.MODULE$.apply(StdNames$.MODULE$.nme().postfixOps(), (Object)"Allow postfix operators (not recommended)"), Tuple2$.MODULE$.apply(StdNames$.MODULE$.nme().strictEquality(), (Object)"Enable strict equality (disable canEqualAny)"), Tuple2$.MODULE$.apply(StdNames$.MODULE$.nme().implicitConversions(), (Object)"Allow implicit conversions without warnings"), Tuple2$.MODULE$.apply(StdNames$.MODULE$.nme().adhocExtensions(), (Object)"Allow ad-hoc extension methods"), Tuple2$.MODULE$.apply((Object)namedTypeArguments, (Object)"Allow named type arguments"), Tuple2$.MODULE$.apply((Object)genericNumberLiterals, (Object)"Allow generic number literals"), Tuple2$.MODULE$.apply((Object)MODULE$.scala2macros(), (Object)"Allow Scala 2 macros"), Tuple2$.MODULE$.apply((Object)MODULE$.dependent(), (Object)"Allow dependent method types"), Tuple2$.MODULE$.apply((Object)MODULE$.erasedDefinitions(), (Object)"Allow erased definitions"), Tuple2$.MODULE$.apply((Object)MODULE$.symbolLiterals(), (Object)"Allow symbol literals"), Tuple2$.MODULE$.apply((Object)MODULE$.fewerBraces(), (Object)"Enable support for using indentation for arguments"), Tuple2$.MODULE$.apply((Object)MODULE$.saferExceptions(), (Object)"Enable safer exceptions"), Tuple2$.MODULE$.apply((Object)MODULE$.clauseInterleaving(), (Object)"Enable clause interleaving"), Tuple2$.MODULE$.apply((Object)MODULE$.pureFunctions(), (Object)"Enable pure functions for capture checking"), Tuple2$.MODULE$.apply((Object)MODULE$.captureChecking(), (Object)"Enable experimental capture checking"), Tuple2$.MODULE$.apply((Object)MODULE$.into(), (Object)"Allow into modifier on parameter types"), Tuple2$.MODULE$.apply((Object)MODULE$.modularity(), (Object)"Enable experimental modularity features"), Tuple2$.MODULE$.apply((Object)MODULE$.betterMatchTypeExtractors(), (Object)"Enable better match type extractors"), Tuple2$.MODULE$.apply((Object)MODULE$.betterFors(), (Object)"Enable improvements in `for` comprehensions")}));
        legacyFeatures = (List)new .colon.colon((Object)"higherKinds", (List)new .colon.colon((Object)"existentials", (List)new .colon.colon((Object)"reflectiveCalls", (List)Nil$.MODULE$)));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Feature$.class);
    }

    public Names.TermName experimental(Object str) {
        return NameKinds$.MODULE$.QualifiedName().apply((Names.TermName)StdNames$.MODULE$.nme().experimental(), Decorators$.MODULE$.toTermName(str));
    }

    private Names.TermName deprecated(Object str) {
        return NameKinds$.MODULE$.QualifiedName().apply((Names.TermName)StdNames$.MODULE$.nme().deprecated(), Decorators$.MODULE$.toTermName(str));
    }

    public Names.TermName scala2macros() {
        return scala2macros;
    }

    public Names.TermName dependent() {
        return dependent;
    }

    public Names.TermName erasedDefinitions() {
        return erasedDefinitions;
    }

    public Names.TermName symbolLiterals() {
        return symbolLiterals;
    }

    public Names.TermName fewerBraces() {
        return fewerBraces;
    }

    public Names.TermName saferExceptions() {
        return saferExceptions;
    }

    public Names.TermName clauseInterleaving() {
        return clauseInterleaving;
    }

    public Names.TermName pureFunctions() {
        return pureFunctions;
    }

    public Names.TermName captureChecking() {
        return captureChecking;
    }

    public Names.TermName into() {
        return into;
    }

    public Names.TermName modularity() {
        return modularity;
    }

    public Names.TermName betterMatchTypeExtractors() {
        return betterMatchTypeExtractors;
    }

    public Names.TermName quotedPatternsWithPolymorphicFunctions() {
        return quotedPatternsWithPolymorphicFunctions;
    }

    public Names.TermName betterFors() {
        return betterFors;
    }

    public List<Names.TermName> experimentalAutoEnableFeatures(Contexts.Context x$1) {
        return Symbols$.MODULE$.defn(x$1).languageExperimentalFeatures().map((Function1 & Serializable)sym -> MODULE$.experimental(sym.name(x$1))).filterNot((Function1 & Serializable)_$1 -> {
            Names.TermName termName = _$1;
            Names.TermName termName2 = MODULE$.captureChecking();
            return !(termName != null ? !((Object)termName).equals(termName2) : termName2 != null);
        });
    }

    public List<Tuple2<Names.TermName, String>> values() {
        return values;
    }

    public List<String> legacyFeatures() {
        return legacyFeatures;
    }

    private List<String> enabledLanguageFeaturesBySetting(Contexts.Context x$1) {
        return (List)Settings$Setting$.MODULE$.value(x$1.settings().language(), x$1);
    }

    public boolean enabledBySetting(Names.TermName feature, Contexts.Context x$2) {
        return this.enabledLanguageFeaturesBySetting(x$2).contains((Object)feature.toString());
    }

    public boolean enabledByImport(Names.TermName feature, Contexts.Context x$2) {
        ImportInfo info = x$2.importInfo();
        return info != null && info.featureImported(feature, x$2);
    }

    public boolean enabled(Names.TermName feature, Contexts.Context x$2) {
        return this.enabledBySetting(feature, x$2) || this.enabledByImport(feature, x$2);
    }

    public boolean autoTuplingEnabled(Contexts.Context x$1) {
        return !this.enabled((Names.TermName)StdNames$.MODULE$.nme().noAutoTupling(), x$1);
    }

    public boolean dynamicsEnabled(Contexts.Context x$1) {
        return this.enabled((Names.TermName)StdNames$.MODULE$.nme().dynamics(), x$1);
    }

    public boolean dependentEnabled(Contexts.Context x$1) {
        return this.enabled(this.dependent(), x$1);
    }

    public boolean namedTypeArgsEnabled(Contexts.Context x$1) {
        return this.enabled(namedTypeArguments, x$1);
    }

    public boolean clauseInterleavingEnabled(Contexts.Context x$1) {
        return this.sourceVersion(x$1).isAtLeast(SourceVersion$.3$u002E6) || this.enabled(this.clauseInterleaving(), x$1);
    }

    public boolean betterForsEnabled(Contexts.Context x$1) {
        return this.enabled(this.betterFors(), x$1);
    }

    public boolean genericNumberLiteralsEnabled(Contexts.Context x$1) {
        return this.enabled(genericNumberLiterals, x$1);
    }

    public boolean scala2ExperimentalMacroEnabled(Contexts.Context x$1) {
        return this.enabled(this.scala2macros(), x$1);
    }

    public boolean quotedPatternsWithPolymorphicFunctionsEnabled(Contexts.Context x$1) {
        return this.enabled(this.quotedPatternsWithPolymorphicFunctions(), x$1);
    }

    public boolean pureFunsEnabled(Contexts.Context x$1) {
        return this.enabledBySetting(this.pureFunctions(), x$1) || x$1.compilationUnit().knowsPureFuns() || this.ccEnabled(x$1);
    }

    public boolean ccEnabled(Contexts.Context x$1) {
        return this.enabledBySetting(this.captureChecking(), x$1) || x$1.compilationUnit().needsCaptureChecking();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pureFunsEnabledSomewhere(Contexts.Context x$1) {
        if (this.enabledBySetting(this.pureFunctions(), x$1)) return true;
        if (x$1.run() != null) {
            Run x$proxy1 = x$1.run();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (x$proxy1.pureFunsImportEncountered()) return true;
        }
        if (!this.ccEnabledSomewhere(x$1)) return false;
        return true;
    }

    public boolean ccEnabledSomewhere(Contexts.Context x$1) {
        if (x$1.run() != null) {
            Run x$proxy2 = x$1.run();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy2.ccEnabledSomewhere();
        }
        return this.enabledBySetting(this.captureChecking(), x$1);
    }

    public SourceVersion sourceVersionSetting(Contexts.Context x$1) {
        return SourceVersion$.MODULE$.valueOf((String)Settings$Setting$.MODULE$.value(x$1.settings().source(), x$1));
    }

    public SourceVersion sourceVersion(Contexts.Context x$1) {
        Option<SourceVersion> option = x$1.compilationUnit().sourceVersion();
        if (option instanceof Some) {
            SourceVersion v = (SourceVersion)((Some)option).value();
            return v;
        }
        Option<SourceVersion> none = option;
        return this.sourceVersionSetting(x$1);
    }

    public boolean migrateTo3(Contexts.Context x$1) {
        SourceVersion sourceVersion = this.sourceVersion(x$1);
        SourceVersion sourceVersion2 = SourceVersion$.3$u002E0$minusmigration;
        return !(sourceVersion != null ? !sourceVersion.equals(sourceVersion2) : sourceVersion2 != null);
    }

    public boolean fewerBracesEnabled(Contexts.Context x$1) {
        return this.sourceVersion(x$1).isAtLeast(SourceVersion$.3$u002E3) || this.enabled(this.fewerBraces(), x$1);
    }

    public boolean warnOnMigration(Message msg, SrcPos pos, SourceVersion version, Contexts.Context x$4) {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (!this.sourceVersion(x$4).isMigrating()) break block2;
                        SourceVersion sourceVersion = this.sourceVersion(x$4).stable();
                        SourceVersion sourceVersion2 = version;
                        if (!(sourceVersion == null ? sourceVersion2 != null : !sourceVersion.equals(sourceVersion2))) break block3;
                    }
                    SourceVersion sourceVersion = version;
                    SourceVersion sourceVersion3 = SourceVersion$.3$u002E0;
                    if (!(sourceVersion == null ? sourceVersion3 != null : !sourceVersion.equals(sourceVersion3))) break block4;
                    SourceVersion sourceVersion4 = version;
                    SourceVersion sourceVersion5 = SourceVersion$.3$u002E1;
                    if (sourceVersion4 != null ? !sourceVersion4.equals(sourceVersion5) : sourceVersion5 != null) break block5;
                }
                if (!this.migrateTo3(x$4)) break block5;
            }
            report$.MODULE$.migrationWarning(msg, pos, x$4);
            return true;
        }
        return false;
    }

    public void checkExperimentalFeature(String which, SrcPos srcPos, Function0<String> note, Contexts.Context x$4) {
        if (!this.isExperimentalEnabled(x$4)) {
            report$.MODULE$.error((Function0<String>)((Function0 & Serializable)() -> Feature$.checkExperimentalFeature$$anonfun$1(which, note)), srcPos, x$4);
            return;
        }
    }

    public String checkExperimentalFeature$default$3() {
        return "";
    }

    private boolean ccException(Symbols.Symbol sym, Contexts.Context x$2) {
        return this.ccEnabled(x$2) && Symbols$.MODULE$.defn(x$2).ccExperimental().contains((Object)sym);
    }

    public void checkExperimentalDef(Symbols.Symbol sym, SrcPos srcPos, Contexts.Context x$3) {
        Symbols.Symbol experimentalSym;
        Symbols.Symbol symbol = Symbols$.MODULE$.toDenot(sym, x$3).hasAnnotation(Symbols$.MODULE$.defn(x$3).ExperimentalAnnot(), x$3) ? sym : (experimentalSym = Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, x$3).owner(), x$3).hasAnnotation(Symbols$.MODULE$.defn(x$3).ExperimentalAnnot(), x$3) ? Symbols$.MODULE$.toDenot(sym, x$3).owner() : Symbols$NoSymbol$.MODULE$);
        if (!this.isExperimentalEnabled(x$3) && !this.ccException(experimentalSym, x$3)) {
            String msg = (String)Symbols$.MODULE$.toDenot(experimentalSym, x$3).getAnnotation(Symbols$.MODULE$.defn(x$3).ExperimentalAnnot(), x$3).map((Function1 & Serializable)x$1 -> {
                String string;
                String msg;
                Annotations.Annotation annotation = x$1;
                Option<String> option = Annotations$ExperimentalAnnotation$.MODULE$.unapply(annotation, x$3);
                if (!option.isEmpty() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(msg = (string = (String)option.get())))) {
                    return new StringBuilder(2).append(": ").append(msg).toString();
                }
                return "";
            }).getOrElse(Feature$::$anonfun$2);
            String markedExperimental = Symbols$.MODULE$.toDenot(experimentalSym, x$3).exists() ? Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is marked @experimental", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply((Object)experimentalSym), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)msg)}), x$3) : Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " inherits @experimental", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply((Object)sym), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)msg)}), x$3);
            report$.MODULE$.error((Function0<String>)((Function0 & Serializable)() -> Feature$.checkExperimentalDef$$anonfun$1(markedExperimental)), srcPos, x$3);
            return;
        }
    }

    private String experimentalUseSite(String which) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(256).append("Experimental ").append(which).append(" may only be used under experimental mode:\n       |  1. in a definition marked as @experimental, or\n       |  2. an experimental feature is imported at the package level, or\n       |  3. compiling with the -experimental compiler flag.\n       |").toString()));
    }

    public boolean isExperimentalEnabled(Contexts.Context x$1) {
        return BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().experimental(), x$1)) || this.experimentalAutoEnableFeatures(x$1).exists((Function1 & Serializable)feature -> MODULE$.enabled((Names.TermName)feature, x$1));
    }

    public Option<Names.TermName> experimentalEnabledByLanguageSetting(Contexts.Context x$1) {
        return this.experimentalAutoEnableFeatures(x$1).find((Function1 & Serializable)feature -> MODULE$.enabledBySetting((Names.TermName)feature, x$1));
    }

    public boolean isExperimentalEnabledByImport(Contexts.Context x$1) {
        return this.experimentalAutoEnableFeatures(x$1).exists((Function1 & Serializable)feature -> MODULE$.enabledByImport((Names.TermName)feature, x$1));
    }

    public boolean handleGlobalLanguageImport(Names.TermName prefix, Names.Name imported, Contexts.Context x$3) {
        Names.TermName fullFeatureName;
        Names.TermName termName = fullFeatureName = NameKinds$.MODULE$.QualifiedName().apply(prefix, imported.asTermName());
        Names.TermName termName2 = this.pureFunctions();
        if (!(termName != null ? !((Object)termName).equals(termName2) : termName2 != null)) {
            x$3.compilationUnit().knowsPureFuns_$eq(true);
            if (x$3.run() != null) {
                Run x$proxy3 = x$3.run();
                if (x$proxy3 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy3.pureFunsImportEncountered_$eq(true);
            }
            return true;
        }
        Names.TermName termName3 = fullFeatureName;
        Names.TermName termName4 = this.captureChecking();
        if (!(termName3 != null ? !((Object)termName3).equals(termName4) : termName4 != null)) {
            x$3.compilationUnit().needsCaptureChecking_$eq(true);
            if (x$3.run() != null) {
                Run x$proxy4 = x$3.run();
                if (x$proxy4 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy4.ccEnabledSomewhere_$eq(true);
            }
            return true;
        }
        return false;
    }

    private static final String checkExperimentalFeature$$anonfun$1(String which$1, Function0 note$1) {
        return new StringBuilder(0).append(MODULE$.experimentalUseSite(which$1)).append(note$1.apply()).toString();
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final String checkExperimentalDef$$anonfun$1(String markedExperimental$1) {
        return new StringBuilder(2).append(markedExperimental$1).append("\n\n").append(MODULE$.experimentalUseSite("definition")).toString();
    }
}

