/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.AbstractFile$;
import dotty.tools.io.FileWriters$FileConflictException$;
import dotty.tools.io.FileWriters$FileWriter$;
import dotty.tools.io.FileWriters$TastyWriter$;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Properties$;
import scala.util.matching.Regex;

public final class FileWriters {

    public static final class DirEntryWriter
    implements FileWriter {
        private final Path base;
        private final ConcurrentHashMap<Path, Boolean> builtPaths;
        private final FileAttribute<?>[] noAttributes;
        private final boolean isWindows;
        private final EnumSet<StandardOpenOption> fastOpenOptions;
        private final EnumSet<StandardOpenOption> fallbackOpenOptions;

        public DirEntryWriter(Path base) {
            this.base = base;
            this.builtPaths = new ConcurrentHashMap();
            this.noAttributes = (FileAttribute[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileAttribute.class));
            this.isWindows = Properties$.MODULE$.isWin();
            this.fastOpenOptions = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            this.fallbackOpenOptions = EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }

        public ConcurrentHashMap<Path, Boolean> builtPaths() {
            return this.builtPaths;
        }

        public FileAttribute<?>[] noAttributes() {
            return this.noAttributes;
        }

        private void checkName(Path component, Contexts.Context x$2) {
            if (this.isWindows) {
                Regex specials = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9]"));
                String name = component.toString();
                specials.findPrefixOf((CharSequence)name).foreach((Function1)(JProcedure1 & Serializable)prefix -> {
                    if (prefix.length() == name.length() || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), prefix.length()) == '.') {
                        this.warnSpecial$1(name, x$2);
                        return;
                    }
                });
                return;
            }
        }

        public void ensureDirForPath(Path baseDir, Path filePath, Contexts.Context x$3) {
            Path parent = filePath.getParent();
            if (!this.builtPaths().containsKey(parent)) {
                Path path;
                parent.iterator().forEachRemaining(component -> this.checkName((Path)component, x$3));
                try {
                    path = Files.createDirectories(parent, this.noAttributes());
                }
                catch (FileAlreadyExistsException e) {
                    if (!Files.isDirectory(parent, new LinkOption[0])) {
                        throw new FileConflictException(new StringBuilder(78).append("Can't create directory ").append(parent).append("; there is an existing (non-directory) file in its path").toString(), e);
                    }
                    path = BoxedUnit.UNIT;
                }
                this.builtPaths().put(baseDir, Boolean.TRUE);
                for (Path current = parent; current != null && !(null == this.builtPaths().put(current, Boolean.TRUE)); current = current.getParent()) {
                }
            }
            this.checkName(filePath.getFileName(), x$3);
        }

        @Override
        public AbstractFile writeFile(String relativePath, byte[] bytes, Contexts.Context x$3) {
            FileChannel fileChannel;
            Path path = this.base.resolve(relativePath);
            this.ensureDirForPath(this.base, path, x$3);
            if (this.isWindows) {
                try {
                    fileChannel = FileChannel.open(path, this.fastOpenOptions, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    fileChannel = FileChannel.open(path, this.fallbackOpenOptions, new FileAttribute[0]);
                }
            } else {
                fileChannel = FileChannel.open(path, this.fallbackOpenOptions, new FileAttribute[0]);
            }
            FileChannel os = fileChannel;
            try {
                os.write(ByteBuffer.wrap(bytes), 0L);
            }
            catch (ClosedByInterruptException ex) {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(path));
                }
                catch (Throwable throwable) {
                    bl = BoxedUnit.UNIT;
                }
                throw ex;
            }
            try {
                os.close();
            }
            catch (FileConflictException e) {
                report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"error writing ", ": ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)path.toString()), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)e.getMessage())}), x$3), report$.MODULE$.error$default$2(), x$3);
            }
            catch (FileSystemException e) {
                if (BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$3.settings().Ydebug(), x$3))) {
                    e.printStackTrace();
                }
                report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"error writing ", ": ", " ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)path.toString()), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)e.getClass().getName()), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)e.getMessage())}), x$3), report$.MODULE$.error$default$2(), x$3);
            }
            return AbstractFile$.MODULE$.getFile(path);
        }

        @Override
        public void close() {
        }

        private final void warnSpecial$1(String name$1, Contexts.Context x$2$1) {
            report$.MODULE$.warning(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"path component is special Windows device: ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)name$1)}), x$2$1), x$2$1);
        }
    }

    public static class FileConflictException
    extends IOException {
        public static Throwable $lessinit$greater$default$2() {
            return FileWriters$FileConflictException$.MODULE$.$lessinit$greater$default$2();
        }

        public FileConflictException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static interface FileWriter {
        public static FileWriter apply(AbstractFile abstractFile, Option<String> option, Contexts.Context context) {
            return FileWriters$FileWriter$.MODULE$.apply(abstractFile, option, context);
        }

        public AbstractFile writeFile(String var1, byte[] var2, Contexts.Context var3);

        public void close();
    }

    public static final class JarEntryWriter
    implements FileWriter {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JarEntryWriter.class.getDeclaredField("crc$lzy1"));
        private final boolean storeOnly;
        private final JarOutputStream jarWriter;
        private volatile Object crc$lzy1;

        public JarEntryWriter(AbstractFile file, Option<String> mainClass, int compressionLevel) {
            this.storeOnly = compressionLevel == 0;
            Manifest manifest = new Manifest();
            Attributes x$proxy3 = manifest.getMainAttributes();
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            Attributes attrs = x$proxy3;
            attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attrs.put(Properties$.MODULE$.ScalaCompilerVersion(), Properties$.MODULE$.versionNumberString());
            mainClass.foreach((Function1 & Serializable)c -> attrs.put(Attributes.Name.MAIN_CLASS, c));
            JarOutputStream jar = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file.file()), 64000), manifest);
            jar.setLevel(compressionLevel);
            if (this.storeOnly()) {
                jar.setMethod(0);
            }
            this.jarWriter = jar;
        }

        public boolean storeOnly() {
            return this.storeOnly;
        }

        public JarOutputStream jarWriter() {
            return this.jarWriter;
        }

        public CRC32 crc() {
            Object object = this.crc$lzy1;
            if (object instanceof CRC32) {
                return (CRC32)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (CRC32)this.crc$lzyINIT1();
        }

        private Object crc$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.crc$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        CRC32 cRC32 = null;
                        try {
                            cRC32 = new CRC32();
                            object2 = cRC32 == null ? LazyVals.NullValue$.MODULE$ : cRC32;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.crc$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return cRC32;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public AbstractFile writeFile(String relativePath, byte[] bytes, Contexts.Context x$3) {
            AbstractFile abstractFile;
            JarEntryWriter jarEntryWriter = this;
            synchronized (jarEntryWriter) {
                ZipEntry entry = new ZipEntry(relativePath);
                if (this.storeOnly()) {
                    entry.setSize(Int$.MODULE$.int2long(bytes.length));
                    this.crc().reset();
                    this.crc().update(bytes);
                    entry.setCrc(this.crc().getValue());
                }
                this.jarWriter().putNextEntry(entry);
                try {
                    this.jarWriter().write(bytes, 0, bytes.length);
                }
                finally {
                    this.jarWriter().flush();
                }
                abstractFile = null;
            }
            return abstractFile;
        }

        @Override
        public void close() {
            JarEntryWriter jarEntryWriter = this;
            synchronized (jarEntryWriter) {
                this.jarWriter().close();
            }
        }
    }

    public static interface TastyWriter {
        public static TastyWriter apply(AbstractFile abstractFile, Contexts.Context context) {
            return FileWriters$TastyWriter$.MODULE$.apply(abstractFile, context);
        }

        public AbstractFile writeTasty(String var1, byte[] var2, Contexts.Context var3);

        public void close();

        public static String classToRelativePath$(TastyWriter $this, String className) {
            return $this.classToRelativePath(className);
        }

        default public String classToRelativePath(String className) {
            String x$proxy1 = className.replace('.', '/');
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return new StringBuilder(6).append(x$proxy1).append(".tasty").toString();
        }
    }

    public static final class VirtualFileWriter
    implements FileWriter {
        private final AbstractFile base;

        public VirtualFileWriter(AbstractFile base) {
            this.base = base;
        }

        private AbstractFile getFile(AbstractFile base, String path) {
            Object[] components = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(path), '/');
            ObjectRef dir = ObjectRef.create((Object)base);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), components.length - 1).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> this.getFile$$anonfun$1(dir, (String[])components, base, path, arg_0)));
            Object object = Predef$.MODULE$.refArrayOps(components);
            return this.ensureDirectory$1(base, path, (AbstractFile)dir.elem).fileNamed(((String)ArrayOps$.MODULE$.last$extension(object)).toString());
        }

        private void writeBytes(AbstractFile outFile, byte[] bytes) {
            try (DataOutputStream out = new DataOutputStream(outFile.bufferedOutput());){
                out.write(bytes, 0, bytes.length);
            }
        }

        @Override
        public AbstractFile writeFile(String relativePath, byte[] bytes, Contexts.Context x$3) {
            AbstractFile outFile = this.getFile(this.base, relativePath);
            this.writeBytes(outFile, bytes);
            return outFile;
        }

        @Override
        public void close() {
        }

        private final AbstractFile ensureDirectory$1(AbstractFile base$1, String path$1, AbstractFile dir) {
            if (dir.isDirectory()) {
                return dir;
            }
            throw new FileConflictException(new StringBuilder(22).append(base$1.path()).append("/").append(path$1).append(": ").append(dir.path()).append(" is not a directory").toString(), FileWriters$FileConflictException$.MODULE$.$lessinit$greater$default$2());
        }

        private final /* synthetic */ void getFile$$anonfun$1(ObjectRef dir$1, String[] components$1, AbstractFile base$2, String path$2, int i) {
            dir$1.elem = this.ensureDirectory$1(base$2, path$2, (AbstractFile)dir$1.elem).subdirectoryNamed(components$1[i].toString());
        }
    }
}

