/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.io.Jar;
import dotty.tools.io.JarArchive;
import dotty.tools.io.JarWriter;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.jar.Attributes;
import scala.Function1;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class ClassfileWriterOps {
    private final JarArchive outputDir;
    private final JarWriter jarWriter;

    public ClassfileWriterOps(JarArchive outputDir, Contexts.Context ictx) {
        this.outputDir = outputDir;
        Contexts.Context localCtx = ictx;
        this.jarWriter = (JarWriter)outputDir.underlyingSource().map((Function1 & Serializable)source -> {
            if (outputDir.isEmpty()) {
                return new Jar(source.file()).jarWriter((Seq<Tuple2<Attributes.Name, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            report$.MODULE$.warning(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to write to non-empty JAR: ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_AbstractFile()).apply(source)}), localCtx), localCtx);
            return null;
        }).getOrElse(() -> ClassfileWriterOps.$init$$$anonfun$2(outputDir, localCtx));
    }

    public void writeTasty(String className, byte[] bytes) {
        this.writeToJar(className, bytes, ".tasty");
    }

    private void writeToJar(String className, byte[] bytes, String suffix) {
        if (this.jarWriter == null) {
            return;
        }
        String path = new StringBuilder(0).append(className).append(suffix).toString();
        DataOutputStream out = this.jarWriter.newOutputStream(path);
        try {
            out.write(bytes, 0, bytes.length);
        }
        finally {
            out.flush();
        }
    }

    public void close() {
        if (this.jarWriter != null) {
            this.jarWriter.close();
        }
        this.outputDir.close();
    }

    private static final JarWriter $init$$$anonfun$2(JarArchive outputDir$2, Contexts.Context localCtx$2) {
        report$.MODULE$.warning(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tried to create a file writer for ", ", but it had no underlying source."})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_AbstractFile()).apply((Object)outputDir$2)}), localCtx$2), localCtx$2);
        return null;
    }
}

