/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core;

import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.SymDenotations;
import dotty.tools.dotc.core.SymbolLoader;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.classfile.ClassfileTastyUUIDParser;
import dotty.tools.dotc.core.tasty.DottyUnpickler;
import dotty.tools.dotc.core.tasty.DottyUnpickler$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.io.AbstractFile;
import dotty.tools.tasty.TastyHeaderUnpickler;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TastyLoader
extends SymbolLoader {
    private final AbstractFile tastyFile;

    public TastyLoader(AbstractFile tastyFile) {
        this.tastyFile = tastyFile;
    }

    public AbstractFile tastyFile() {
        return this.tastyFile;
    }

    @Override
    public AbstractFile sourceFileOrNull() {
        return this.tastyFile();
    }

    @Override
    public String description(Contexts.Context x$1) {
        return new StringBuilder(11).append("TASTy file ").append(this.tastyFile().toString()).toString();
    }

    @Override
    public void doComplete(SymDenotations.SymDenotation root, Contexts.Context x$2) {
        Tuple2<SymDenotations.ClassDenotation, SymDenotations.ClassDenotation> tuple2 = this.rootDenots(root.asClass(), x$2);
        SymDenotations.ClassDenotation classRoot = (SymDenotations.ClassDenotation)tuple2._1();
        SymDenotations.ClassDenotation moduleRoot = (SymDenotations.ClassDenotation)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)classRoot, (Object)moduleRoot);
        SymDenotations.ClassDenotation classRoot2 = (SymDenotations.ClassDenotation)tuple22._1();
        SymDenotations.ClassDenotation moduleRoot2 = (SymDenotations.ClassDenotation)tuple22._2();
        byte[] tastyBytes = this.tastyFile().toByteArray();
        DottyUnpickler unpickler = new DottyUnpickler(tastyBytes, DottyUnpickler$.MODULE$.$lessinit$greater$default$2());
        unpickler.enter((Set<SymDenotations.SymDenotation>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SymDenotations.SymDenotation[]{classRoot2, moduleRoot2, Symbols$.MODULE$.toDenot(moduleRoot2.sourceModule(x$2), x$2)}))), x$2.withSource(NoSource$.MODULE$));
        if (this.mayLoadTreesFromTasty(x$2)) {
            classRoot2.classSymbol().rootTreeOrProvider_$eq(unpickler, x$2);
            moduleRoot2.classSymbol().rootTreeOrProvider_$eq(unpickler, x$2);
        }
        this.checkTastyUUID(this.tastyFile(), tastyBytes, x$2);
    }

    private void checkTastyUUID(AbstractFile tastyFile, byte[] tastyBytes, Contexts.Context x$3) {
        String className = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(tastyFile.name()), ".tasty");
        AbstractFile classfile = tastyFile.resolveSibling(new StringBuilder(6).append(className).append(".class").toString());
        if (classfile != null) {
            UUID tastyUUID = new TastyHeaderUnpickler(tastyBytes).readHeader();
            new ClassfileTastyUUIDParser(classfile, x$3).checkTastyUUID(tastyUUID, x$3);
            return;
        }
        report$.MODULE$.inform((Function0<String>)((Function0 & Serializable)() -> TastyLoader.checkTastyUUID$$anonfun$1(tastyFile)), report$.MODULE$.inform$default$2(), x$3);
    }

    private boolean mayLoadTreesFromTasty(Contexts.Context x$1) {
        return BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().YretainTrees(), x$1)) || BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().fromTasty(), x$1));
    }

    private static final String checkTastyUUID$$anonfun$1(AbstractFile tastyFile$1) {
        return new StringBuilder(49).append("No classfiles found for ").append(tastyFile$1).append(" when checking TASTy UUID").toString();
    }
}

