/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.SimpleIdentitySet$;
import dotty.tools.dotc.util.SimpleIdentitySet$empty$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public abstract class SimpleIdentitySet<Elem> {
    public static <Elem> SimpleIdentitySet<Elem> apply(Seq<Elem> seq) {
        return SimpleIdentitySet$.MODULE$.apply(seq);
    }

    public static <E> SimpleIdentitySet<E> intersect(SimpleIdentitySet<E> simpleIdentitySet, SimpleIdentitySet<E> simpleIdentitySet2) {
        return SimpleIdentitySet$.MODULE$.intersect(simpleIdentitySet, simpleIdentitySet2);
    }

    public abstract int size();

    public abstract <E> SimpleIdentitySet<E> $plus(E var1);

    public abstract <E> SimpleIdentitySet<Elem> $minus(E var1);

    public abstract <E> boolean contains(E var1);

    public abstract void foreach(Function1<Elem, BoxedUnit> var1);

    public abstract <E> boolean exists(Function1<E, Object> var1);

    public abstract <B> SimpleIdentitySet<B> map(Function1<Elem, B> var1);

    public abstract <A, E> A $div$colon(A var1, Function2<A, E, A> var2);

    public abstract List<Elem> toList();

    public abstract Iterator<Elem> iterator();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public <E> boolean forall(Function1<E, Object> p) {
        return !this.exists((Function1 & Serializable)_$1 -> !BoxesRunTime.unboxToBoolean((Object)p.apply(_$1)));
    }

    public SimpleIdentitySet<Elem> filter(Function1<Elem, Object> p) {
        SimpleIdentitySet$empty$ z = SimpleIdentitySet$empty$.MODULE$;
        return this.$div$colon(z, (Function2 & Serializable)(s, x) -> {
            if (BoxesRunTime.unboxToBoolean((Object)p.apply(x))) {
                return s.$plus(x);
            }
            return s;
        });
    }

    public <E> SimpleIdentitySet<E> $plus$plus(SimpleIdentitySet<E> that) {
        if (this.size() == 0) {
            return that;
        }
        if (that.size() == 0) {
            return this;
        }
        return that.$div$colon(this, (Function2 & Serializable)(_$2, _$3) -> _$2.$plus(_$3));
    }

    public <E> SimpleIdentitySet<E> $minus$minus(SimpleIdentitySet<E> that) {
        if (that.size() == 0) {
            return this;
        }
        SimpleIdentitySet$empty$ simpleIdentitySet$empty$ = SimpleIdentitySet$empty$.MODULE$;
        return this.$div$colon(simpleIdentitySet$empty$, (Function2 & Serializable)(s, x) -> {
            if (that.contains(x)) {
                return s;
            }
            return s.$plus(x);
        });
    }

    public <E> boolean $eq$eq(SimpleIdentitySet<E> that) {
        return this.size() == that.size() && this.forall((Function1 & Serializable)x -> that.contains(x));
    }

    public String toString() {
        return this.toList().mkString("{", ", ", "}");
    }

    public static class Set1<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;

        public Set1(Object x0) {
            this.x0 = x0;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            if (this.contains(x)) {
                return this;
            }
            return new Set2(this.x0, x);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            if (x == this.x0) {
                return SimpleIdentitySet$empty$.MODULE$;
            }
            return this;
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
        }

        @Override
        public <E> boolean exists(Function1<E, Object> p) {
            return BoxesRunTime.unboxToBoolean((Object)p.apply(this.x0));
        }

        @Override
        public <B> SimpleIdentitySet<B> map(Function1<Elem, B> f) {
            return new Set1<Elem>(f.apply(this.x0));
        }

        @Override
        public <A, E> A $div$colon(A z, Function2<A, E, A> f) {
            return (A)f.apply(z, this.x0);
        }

        @Override
        public List<Elem> toList() {
            Object object = this.x0;
            return package$.MODULE$.Nil().$colon$colon(object);
        }

        @Override
        public Iterator<Elem> iterator() {
            return package$.MODULE$.Iterator().single(this.x0);
        }
    }

    public static class Set2<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;
        private final Object x1;

        public Set2(Object x0, Object x1) {
            this.x0 = x0;
            this.x1 = x1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            if (this.contains(x)) {
                return this;
            }
            return new Set3(this.x0, this.x1, x);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            if (x == this.x0) {
                return new Set1(this.x1);
            }
            if (x == this.x1) {
                return new Set1(this.x0);
            }
            return this;
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0 || x == this.x1;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
            f.apply(this.x1);
        }

        @Override
        public <E> boolean exists(Function1<E, Object> p) {
            return BoxesRunTime.unboxToBoolean((Object)p.apply(this.x0)) || BoxesRunTime.unboxToBoolean((Object)p.apply(this.x1));
        }

        @Override
        public <B> SimpleIdentitySet<B> map(Function1<Elem, B> f) {
            return new Set2<Elem>(f.apply(this.x0), f.apply(this.x1));
        }

        @Override
        public <A, E> A $div$colon(A z, Function2<A, E, A> f) {
            return (A)f.apply(f.apply(z, this.x0), this.x1);
        }

        @Override
        public List<Elem> toList() {
            Object object = this.x0;
            Object object2 = this.x1;
            return package$.MODULE$.Nil().$colon$colon(object2).$colon$colon(object);
        }

        @Override
        public Iterator<Elem> iterator() {
            return package$.MODULE$.Iterator().tabulate(2, (Function1 & Serializable)x$1 -> this.iterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)x$1)));
        }

        private final /* synthetic */ Object iterator$$anonfun$1(int x$1) {
            int n = x$1;
            if (0 == n) {
                return this.x0;
            }
            if (1 == n) {
                return this.x1;
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
    }

    public static class Set3<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;
        private final Object x1;
        private final Object x2;

        public Set3(Object x0, Object x1, Object x2) {
            this.x0 = x0;
            this.x1 = x1;
            this.x2 = x2;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            if (this.contains(x)) {
                return this;
            }
            Object[] xs = new Object[]{this.x0, this.x1, this.x2, x};
            return new SetN(xs);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            if (x == this.x0) {
                return new Set2(this.x1, this.x2);
            }
            if (x == this.x1) {
                return new Set2(this.x0, this.x2);
            }
            if (x == this.x2) {
                return new Set2(this.x0, this.x1);
            }
            return this;
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0 || x == this.x1 || x == this.x2;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
            f.apply(this.x1);
            f.apply(this.x2);
        }

        @Override
        public <E> boolean exists(Function1<E, Object> p) {
            return BoxesRunTime.unboxToBoolean((Object)p.apply(this.x0)) || BoxesRunTime.unboxToBoolean((Object)p.apply(this.x1)) || BoxesRunTime.unboxToBoolean((Object)p.apply(this.x2));
        }

        @Override
        public <B> SimpleIdentitySet<B> map(Function1<Elem, B> f) {
            return new Set3<Elem>(f.apply(this.x0), f.apply(this.x1), f.apply(this.x2));
        }

        @Override
        public <A, E> A $div$colon(A z, Function2<A, E, A> f) {
            return (A)f.apply(f.apply(f.apply(z, this.x0), this.x1), this.x2);
        }

        @Override
        public List<Elem> toList() {
            Object object = this.x0;
            Object object2 = this.x1;
            Object object3 = this.x2;
            return package$.MODULE$.Nil().$colon$colon(object3).$colon$colon(object2).$colon$colon(object);
        }

        @Override
        public Iterator<Elem> iterator() {
            return package$.MODULE$.Iterator().tabulate(3, (Function1 & Serializable)x$1 -> this.iterator$$anonfun$2(BoxesRunTime.unboxToInt((Object)x$1)));
        }

        private final /* synthetic */ Object iterator$$anonfun$2(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.x0;
                }
                case 1: {
                    return this.x1;
                }
                case 2: {
                    return this.x2;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
    }

    public static class SetN<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object[] xs;

        public SetN(Object[] xs) {
            this.xs = xs;
        }

        public Object[] xs() {
            return this.xs;
        }

        @Override
        public int size() {
            return this.xs().length;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            if (this.contains(x)) {
                return this;
            }
            Object[] xs1 = new Object[this.size() + 1];
            System.arraycopy(this.xs(), 0, xs1, 0, this.size());
            xs1[this.size()] = x;
            return new SetN<Elem>(xs1);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            int i;
            for (i = 0; i < this.size() && this.xs()[i] != x; ++i) {
            }
            if (i == this.size()) {
                return this;
            }
            if (this.size() == 4) {
                if (i == 0) {
                    return new Set3(this.xs()[1], this.xs()[2], this.xs()[3]);
                }
                if (i == 1) {
                    return new Set3(this.xs()[0], this.xs()[2], this.xs()[3]);
                }
                if (i == 2) {
                    return new Set3(this.xs()[0], this.xs()[1], this.xs()[3]);
                }
                return new Set3(this.xs()[0], this.xs()[1], this.xs()[2]);
            }
            Object[] xs1 = new Object[this.size() - 1];
            System.arraycopy(this.xs(), 0, xs1, 0, i);
            System.arraycopy(this.xs(), i + 1, xs1, i, this.size() - (i + 1));
            return new SetN<Elem>(xs1);
        }

        @Override
        public <E> boolean contains(E x) {
            int i;
            for (i = 0; i < this.size() && this.xs()[i] != x; ++i) {
            }
            return i < this.size();
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            for (int i = 0; i < this.size(); ++i) {
                f.apply(this.xs()[i]);
            }
        }

        @Override
        public <E> boolean exists(Function1<E, Object> p) {
            Object object = Predef$.MODULE$.refArrayOps(this.xs());
            return ArrayOps$.MODULE$.exists$extension(object, p);
        }

        @Override
        public <B> SimpleIdentitySet<B> map(Function1<Elem, B> f) {
            Object object = Predef$.MODULE$.refArrayOps(this.xs());
            return new SetN<Elem>((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> f.apply(x), ClassTag$.MODULE$.apply(Object.class)));
        }

        @Override
        public <A, E> A $div$colon(A z, Function2<A, E, A> f) {
            Object object = Predef$.MODULE$.refArrayOps(this.xs());
            return (A)ArrayOps$.MODULE$.foldLeft$extension(object, z, f);
        }

        @Override
        public List<Elem> toList() {
            ListBuffer buf = new ListBuffer();
            this.foreach((Function1<Elem, BoxedUnit>)(JProcedure1 & Serializable)_$6 -> buf.$plus$eq(_$6));
            return buf.toList();
        }

        @Override
        public Iterator<Elem> iterator() {
            Object object = Predef$.MODULE$.refArrayOps(this.xs());
            return ArrayOps$.MODULE$.iterator$extension(object);
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus$plus(SimpleIdentitySet<E> that) {
            SimpleIdentitySet<E> simpleIdentitySet = that;
            if (simpleIdentitySet instanceof SetN) {
                SetN that2 = (SetN)simpleIdentitySet;
                ArrayBuffer toAdd = null;
                int limit = that2.xs().length;
                for (int i = 0; i < limit; ++i) {
                    Object elem = that2.xs()[i];
                    if (this.contains(elem)) continue;
                    if (toAdd == null) {
                        toAdd = new ArrayBuffer();
                    }
                    toAdd.$plus$eq(elem);
                }
                if (toAdd == null) {
                    return this;
                }
                int numAdded = toAdd.size();
                Object[] xs1 = new Object[this.size() + numAdded];
                System.arraycopy(this.xs(), 0, xs1, 0, this.size());
                for (int i = 0; i < numAdded; ++i) {
                    xs1[i + this.size()] = toAdd.apply(i);
                }
                return new SetN<Elem>(xs1);
            }
            return super.$plus$plus(that);
        }

        @Override
        public <E> SimpleIdentitySet<E> $minus$minus(SimpleIdentitySet<E> that) {
            SimpleIdentitySet<E> simpleIdentitySet = that;
            if (simpleIdentitySet instanceof SetN) {
                SetN that2 = (SetN)simpleIdentitySet;
                ArrayBuffer toAdd = null;
                int thisSize = this.size();
                int thatSize = that2.size();
                Object[] thatElems = that2.xs();
                int searchStart = 0;
                for (int i = 0; i < thisSize; ++i) {
                    Growable growable;
                    Object elem = this.xs()[i];
                    int j = searchStart;
                    boolean missing = false;
                    while (!missing && elem != thatElems[j]) {
                        if (++j == thatSize) {
                            j = 0;
                        }
                        missing = j == searchStart;
                    }
                    if (missing) {
                        if (toAdd == null) {
                            toAdd = new ArrayBuffer();
                        }
                        growable = toAdd.$plus$eq(elem);
                        continue;
                    }
                    searchStart = (j + 1) % thatSize;
                    growable = BoxedUnit.UNIT;
                }
                if (toAdd == null) {
                    return SimpleIdentitySet$empty$.MODULE$;
                }
                int n = toAdd.size();
                switch (n) {
                    case 1: {
                        return new Set1(toAdd.apply(0));
                    }
                    case 2: {
                        return new Set2(toAdd.apply(0), toAdd.apply(1));
                    }
                    case 3: {
                        return new Set3(toAdd.apply(0), toAdd.apply(1), toAdd.apply(2));
                    }
                }
                return new SetN<Elem>((Object[])toAdd.toArray(ClassTag$.MODULE$.apply(Object.class)));
            }
            return that.$div$colon(this, (Function2 & Serializable)(_$7, _$8) -> _$7.$minus(_$8));
        }
    }
}

