/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.Directory$;
import dotty.tools.io.File;
import dotty.tools.io.Path$;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class Path {
    private final java.nio.file.Path jpath;
    private final char separator;
    private final String separatorStr;

    public static Path apply(java.nio.file.Path path) {
        return Path$.MODULE$.apply(path);
    }

    public static Path apply(String string) {
        return Path$.MODULE$.apply(string);
    }

    public static Nothing$ fail(String string) {
        return Path$.MODULE$.fail(string);
    }

    public static boolean isExtensionJarOrZip(java.nio.file.Path path) {
        return Path$.MODULE$.isExtensionJarOrZip(path);
    }

    public static boolean isExtensionJarOrZip(String string) {
        return Path$.MODULE$.isExtensionJarOrZip(string);
    }

    public static Iterator<Directory> onlyDirs(Iterator<Path> iterator) {
        return Path$.MODULE$.onlyDirs(iterator);
    }

    public static List<Directory> onlyDirs(List<Path> list) {
        return Path$.MODULE$.onlyDirs(list);
    }

    public static Iterator<File> onlyFiles(Iterator<Path> iterator) {
        return Path$.MODULE$.onlyFiles(iterator);
    }

    public static String randomPrefix() {
        return Path$.MODULE$.randomPrefix();
    }

    public static List<Path> roots() {
        return Path$.MODULE$.roots();
    }

    public Path(java.nio.file.Path jpath) {
        this.jpath = jpath;
        this.separator = java.io.File.separatorChar;
        this.separatorStr = java.io.File.separator;
    }

    public java.nio.file.Path jpath() {
        return this.jpath;
    }

    public char separator() {
        return this.separator;
    }

    public String separatorStr() {
        return this.separatorStr;
    }

    public File toFile() {
        return new File(this.jpath(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public Directory toDirectory() {
        return new Directory(this.jpath());
    }

    public Path toAbsolute() {
        if (this.isAbsolute()) {
            return this;
        }
        return new Path(this.jpath().toAbsolutePath());
    }

    public Path toCanonical() {
        return this.normalize().toAbsolute();
    }

    public URI toURI() {
        return this.jpath().toUri();
    }

    public URL toURL() {
        return this.toURI().toURL();
    }

    public Path toAbsoluteWithRoot(Path root) {
        if (this.isAbsolute()) {
            return this;
        }
        return root.toAbsolute().$div(this);
    }

    public Path $div(String child) {
        return new Path(this.jpath().resolve(child));
    }

    public Path $div(Path child) {
        return this.resolve(child);
    }

    public Directory $div(Directory child) {
        return this.$div((Path)child).toDirectory();
    }

    public File $div(File child) {
        return this.$div((Path)child).toFile();
    }

    public Iterator<Path> walkFilter(Function1<Path, Object> cond) {
        if (this.isFile()) {
            return this.toFile().walkFilter(cond);
        }
        if (this.isDirectory()) {
            return this.toDirectory().walkFilter(cond);
        }
        return package$.MODULE$.Iterator().empty();
    }

    public Iterator<Path> walk() {
        return this.walkFilter((Function1<Path, Object>)(Function1 & Serializable)_$7 -> true);
    }

    public String name() {
        java.nio.file.Path path = this.jpath().getFileName();
        if (path == null) {
            return "";
        }
        java.nio.file.Path name = path;
        return name.toString();
    }

    public String path() {
        return this.jpath().toString();
    }

    public Path normalize() {
        return new Path(this.jpath().normalize());
    }

    public Path resolve(Path other) {
        return new Path(this.jpath().resolve(other.jpath()));
    }

    public Path relativize(Path other) {
        return new Path(this.jpath().relativize(other.jpath()));
    }

    public List<String> segments() {
        return Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.path()), this.separator())).toList().filterNot((Function1 & Serializable)_$8 -> _$8.length() == 0);
    }

    public Directory parent() {
        if (this.path().isEmpty()) {
            return Directory$.MODULE$.apply("..");
        }
        if (this.jpath().endsWith("..")) {
            return this.$div("..").toDirectory();
        }
        if (this.jpath().endsWith(".")) {
            java.nio.file.Path path = this.jpath().getParent();
            if (path == null) {
                return Directory$.MODULE$.apply("..");
            }
            java.nio.file.Path p = path;
            return new Path(p).parent();
        }
        java.nio.file.Path path = this.jpath().getParent();
        if (path == null) {
            if (this.isAbsolute()) {
                return this.toDirectory();
            }
            return Directory$.MODULE$.apply(".");
        }
        java.nio.file.Path x = path;
        return Directory$.MODULE$.apply(x);
    }

    public List<Directory> parents() {
        Directory p = this.parent();
        if (p.isSame(this)) {
            return package$.MODULE$.Nil();
        }
        return p.parents().$colon$colon((Object)p);
    }

    public String extension() {
        return Path$.MODULE$.extension(this.name());
    }

    public boolean hasExtension(String ext, Seq<String> exts) {
        String lower = this.extension().toLowerCase();
        String string = ext.toLowerCase();
        String string2 = lower;
        return !(string == null ? string2 != null : !string.equals(string2)) || exts.exists((Function1 & Serializable)_$9 -> {
            String string = _$9.toLowerCase();
            String string2 = lower;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public String stripExtension() {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.name()), new StringBuilder(1).append(".").append(this.extension()).toString());
    }

    public Path addExtension(String ext) {
        return new Path(this.jpath().resolveSibling(new StringBuilder(0).append(this.name()).append(ext).toString()));
    }

    public Path changeExtension(String ext) {
        String string = this.extension();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.addExtension(ext);
        }
        return new Path(this.jpath().resolveSibling(new StringBuilder(1).append(this.stripExtension()).append(".").append(ext).toString()));
    }

    public <T> Option<T> ifFile(Function1<File, T> f) {
        if (this.isFile()) {
            return Some$.MODULE$.apply(f.apply((Object)this.toFile()));
        }
        return None$.MODULE$;
    }

    public <T> Option<T> ifDirectory(Function1<Directory, T> f) {
        if (this.isDirectory()) {
            return Some$.MODULE$.apply(f.apply((Object)this.toDirectory()));
        }
        return None$.MODULE$;
    }

    public boolean canRead() {
        return Files.isReadable(this.jpath());
    }

    public boolean canWrite() {
        return Files.isWritable(this.jpath());
    }

    public boolean exists() {
        boolean bl;
        try {
            bl = Files.exists(this.jpath(), new LinkOption[0]);
        }
        catch (SecurityException ex) {
            bl = false;
        }
        return bl;
    }

    public boolean isFile() {
        boolean bl;
        try {
            bl = Files.isRegularFile(this.jpath(), new LinkOption[0]);
        }
        catch (SecurityException ex) {
            bl = false;
        }
        return bl;
    }

    public boolean isDirectory() {
        boolean bl;
        block3: {
            try {
                bl = Files.isDirectory(this.jpath(), new LinkOption[0]);
            }
            catch (SecurityException ex) {
                String string = this.jpath().toString();
                String string2 = ".";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAbsolute() {
        return this.jpath().isAbsolute();
    }

    public boolean isEmpty() {
        return this.path().length() == 0;
    }

    public FileTime lastModified() {
        return Files.getLastModifiedTime(this.jpath(), new LinkOption[0]);
    }

    public long length() {
        return Files.size(this.jpath());
    }

    public boolean endsWith(Path other) {
        return this.segments().endsWith(other.segments());
    }

    public boolean isSame(Path other) {
        Path path = this.toCanonical();
        Path path2 = other.toCanonical();
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public boolean isFresher(Path other) {
        return this.lastModified().compareTo(other.lastModified()) > 0;
    }

    public Directory createDirectory(boolean force, boolean failIfExists) {
        boolean res = this.tryCreate((Function0<java.nio.file.Path>)((Function0 & Serializable)() -> this.$anonfun$1(force)));
        if (!res && failIfExists && this.exists()) {
            throw Path$.MODULE$.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Directory '%s' already exists."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        if (this.isDirectory()) {
            return this.toDirectory();
        }
        return new Directory(this.jpath());
    }

    public boolean createDirectory$default$1() {
        return true;
    }

    public boolean createDirectory$default$2() {
        return false;
    }

    public File createFile(boolean failIfExists) {
        boolean res = this.tryCreate((Function0<java.nio.file.Path>)((Function0 & Serializable)this::$anonfun$2));
        Files.createFile(this.jpath(), new FileAttribute[0]);
        if (!res && failIfExists && this.exists()) {
            throw Path$.MODULE$.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("File '%s' already exists."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        if (this.isFile()) {
            return this.toFile();
        }
        return new File(this.jpath(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public boolean createFile$default$1() {
        return false;
    }

    private boolean tryCreate(Function0<java.nio.file.Path> create) {
        boolean bl;
        try {
            create.apply();
            bl = true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = false;
        }
        return bl;
    }

    public void delete() {
        try {
            Files.deleteIfExists(this.jpath());
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {}
    }

    public boolean deleteRecursively() {
        if (!this.exists()) {
            return false;
        }
        Files.walkFileTree(this.jpath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean truncate() {
        if (!this.isFile()) return false;
        RandomAccessFile raf = new RandomAccessFile(this.jpath().toFile(), "rw");
        raf.setLength(0L);
        raf.close();
        if (this.length() != 0L) return false;
        return true;
    }

    public String toString() {
        return this.path();
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof Path) {
            Path x = (Path)object;
            String string = this.path();
            String string2 = x.path();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    private final java.nio.file.Path $anonfun$1(boolean force$1) {
        if (force$1) {
            return Files.createDirectories(this.jpath(), new FileAttribute[0]);
        }
        return Files.createDirectory(this.jpath(), new FileAttribute[0]);
    }

    private final java.nio.file.Path $anonfun$2() {
        return Files.createFile(this.jpath(), new FileAttribute[0]);
    }
}

