/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.plugins;

import dotty.tools.dotc.plugins.MissingPluginException;
import dotty.tools.dotc.plugins.Plugin;
import dotty.tools.dotc.plugins.PluginLoadException;
import dotty.tools.dotc.util.HashSet;
import dotty.tools.dotc.util.HashSet$;
import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.Jar;
import dotty.tools.io.Jar$;
import dotty.tools.io.Path;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.jar.JarEntry;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class Plugin$
implements Serializable {
    private static final String PluginFile;
    public static final Plugin$ MODULE$;

    private Plugin$() {
    }

    static {
        MODULE$ = new Plugin$();
        PluginFile = "plugin.properties";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Plugin$.class);
    }

    public ClassLoader dotty$tools$dotc$plugins$Plugin$$$loaderFor(Seq<Path> locations) {
        ClassLoader compilerLoader = Plugin.class.getClassLoader();
        Seq urls = (Seq)locations.map((Function1 & Serializable)_$1 -> _$1.toURL());
        return new URLClassLoader((URL[])urls.toArray(ClassTag$.MODULE$.apply(URL.class)), compilerLoader);
    }

    public Try<Class<?>> load(String classname, ClassLoader loader) {
        Success success;
        try {
            success = Success$.MODULE$.apply(loader.loadClass(classname));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                success = Failure$.MODULE$.apply((Throwable)new PluginLoadException(classname, new StringBuilder(30).append("Error: unable to load class ").append(classname).append(": ").append(e.getMessage()).toString()));
            }
            if (throwable2 instanceof NoClassDefFoundError) {
                NoClassDefFoundError e = (NoClassDefFoundError)throwable2;
                success = Failure$.MODULE$.apply((Throwable)new PluginLoadException(classname, new StringBuilder(37).append("Error: class not found: ").append(e.getMessage()).append(" required by ").append(classname).toString()));
            }
            throw throwable;
        }
        return success;
    }

    public List<Try<Plugin>> loadAllFrom(List<List<Path>> paths, List<Path> dirs, List<String> ignoring) {
        List fromDirs = dirs.filter((Function1 & Serializable)_$4 -> _$4.isDirectory()).flatMap((Function1 & Serializable)d -> this.scan$1(d.toDirectory()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Try try_ = (Try)tuple2._2();
                    File j = (File)tuple2._1();
                    if (try_ instanceof Success) {
                        String pd = (String)((Success)try_).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Try try_ = (Try)tuple2._2();
                    File j = (File)tuple2._1();
                    if (try_ instanceof Success) {
                        String pd = (String)((Success)try_).value();
                        return Success$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)pd, (Object)Plugin$.MODULE$.dotty$tools$dotc$plugins$Plugin$$$loaderFor((Seq<Path>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{j}))))));
                    }
                }
                return function1.apply((Object)x);
            }
        }));
        List fromPaths = paths.map((Function1 & Serializable)p -> {
            Try try_ = this.findDescriptor$1((List)p);
            if (try_ instanceof Success) {
                String classname = (String)((Success)try_).value();
                return Success$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)classname, (Object)this.dotty$tools$dotc$plugins$Plugin$$$loaderFor((Seq<Path>)p)));
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                return Failure$.MODULE$.apply(e);
            }
            throw new MatchError((Object)try_);
        });
        HashSet seen = new HashSet(HashSet$.MODULE$.$lessinit$greater$default$1(), HashSet$.MODULE$.$lessinit$greater$default$2());
        List enabled = fromDirs.$colon$colon$colon(fromPaths).map((Function1 & Serializable)_$5 -> _$5.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String classname = (String)tuple2._1();
                ClassLoader loader = (ClassLoader)tuple2._2();
                return this.load(classname, loader).flatMap((Function1 & Serializable)clazz -> {
                    Plugin plugin = this.instantiate((Class<?>)clazz);
                    if (seen.contains(classname)) {
                        return Failure$.MODULE$.apply((Throwable)new PluginLoadException(plugin.name(), new StringBuilder(29).append("Ignoring duplicate plugin ").append(plugin.name()).append(" (").append(classname).append(")").toString()));
                    }
                    if (ignoring.contains((Object)plugin.name())) {
                        return Failure$.MODULE$.apply((Throwable)new PluginLoadException(plugin.name(), new StringBuilder(17).append("Disabling plugin ").append(plugin.name()).toString()));
                    }
                    seen.$plus$eq(classname);
                    return Success$.MODULE$.apply((Object)plugin);
                });
            }
            throw new MatchError((Object)tuple2);
        }));
        return enabled;
    }

    public Plugin instantiate(Class<?> clazz) {
        return (Plugin)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private final String fromFile$1(InputStream inputStream, Path path) {
        Properties props = new Properties();
        props.load(inputStream);
        inputStream.close();
        String pluginClass = props.getProperty("pluginClass");
        if (pluginClass == null) {
            throw new RuntimeException(new StringBuilder(23).append("Bad plugin descriptor: ").append(path).toString());
        }
        return pluginClass;
    }

    private final String loadDescriptionFromDir$1$$anonfun$1(Path path$1) {
        return this.fromFile$1(new FileInputStream(path$1.jpath().toFile()), path$1);
    }

    private final Try loadDescriptionFromDir$1(Path f) {
        Path path = f.$div(PluginFile);
        return Try$.MODULE$.apply(() -> this.loadDescriptionFromDir$1$$anonfun$1(path));
    }

    private final String read$1(Path jarp$1, InputStream is) {
        if (is == null) {
            throw new PluginLoadException(jarp$1.path(), new StringBuilder(12).append("Missing ").append(PluginFile).append(" in ").append(jarp$1).toString());
        }
        return this.fromFile$1(is, jarp$1);
    }

    private final String loadDescriptionFromJar$1$$anonfun$1(Path jarp$2, JarEntry fileEntry$1) {
        return this.read$1(jarp$2, new Jar(jarp$2.jpath().toFile()).getEntryStream(fileEntry$1));
    }

    private final Try loadDescriptionFromJar$1(Path jarp) {
        JarEntry fileEntry = new JarEntry(PluginFile);
        return Try$.MODULE$.apply(() -> this.loadDescriptionFromJar$1$$anonfun$1(jarp, fileEntry));
    }

    private final List scan$1(Directory d) {
        return ((List)d.files().toList().sortBy((Function1 & Serializable)_$2 -> _$2.name(), (Ordering)Ordering.String$.MODULE$)).filter((Function1 & Serializable)_$3 -> Jar$.MODULE$.isJarOrZip((Path)_$3)).map((Function1 & Serializable)j -> Tuple2$.MODULE$.apply(j, (Object)this.loadDescriptionFromJar$1((Path)j)));
    }

    private final Try loop$1$$anonfun$1(List ps$2, List rest$1) {
        return this.loop$1(ps$2, rest$1);
    }

    private final Try loop$1$$anonfun$2(List ps$3, List rest$2) {
        return this.loop$1(ps$3, rest$2);
    }

    private final Try loop$1(List ps$1, List qs) {
        List list;
        while (true) {
            list = qs;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return Failure$.MODULE$.apply((Throwable)new MissingPluginException((List<Path>)ps$1));
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Path p = (Path)colon2.head();
            List rest = list3;
            if (p.isDirectory()) {
                return this.loadDescriptionFromDir$1(p.toDirectory()).orElse(() -> this.loop$1$$anonfun$1(ps$1, rest));
            }
            if (p.isFile()) {
                return this.loadDescriptionFromJar$1(p.toFile()).orElse(() -> this.loop$1$$anonfun$2(ps$1, rest));
            }
            qs = rest;
        }
        throw new MatchError((Object)list);
    }

    private final Try findDescriptor$1(List ps) {
        return this.loop$1(ps, ps);
    }
}

