/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.backend.jvm;

import dotty.tools.backend.jvm.GenericSignatureVisitor;
import java.io.Serializable;
import scala.Char$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.function.JProcedure1;
import scala.tools.asm.Handle;
import scala.tools.asm.Type;
import scala.tools.asm.tree.AbstractInsnNode;
import scala.tools.asm.tree.AnnotationNode;
import scala.tools.asm.tree.ClassNode;
import scala.tools.asm.tree.FieldInsnNode;
import scala.tools.asm.tree.InvokeDynamicInsnNode;
import scala.tools.asm.tree.LdcInsnNode;
import scala.tools.asm.tree.MethodInsnNode;
import scala.tools.asm.tree.MultiANewArrayInsnNode;
import scala.tools.asm.tree.TypeInsnNode;

public abstract class NestedClassesCollector<T>
extends GenericSignatureVisitor {
    private final scala.collection.mutable.Set declaredInnerClasses = (scala.collection.mutable.Set)Set$.MODULE$.empty();
    private final scala.collection.mutable.Set referredInnerClasses = (scala.collection.mutable.Set)Set$.MODULE$.empty();

    public NestedClassesCollector(boolean nestedOnly) {
        super(nestedOnly);
    }

    public abstract List<T> declaredNestedClasses(String var1);

    public abstract Option<T> getClassIfNested(String var1);

    public scala.collection.mutable.Set<T> declaredInnerClasses() {
        return this.declaredInnerClasses;
    }

    public scala.collection.mutable.Set<T> referredInnerClasses() {
        return this.referredInnerClasses;
    }

    public Set<T> innerClasses() {
        return (Set)this.declaredInnerClasses().$plus$plus(this.referredInnerClasses());
    }

    public void clear() {
        this.declaredInnerClasses().clear();
        this.referredInnerClasses().clear();
    }

    public void visit(ClassNode classNode) {
        this.visitInternalName(classNode.name);
        this.declaredInnerClasses().$plus$plus$eq(this.declaredNestedClasses(classNode.name));
        this.visitInternalName(classNode.superName);
        CollectionConverters$.MODULE$.ListHasAsScala(classNode.interfaces).asScala().foreach((Function1)(JProcedure1 & Serializable)internalName -> this.visitInternalName((String)internalName));
        this.visitInternalName(classNode.outerClass);
        this.visitAnnotations(classNode.visibleAnnotations);
        this.visitAnnotations(classNode.visibleTypeAnnotations);
        this.visitAnnotations(classNode.invisibleAnnotations);
        this.visitAnnotations(classNode.invisibleTypeAnnotations);
        this.visitClassSignature(classNode.signature);
        CollectionConverters$.MODULE$.ListHasAsScala(classNode.fields).asScala().foreach((Function1)(JProcedure1 & Serializable)f -> {
            this.visitDescriptor(f.desc);
            this.visitAnnotations(f.visibleAnnotations);
            this.visitAnnotations(f.visibleTypeAnnotations);
            this.visitAnnotations(f.invisibleAnnotations);
            this.visitAnnotations(f.invisibleTypeAnnotations);
            this.visitFieldSignature(f.signature);
        });
        CollectionConverters$.MODULE$.ListHasAsScala(classNode.methods).asScala().foreach((Function1)(JProcedure1 & Serializable)m -> {
            this.visitDescriptor(m.desc);
            this.visitAnnotations(m.visibleAnnotations);
            this.visitAnnotations(m.visibleTypeAnnotations);
            this.visitAnnotations(m.invisibleAnnotations);
            this.visitAnnotations(m.invisibleTypeAnnotations);
            this.visitAnnotationss(m.visibleParameterAnnotations);
            this.visitAnnotationss(m.invisibleParameterAnnotations);
            this.visitAnnotations(m.visibleLocalVariableAnnotations);
            this.visitAnnotations(m.invisibleLocalVariableAnnotations);
            CollectionConverters$.MODULE$.ListHasAsScala(m.exceptions).asScala().foreach((Function1)(JProcedure1 & Serializable)internalName -> this.visitInternalName((String)internalName));
            CollectionConverters$.MODULE$.ListHasAsScala(m.tryCatchBlocks).asScala().foreach((Function1)(JProcedure1 & Serializable)tcb -> this.visitInternalName(tcb.type));
            for (AbstractInsnNode abstractInsnNode : m.instructions) {
                if (abstractInsnNode instanceof TypeInsnNode) {
                    TypeInsnNode ti = (TypeInsnNode)abstractInsnNode;
                    this.visitInternalNameOrArrayReference(ti.desc);
                    continue;
                }
                if (abstractInsnNode instanceof FieldInsnNode) {
                    FieldInsnNode fi = (FieldInsnNode)abstractInsnNode;
                    this.visitInternalNameOrArrayReference(fi.owner);
                    this.visitDescriptor(fi.desc);
                    continue;
                }
                if (abstractInsnNode instanceof MethodInsnNode) {
                    MethodInsnNode mi = (MethodInsnNode)abstractInsnNode;
                    this.visitInternalNameOrArrayReference(mi.owner);
                    this.visitDescriptor(mi.desc);
                    continue;
                }
                if (abstractInsnNode instanceof InvokeDynamicInsnNode) {
                    InvokeDynamicInsnNode id = (InvokeDynamicInsnNode)abstractInsnNode;
                    this.visitDescriptor(id.desc);
                    this.visitHandle(id.bsm);
                    Object object2 = Predef$.MODULE$.refArrayOps(id.bsmArgs);
                    ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)object -> this.visitConstant(object));
                    continue;
                }
                if (abstractInsnNode instanceof LdcInsnNode) {
                    LdcInsnNode ci = (LdcInsnNode)abstractInsnNode;
                    this.visitConstant(ci.cst);
                    continue;
                }
                if (!(abstractInsnNode instanceof MultiANewArrayInsnNode)) continue;
                MultiANewArrayInsnNode ma = (MultiANewArrayInsnNode)abstractInsnNode;
                this.visitDescriptor(ma.desc);
            }
            this.visitMethodSignature(m.signature);
        });
    }

    private boolean containsChar(String s, int offset, int length, char c) {
        int ix = s.indexOf(Char$.MODULE$.char2int(c), offset);
        return ix != -1 && ix < offset + length;
    }

    @Override
    public void visitInternalName(String internalName, int offset, int length) {
        if (internalName != null && this.containsChar(internalName, offset, length, '$')) {
            this.getClassIfNested(internalName.substring(offset, length)).foreach((Function1)(JProcedure1 & Serializable)c -> {
                if (!this.declaredInnerClasses().contains(c)) {
                    this.referredInnerClasses().$plus$eq(c);
                    return;
                }
            });
            return;
        }
    }

    public void visitInternalNameOrArrayReference(String ref) {
        if (ref != null) {
            int bracket = ref.lastIndexOf(91);
            if (bracket == -1) {
                this.visitInternalName(ref);
                return;
            }
            if (ref.charAt(bracket + 1) == 'L') {
                this.visitInternalName(ref, bracket + 2, ref.length() - 1);
                return;
            }
            return;
        }
    }

    public void visitDescriptor(String desc) {
        char c = desc.charAt(0);
        switch (c) {
            case '(': {
                for (int i = 1; i < desc.length(); ++i) {
                    if (desc.charAt(i) != 'L') continue;
                    int start = i + 1;
                    boolean seenDollar = false;
                    while (true) {
                        char ch = desc.charAt(i);
                        boolean bl = seenDollar = seenDollar || ch == '$';
                        if (ch == ';') break;
                        ++i;
                    }
                    if (!seenDollar) continue;
                    this.visitInternalName(desc, start, i);
                }
                return;
            }
            case 'L': {
                this.visitInternalName(desc, 1, desc.length() - 1);
                return;
            }
            case '[': {
                this.visitInternalNameOrArrayReference(desc);
                return;
            }
        }
    }

    public void visitConstant(Object object) {
        Object object2 = object;
        if (object2 instanceof Type) {
            Type t = (Type)object2;
            this.visitDescriptor(t.getDescriptor());
            return;
        }
    }

    public void visitAnnotation(AnnotationNode annot) {
        this.visitDescriptor(annot.desc);
        if (annot.values != null) {
            CollectionConverters$.MODULE$.ListHasAsScala(annot.values).asScala().foreach((Function1)(JProcedure1 & Serializable)object -> this.visitConstant(object));
            return;
        }
    }

    public void visitAnnotations(java.util.List<? extends AnnotationNode> annots) {
        if (annots != null) {
            CollectionConverters$.MODULE$.ListHasAsScala(annots).asScala().foreach((Function1)(JProcedure1 & Serializable)annot -> this.visitAnnotation((AnnotationNode)annot));
            return;
        }
    }

    public void visitAnnotationss(java.util.List<AnnotationNode>[] annotss) {
        if (annotss != null) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])annotss);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)annots -> this.visitAnnotations((java.util.List<? extends AnnotationNode>)annots));
            return;
        }
    }

    public void visitHandle(Handle handle) {
        this.visitInternalNameOrArrayReference(handle.getOwner());
        this.visitDescriptor(handle.getDesc());
    }
}

