/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.MutableSet;
import dotty.tools.dotc.util.WeakHashSet$;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import scala.Predef$;
import scala.collection.AbstractIterator;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.runtime.RichDouble$;
import scala.runtime.Scala3RunTime$;

public abstract class WeakHashSet<A>
extends MutableSet<A> {
    private final int initialCapacity;
    private final double loadFactor;
    private final ReferenceQueue queue;
    private int count;
    private Entry[] table;
    private int threshold;

    public static <A> int $lessinit$greater$default$1() {
        return WeakHashSet$.MODULE$.$lessinit$greater$default$1();
    }

    public static <A> double $lessinit$greater$default$2() {
        return WeakHashSet$.MODULE$.$lessinit$greater$default$2();
    }

    public WeakHashSet(int initialCapacity, double loadFactor) {
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.queue = new ReferenceQueue();
        this.count = 0;
        this.table = new Entry[this.computeCapacity()];
        this.threshold = this.computeThreshold();
    }

    public ReferenceQueue<A> queue() {
        return this.queue;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    private int computeCapacity() {
        int candidate;
        if (this.initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        for (candidate = 1; candidate < this.initialCapacity; candidate *= 2) {
        }
        return candidate;
    }

    public Entry[] table() {
        return this.table;
    }

    public void table_$eq(Entry[] x$1) {
        this.table = x$1;
    }

    public int threshold() {
        return this.threshold;
    }

    public void threshold_$eq(int x$1) {
        this.threshold = x$1;
    }

    private int computeThreshold() {
        Object object = Predef$.MODULE$.genericArrayOps((Object)this.table());
        return (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)ArrayOps$.MODULE$.size$extension(object) * this.loadFactor));
    }

    public abstract int hash(A var1);

    public boolean isEqual(A x, A y) {
        return x.equals(y);
    }

    public int index(int x) {
        return x & this.table().length - 1;
    }

    private void remove(int bucket, Entry prevEntry, Entry<A> entry) {
        Entry entry2 = prevEntry;
        if (entry2 == null) {
            this.table()[bucket] = entry.tail();
        } else {
            prevEntry.tail_$eq(entry.tail());
        }
        this.count_$eq(this.count() - 1);
    }

    public void removeStaleEntries() {
        this.queueLoop$1();
    }

    public void resize() {
        Entry[] oldTable = this.table();
        Object object = Predef$.MODULE$.genericArrayOps((Object)oldTable);
        this.table_$eq(new Entry[ArrayOps$.MODULE$.size$extension(object) * 2]);
        this.threshold_$eq(this.computeThreshold());
        this.tableLoop$1(oldTable, 0);
    }

    @Override
    public Object lookup(A elem) {
        A a = elem;
        if (a == null) {
            throw new NullPointerException("WeakHashSet cannot hold nulls");
        }
        this.removeStaleEntries();
        int bucket = this.index(this.hash(elem));
        return this.linkedListLoop$3(elem, this.table()[bucket]);
    }

    public A addEntryAt(int bucket, A elem, int elemHash, Entry oldHead) {
        this.table()[bucket] = new Entry<A>(elem, elemHash, oldHead, this.queue());
        this.count_$eq(this.count() + 1);
        if (this.count() > this.threshold()) {
            this.resize();
        }
        return elem;
    }

    @Override
    public A put(A elem) {
        A a = elem;
        if (a == null) {
            throw new NullPointerException("WeakHashSet cannot hold nulls");
        }
        this.removeStaleEntries();
        int h = this.hash(elem);
        int bucket = this.index(h);
        Entry oldHead = this.table()[bucket];
        return (A)this.linkedListLoop$4(elem, h, bucket, oldHead, oldHead);
    }

    @Override
    public void $plus$eq(A elem) {
        this.put(elem);
    }

    @Override
    public void $minus$eq(A elem) {
        A a = elem;
        if (a == null) {
            return;
        }
        this.removeStaleEntries();
        int bucket = this.index(this.hash(elem));
        this.linkedListLoop$5(elem, bucket, null, this.table()[bucket]);
    }

    @Override
    public void clear() {
        Object object = Predef$.MODULE$.genericArrayOps((Object)this.table());
        this.table_$eq(new Entry[ArrayOps$.MODULE$.size$extension(object)]);
        this.threshold_$eq(this.computeThreshold());
        this.count_$eq(0);
        this.queueLoop$2();
    }

    @Override
    public int size() {
        this.removeStaleEntries();
        return this.count();
    }

    @Override
    public Iterator<A> iterator() {
        this.removeStaleEntries();
        return new AbstractIterator<A>(this){
            private int currentBucket;
            private Entry entry;
            private Object lookaheadelement;
            private final /* synthetic */ WeakHashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Object object = Predef$.MODULE$.genericArrayOps((Object)$outer.table());
                this.currentBucket = ArrayOps$.MODULE$.size$extension(object);
                this.entry = null;
                this.lookaheadelement = null;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.entry == null && this.currentBucket > 0) {
                        --this.currentBucket;
                        this.entry = this.$outer.table()[this.currentBucket];
                        continue;
                    }
                    Entry e = this.entry;
                    if (e == null) {
                        return false;
                    }
                    this.lookaheadelement = e.get();
                    if (this.lookaheadelement != null) break;
                    this.entry = e.tail();
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var2_1;
                if (this.lookaheadelement == null) {
                    throw new IndexOutOfBoundsException("next on an empty iterator");
                }
                Object x$proxy2 = this.lookaheadelement;
                if (x$proxy2 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void result = var2_1;
                this.lookaheadelement = null;
                Entry x$proxy3 = this.entry;
                if (x$proxy3 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this.entry = x$proxy3.tail();
                return result;
            }
        };
    }

    public String statsItem(String op) {
        String prefix = "WeakHashSet.";
        String suffix = this.getClass().getSimpleName();
        return new StringBuilder(1).append(prefix).append(op).append(" ").append(suffix).toString();
    }

    public Diagnostics diagnostics() {
        return new Diagnostics();
    }

    private final Entry poll$1() {
        return (Entry)this.queue().poll();
    }

    private final void linkedListLoop$1(Entry stale$1, int bucket$1, Entry prevEntry, Entry entry) {
        while (entry != null) {
            if (stale$1 == entry) {
                this.remove(bucket$1, prevEntry, entry);
                return;
            }
            Entry entry2 = entry;
            Entry entry3 = entry.tail();
            prevEntry = entry2;
            entry = entry3;
        }
    }

    private final void queueLoop$1() {
        Entry stale;
        while ((stale = this.poll$1()) != null) {
            int bucket = this.index(stale.hash());
            this.linkedListLoop$1(stale, bucket, null, this.table()[bucket]);
        }
    }

    private final void linkedListLoop$2(Entry entry) {
        Entry entry2;
        while ((entry2 = entry) != null) {
            int bucket = this.index(entry.hash());
            Entry oldNext = entry.tail();
            entry.tail_$eq(this.table()[bucket]);
            this.table()[bucket] = entry;
            entry = oldNext;
        }
        return;
    }

    private final void tableLoop$1(Entry[] oldTable$1, int oldBucket) {
        Object object;
        while (oldBucket < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.genericArrayOps((Object)oldTable$1))) {
            this.linkedListLoop$2(oldTable$1[oldBucket]);
            ++oldBucket;
        }
    }

    private final Object linkedListLoop$3(Object elem$1, Entry entry) {
        Entry entry2;
        while ((entry2 = entry) != null) {
            Object entryElem = entry.get();
            if (entryElem != null && this.isEqual(elem$1, entryElem)) {
                return entryElem;
            }
            entry = entry.tail();
        }
        return null;
    }

    private final Object linkedListLoop$4(Object elem$2, int h$1, int bucket$2, Entry oldHead$1, Entry entry) {
        Entry entry2;
        while ((entry2 = entry) != null) {
            Object entryElem = entry.get();
            if (entryElem != null && this.isEqual(elem$2, entryElem)) {
                Object x$proxy1 = entryElem;
                return x$proxy1;
            }
            entry = entry.tail();
        }
        return this.addEntryAt(bucket$2, elem$2, h$1, oldHead$1);
    }

    private final void linkedListLoop$5(Object elem$3, int bucket$3, Entry prevEntry, Entry entry) {
        while (entry != null) {
            Object entryElem = entry.get();
            if (entryElem != null && this.isEqual(elem$3, entryElem)) {
                this.remove(bucket$3, prevEntry, entry);
                return;
            }
            Entry entry2 = entry;
            Entry entry3 = entry.tail();
            prevEntry = entry2;
            entry = entry3;
        }
    }

    private final void queueLoop$2() {
        while (this.queue().poll() != null) {
        }
    }

    public static final /* synthetic */ boolean dotty$tools$dotc$util$WeakHashSet$Diagnostics$$_$collisionBucketsCount$$anonfun$1(Entry entry) {
        return entry != null && entry.tail() != null;
    }

    public static final /* synthetic */ boolean dotty$tools$dotc$util$WeakHashSet$Diagnostics$$_$fullBucketsCount$$anonfun$1(Entry entry) {
        return entry != null;
    }

    public class Diagnostics {
        public Diagnostics() {
            if (WeakHashSet.this == null) {
                throw new NullPointerException();
            }
        }

        public void fullyValidate() {
            Object object;
            int computedCount = 0;
            for (int bucket = 0; bucket < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.genericArrayOps((Object)WeakHashSet.this.table())); ++bucket) {
                for (Entry entry = WeakHashSet.this.table()[bucket]; entry != null; entry = entry.tail()) {
                    Object x$proxy4;
                    int realHash;
                    if (entry.get() == null) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(121).append(entry).append(" had a null value indicated that gc activity was happening during diagnostic validation or that a null value was inserted").toString());
                    }
                    ++computedCount;
                    int cachedHash = entry.hash();
                    if (cachedHash != (realHash = WeakHashSet.this.hash(x$proxy4 = entry.get()))) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(43).append("for ").append(entry).append(" cached hash was ").append(cachedHash).append(" but should have been ").append(realHash).toString());
                    }
                    int computedBucket = WeakHashSet.this.index(realHash);
                    if (computedBucket == bucket) continue;
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(51).append("for ").append(entry).append(" the computed bucket was ").append(computedBucket).append(" but should have been ").append(bucket).toString());
                }
            }
            if (computedCount != WeakHashSet.this.count()) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(45).append("The computed count was ").append(computedCount).append(" but should have been ").append(WeakHashSet.this.count()).toString());
            }
        }

        public String dump() {
            return Arrays.toString(WeakHashSet.this.table());
        }

        public int collisionBucketsCount() {
            Object object = Predef$.MODULE$.genericArrayOps((Object)WeakHashSet.this.table());
            return ArrayOps$.MODULE$.count$extension(object, WeakHashSet::dotty$tools$dotc$util$WeakHashSet$Diagnostics$$_$collisionBucketsCount$$anonfun$1);
        }

        public int fullBucketsCount() {
            Object object = Predef$.MODULE$.genericArrayOps((Object)WeakHashSet.this.table());
            return ArrayOps$.MODULE$.count$extension(object, WeakHashSet::dotty$tools$dotc$util$WeakHashSet$Diagnostics$$_$fullBucketsCount$$anonfun$1);
        }

        public int bucketsCount() {
            Object object = Predef$.MODULE$.genericArrayOps((Object)WeakHashSet.this.table());
            return ArrayOps$.MODULE$.size$extension(object);
        }

        public final /* synthetic */ WeakHashSet dotty$tools$dotc$util$WeakHashSet$Diagnostics$$$outer() {
            return WeakHashSet.this;
        }
    }

    public static class Entry<A>
    extends WeakReference<A> {
        private final int hash;
        private Entry tail;

        public Entry(A element, int hash, Entry tail, ReferenceQueue<A> queue) {
            this.hash = hash;
            this.tail = tail;
            super(element, queue);
        }

        public int hash() {
            return this.hash;
        }

        public Entry tail() {
            return this.tail;
        }

        public void tail_$eq(Entry x$1) {
            this.tail = x$1;
        }
    }
}

