/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.dotc.config.Properties$;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.SourceVersion;
import dotty.tools.dotc.config.SourceVersion$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.NameKinds$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.typer.ImportInfo;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.StringContext$;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Feature$
implements Serializable {
    private static final Names.TermName namedTypeArguments;
    private static final Names.TermName genericNumberLiterals;
    private static final Names.TermName scala2macros;
    private static final Names.TermName dependent;
    private static final Names.TermName erasedDefinitions;
    private static final Names.TermName symbolLiterals;
    private static final Names.TermName fewerBraces;
    private static final Names.TermName saferExceptions;
    public static final Feature$ MODULE$;

    private Feature$() {
    }

    static {
        MODULE$ = new Feature$();
        namedTypeArguments = MODULE$.experimental("namedTypeArguments");
        genericNumberLiterals = MODULE$.experimental("genericNumberLiterals");
        scala2macros = MODULE$.experimental("macros");
        dependent = MODULE$.experimental("dependent");
        erasedDefinitions = MODULE$.experimental("erasedDefinitions");
        symbolLiterals = MODULE$.deprecated("symbolLiterals");
        fewerBraces = MODULE$.experimental("fewerBraces");
        saferExceptions = MODULE$.experimental("saferExceptions");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Feature$.class);
    }

    public Names.TermName experimental(Object str) {
        return NameKinds$.MODULE$.QualifiedName().apply((Names.TermName)StdNames$.MODULE$.nme().experimental(), Decorators$.MODULE$.toTermName(str));
    }

    private Names.TermName deprecated(Object str) {
        return NameKinds$.MODULE$.QualifiedName().apply((Names.TermName)StdNames$.MODULE$.nme().deprecated(), Decorators$.MODULE$.toTermName(str));
    }

    public Names.TermName scala2macros() {
        return scala2macros;
    }

    public Names.TermName dependent() {
        return dependent;
    }

    public Names.TermName erasedDefinitions() {
        return erasedDefinitions;
    }

    public Names.TermName symbolLiterals() {
        return symbolLiterals;
    }

    public Names.TermName fewerBraces() {
        return fewerBraces;
    }

    public Names.TermName saferExceptions() {
        return saferExceptions;
    }

    public boolean enabledBySetting(Names.TermName feature, Contexts.Context x$2) {
        return ((List)Settings$Setting$.MODULE$.value(x$2.base().settings().language(), x$2)).contains((Object)feature.toString());
    }

    public boolean enabledByImport(Names.TermName feature, Contexts.Context x$2) {
        ImportInfo info = x$2.importInfo();
        return info != null && info.featureImported(feature, x$2);
    }

    public boolean enabled(Names.TermName feature, Contexts.Context x$2) {
        return this.enabledBySetting(feature, x$2) || this.enabledByImport(feature, x$2);
    }

    public boolean autoTuplingEnabled(Contexts.Context x$1) {
        return !this.enabled((Names.TermName)StdNames$.MODULE$.nme().noAutoTupling(), x$1);
    }

    public boolean dynamicsEnabled(Contexts.Context x$1) {
        return this.enabled((Names.TermName)StdNames$.MODULE$.nme().dynamics(), x$1);
    }

    public boolean dependentEnabled(Contexts.Context x$1) {
        return this.enabled(this.dependent(), x$1);
    }

    public boolean namedTypeArgsEnabled(Contexts.Context x$1) {
        return this.enabled(namedTypeArguments, x$1);
    }

    public boolean genericNumberLiteralsEnabled(Contexts.Context x$1) {
        return this.enabled(genericNumberLiterals, x$1);
    }

    public boolean scala2ExperimentalMacroEnabled(Contexts.Context x$1) {
        return this.enabled(this.scala2macros(), x$1);
    }

    public SourceVersion sourceVersionSetting(Contexts.Context x$1) {
        return SourceVersion$.MODULE$.valueOf((String)Settings$Setting$.MODULE$.value(x$1.settings().source(), x$1));
    }

    public SourceVersion sourceVersion(Contexts.Context x$1) {
        SourceVersion sourceVersion;
        Option<SourceVersion> option = x$1.compilationUnit().sourceVersion();
        if (option instanceof Some) {
            SourceVersion v;
            sourceVersion = v = (SourceVersion)((Some)option).value();
        } else {
            Option<SourceVersion> none = option;
            sourceVersion = this.sourceVersionSetting(x$1);
        }
        return sourceVersion;
    }

    public boolean migrateTo3(Contexts.Context x$1) {
        SourceVersion sourceVersion = this.sourceVersion(x$1);
        SourceVersion sourceVersion2 = SourceVersion$.3$u002E0$minusmigration;
        return !(sourceVersion != null ? !sourceVersion.equals(sourceVersion2) : sourceVersion2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean warnOnMigration(Message msg, SrcPos pos, SourceVersion version, Contexts.Context x$4) {
        block8: {
            block7: {
                if (!this.sourceVersion(x$4).isMigrating()) break block7;
                SourceVersion sourceVersion = this.sourceVersion(x$4).stable();
                SourceVersion sourceVersion2 = version;
                if (!(sourceVersion == null ? sourceVersion2 != null : !sourceVersion.equals(sourceVersion2))) break block8;
            }
            SourceVersion sourceVersion = version;
            SourceVersion sourceVersion3 = SourceVersion$.3$u002E0;
            if (sourceVersion == null ? sourceVersion3 != null : !sourceVersion.equals(sourceVersion3)) {
                SourceVersion sourceVersion4 = version;
                SourceVersion sourceVersion5 = SourceVersion$.3$u002E1;
                if (sourceVersion4 == null ? sourceVersion5 != null : !sourceVersion4.equals(sourceVersion5)) {
                    SourceVersion sourceVersion6 = version;
                    SourceVersion sourceVersion7 = SourceVersion$.3$u002E2;
                    if (sourceVersion6 == null) {
                        if (sourceVersion7 != null) {
                            return false;
                        }
                    } else if (!sourceVersion6.equals(sourceVersion7)) return false;
                }
            }
            if (!this.migrateTo3(x$4)) return false;
        }
        report$.MODULE$.migrationWarning(msg, pos, x$4);
        return true;
    }

    public void checkExperimentalFeature(String which, SrcPos srcPos, Function0<String> note, Contexts.Context x$4) {
        if (!this.isExperimentalEnabled(x$4)) {
            report$.MODULE$.error(Message$.MODULE$.toNoExplanation((Function0<String>)((Function0 & Serializable)() -> this.checkExperimentalFeature$$anonfun$1(which, note, x$4))), srcPos, report$.MODULE$.error$default$3(), x$4);
        }
    }

    public String checkExperimentalFeature$default$3() {
        return "";
    }

    public void checkExperimentalDef(Symbols.Symbol sym, SrcPos srcPos, Contexts.Context x$3) {
        if (!this.isExperimentalEnabled(x$3)) {
            String symMsg = Symbols$.MODULE$.toDenot(sym, x$3).hasAnnotation(Symbols$.MODULE$.defn(x$3).ExperimentalAnnot(), x$3) ? Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is marked @experimental"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sym}), x$3) : (Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, x$3).owner(), x$3).hasAnnotation(Symbols$.MODULE$.defn(x$3).ExperimentalAnnot(), x$3) ? Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is marked @experimental"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Symbols$.MODULE$.toDenot(sym, x$3).owner()}), x$3) : Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " inherits @experimental"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sym}), x$3));
            report$.MODULE$.error(Message$.MODULE$.toNoExplanation((Function0<String>)((Function0 & Serializable)() -> this.checkExperimentalDef$$anonfun$1(symMsg))), srcPos, report$.MODULE$.error$default$3(), x$3);
        }
    }

    public void checkExperimentalSettings(Contexts.Context x$1) {
        ((IterableOps)Settings$Setting$.MODULE$.value(x$1.settings().language(), x$1)).withFilter((Function1 & Serializable)setting -> {
            if (!setting.startsWith("experimental.")) return false;
            String string = setting;
            String string2 = "experimental.macros";
            if (string == null) {
                if (string2 == null) return false;
                return true;
            } else if (string.equals(string2)) return false;
            return true;
        }).foreach((Function1)(JProcedure1 & Serializable)setting -> this.checkExperimentalFeature(new StringBuilder(8).append("feature ").append((String)setting).toString(), NoSourcePosition$.MODULE$, (Function0<String>)((Function0 & Serializable)this::checkExperimentalSettings$$anonfun$2$$anonfun$1), x$1));
    }

    public boolean isExperimentalEnabled(Contexts.Context x$1) {
        return Properties$.MODULE$.experimental() && !BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().YnoExperimental(), x$1));
    }

    private final String checkExperimentalFeature$$anonfun$1(String which$1, Function0 note$1, Contexts.Context x$4$1) {
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Experimental ", " may only be used with a nightly or snapshot version of the compiler", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{which$1, note$1.apply()}), x$4$1);
    }

    private final String checkExperimentalDef$$anonfun$1(String symMsg$1) {
        return new StringBuilder(57).append(symMsg$1).append(" and therefore may only be used in an experimental scope.").toString();
    }

    private final String checkExperimentalSettings$$anonfun$2$$anonfun$1() {
        return this.checkExperimentalFeature$default$3();
    }
}

