/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.sbt;

import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.sbt.ClassDependency;
import dotty.tools.dotc.sbt.ExtractDependencies$;
import dotty.tools.dotc.sbt.ExtractDependenciesCollector;
import dotty.tools.dotc.sbt.UsedNamesInClass;
import dotty.tools.dotc.util.SrcPos;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.File$;
import dotty.tools.io.PlainFile;
import dotty.tools.io.ZipArchive;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.io.Codec$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import xsbti.api.DependencyContext;

public class ExtractDependencies
extends Phases.Phase {
    public static String classNameAsString(Symbols.Symbol symbol, Contexts.Context context) {
        return ExtractDependencies$.MODULE$.classNameAsString(symbol, context);
    }

    public static void internalError(Function0<String> function0, SrcPos srcPos, Contexts.Context context) {
        ExtractDependencies$.MODULE$.internalError(function0, srcPos, context);
    }

    public static SrcPos internalError$default$2() {
        return ExtractDependencies$.MODULE$.internalError$default$2();
    }

    @Override
    public String phaseName() {
        return "sbt-deps";
    }

    @Override
    public boolean isRunnable(Contexts.Context x$1) {
        return super.isRunnable(x$1) && (x$1.sbtCallback() != null || ExtractDependencies.forceRun$1(x$1));
    }

    @Override
    public boolean isCheckable() {
        return false;
    }

    @Override
    public void run(Contexts.Context x$13) {
        CompilationUnit unit = x$13.compilationUnit();
        ExtractDependenciesCollector collector = new ExtractDependenciesCollector();
        collector.traverse(unit.tpdTree(), x$13);
        if (BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$13.settings().YdumpSbtInc(), x$13))) {
            Object[] deps = (Object[])((IterableOnceOps)collector.dependencies().map((Function1 & Serializable)_$1 -> _$1.toString())).toArray(ClassTag$.MODULE$.apply(Object.class));
            Object[] names = (Object[])((IterableOnceOps)collector.usedNames().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Symbols.Symbol clazz = (Symbols.Symbol)tuple2._1();
                UsedNamesInClass names = (UsedNamesInClass)tuple2._2();
                return new StringBuilder(2).append(clazz).append(": ").append(names).toString();
            })).toArray(ClassTag$.MODULE$.apply(Object.class));
            Arrays.sort(deps);
            Arrays.sort(names);
            try (PrintWriter pw = File$.MODULE$.apply(unit.source().file().jpath(), Codec$.MODULE$.fallbackSystemCodec()).changeExtension("inc").toFile().printWriter();){
                pw.println("Used Names:");
                pw.println("===========");
                Object object = Predef$.MODULE$.refArrayOps(names);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)x$0 -> pw.println(x$0));
                pw.println();
                pw.println("Dependencies:");
                pw.println("=============");
                Object object2 = Predef$.MODULE$.refArrayOps(deps);
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x$0 -> pw.println(x$0));
            }
        }
        if (x$13.sbtCallback() != null) {
            collector.usedNames().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Symbols.Symbol clazz = (Symbols.Symbol)tuple2._1();
                UsedNamesInClass usedNames = (UsedNamesInClass)tuple2._2();
                String className = ExtractDependencies$.MODULE$.classNameAsString(clazz, x$13);
                usedNames.names().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Names.Name usedName = (Names.Name)tuple2._1();
                    EnumSet scopes = (EnumSet)tuple2._2();
                    x$13.sbtCallback().usedName(className, usedName.toString(), scopes);
                });
            });
            collector.dependencies().foreach((Function1)(JProcedure1 & Serializable)dep -> this.recordDependency((ClassDependency)dep, x$13));
        }
    }

    public void recordDependency(ClassDependency dep, Contexts.Context x$2) {
        block4: {
            String fromClassName;
            block6: {
                AbstractFile depFile;
                File sourceFile;
                block5: {
                    fromClassName = ExtractDependencies$.MODULE$.classNameAsString(dep.from(), x$2);
                    sourceFile = x$2.compilationUnit().source().file().file();
                    depFile = dep.to().associatedFile(x$2);
                    if (depFile == null) break block4;
                    String string = depFile.extension();
                    String string2 = "class";
                    if (string != null ? !string.equals(string2) : string2 != null) break block5;
                    scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
                    Symbols.Symbol pkg = Symbols$.MODULE$.toDenot(dep.to(), x$2).enclosingPackageClass(x$2);
                    if (!Symbols$.MODULE$.toDenot(pkg, x$2).isEffectiveRoot(x$2)) {
                        builder.append(Symbols$.MODULE$.toDenot(pkg, x$2).fullName(x$2).mangledString());
                        builder.append(".");
                    }
                    Names.Name flatName = Symbols$.MODULE$.toDenot(dep.to(), x$2).flatName(x$2);
                    Names.Name clsFlatName = Symbols$.MODULE$.toDenot(dep.to(), x$2).isOneOf(Flags$.MODULE$.$bar(Flags$.MODULE$.JavaDefined(), Flags$.MODULE$.ConstructorProxy()), x$2) ? NameOps$.MODULE$.stripModuleClassSuffix(flatName) : flatName;
                    builder.append(clsFlatName.mangledString());
                    String binaryClassName = builder.toString();
                    ExtractDependencies.processExternalDependency$1(dep, x$2, fromClassName, sourceFile, depFile, binaryClassName);
                    break block4;
                }
                if (ExtractDependencies.allowLocal$1(dep)) break block6;
                File file = depFile.file();
                File file2 = sourceFile;
                if (!(file == null ? file2 != null : !((Object)file).equals(file2))) break block4;
            }
            String toClassName = ExtractDependencies$.MODULE$.classNameAsString(dep.to(), x$2);
            x$2.sbtCallback().classDependency(toClassName, fromClassName, dep.context());
        }
    }

    private static final boolean forceRun$1(Contexts.Context x$1$1) {
        return BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1$1.settings().YdumpSbtInc(), x$1$1)) || BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1$1.settings().YforceSbtPhases(), x$1$1));
    }

    private static final void binaryDependency$1(ClassDependency dep$1, Contexts.Context x$2$1, String fromClassName$1, File sourceFile$1, File file, String binaryClassName) {
        x$2$1.sbtCallback().binaryDependency(file, binaryClassName, fromClassName$1, sourceFile$1, dep$1.context());
    }

    private static final String processExternalDependency$1$$anonfun$1(AbstractFile depFile$1) {
        return new StringBuilder(39).append("Ignoring dependency ").append(depFile$1).append(" of unknown class ").append(depFile$1.getClass()).append("}").toString();
    }

    private static final void processExternalDependency$1(ClassDependency dep$2, Contexts.Context x$2$2, String fromClassName$2, File sourceFile$2, AbstractFile depFile, String binaryClassName) {
        block1: {
            block2: {
                AbstractFile abstractFile;
                block0: {
                    ZipArchive zip;
                    abstractFile = depFile;
                    if (!(abstractFile instanceof ZipArchive.Entry)) break block0;
                    ZipArchive.Entry ze = (ZipArchive.Entry)abstractFile;
                    Option<ZipArchive> option = ze.underlyingSource();
                    if (!(option instanceof Some) || (zip = (ZipArchive)((Some)option).value()).file() == null) break block1;
                    ExtractDependencies.binaryDependency$1(dep$2, x$2$2, fromClassName$2, sourceFile$2, zip.file(), binaryClassName);
                    break block1;
                }
                if (!(abstractFile instanceof PlainFile)) break block2;
                PlainFile pf = (PlainFile)abstractFile;
                if (pf.file() == null) break block1;
                ExtractDependencies.binaryDependency$1(dep$2, x$2$2, fromClassName$2, sourceFile$2, pf.file(), binaryClassName);
                break block1;
            }
            ExtractDependencies$.MODULE$.internalError((Function0<String>)((Function0 & Serializable)() -> ExtractDependencies.processExternalDependency$1$$anonfun$1(depFile)), dep$2.from().srcPos(), x$2$2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean allowLocal$1(ClassDependency dep$3) {
        DependencyContext dependencyContext = dep$3.context();
        DependencyContext dependencyContext2 = DependencyContext.DependencyByInheritance;
        if (dependencyContext == null) {
            if (dependencyContext2 == null) return true;
        } else if (dependencyContext.equals(dependencyContext2)) return true;
        DependencyContext dependencyContext3 = dep$3.context();
        DependencyContext dependencyContext4 = DependencyContext.LocalDependencyByInheritance;
        if (dependencyContext3 != null) {
            if (!dependencyContext3.equals(dependencyContext4)) return false;
            return true;
        }
        if (dependencyContext4 == null) return true;
        return false;
    }
}

