/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.dotc.classpath.ClassFileEntry;
import dotty.tools.dotc.classpath.ClassFileEntryImpl$;
import dotty.tools.dotc.classpath.ClassPathEntries;
import dotty.tools.dotc.classpath.ClassPathEntries$;
import dotty.tools.dotc.classpath.NoSourcePaths;
import dotty.tools.dotc.classpath.PackageEntry;
import dotty.tools.dotc.classpath.PackageEntryImpl$;
import dotty.tools.dotc.classpath.PackageName;
import dotty.tools.dotc.classpath.PackageNameUtils$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassPath;
import dotty.tools.io.ClassPath$;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.PlainFile;
import dotty.tools.io.PlainFile$;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Properties$;

public final class CtSymClassPath
implements ClassPath,
NoSourcePaths {
    private final String releaseCode;
    private final Map<String, Seq<Path>> packageIndex;

    public CtSymClassPath(Path ctSym, int release) {
        FileSystem fileSystem = FileSystems.newFileSystem(ctSym, null);
        Path root2 = fileSystem.getRootDirectories().iterator().next();
        List roots = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.newDirectoryStream(root2).iterator()).asScala()).toList();
        this.releaseCode = this.codeFor(release);
        List rootsForRelease = roots.filter((Function1 & Serializable)root -> this.fileNameMatchesRelease(root.getFileName().toString()));
        AnyRefMap index = AnyRefMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        boolean isJava12OrHigher = Properties$.MODULE$.isJavaAtLeast("12");
        rootsForRelease.foreach((Function1)(JProcedure1 & Serializable)root -> ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(root, new FileVisitOption[0]).iterator()).asScala()).filter((Function1 & Serializable)_$3 -> Files.isDirectory(_$3, new LinkOption[0])).foreach((Function1)(JProcedure1 & Serializable)p -> {
            int moduleNamePathElementCount;
            int n = moduleNamePathElementCount = isJava12OrHigher ? 1 : 0;
            if (p.getNameCount() > root.getNameCount() + moduleNamePathElementCount) {
                String packageDotted = p.subpath(moduleNamePathElementCount + root.getNameCount(), p.getNameCount()).toString().replace('/', '.');
                ((Growable)index.getOrElseUpdate((Object)packageDotted, CtSymClassPath::$init$$$anonfun$4$$anonfun$2$$anonfun$1)).$plus$eq(p);
            }
        }));
        this.packageIndex = index;
    }

    private String codeFor(int major) {
        return major < 10 ? BoxesRunTime.boxToInteger((int)major).toString() : BoxesRunTime.boxToCharacter((char)((char)(65 + (major - 10)))).toString();
    }

    private boolean fileNameMatchesRelease(String fileName) {
        return !fileName.contains("-") && fileName.contains(this.releaseCode);
    }

    @Override
    public boolean hasPackage(PackageName pkg) {
        return this.packageIndex.contains((Object)pkg.dottedString());
    }

    @Override
    public scala.collection.immutable.Seq<PackageEntry> packages(PackageName inPackage) {
        return this.packageIndex.keysIterator().filter((Function1 & Serializable)pack -> PackageNameUtils$.MODULE$.packageContains(inPackage.dottedString(), (String)pack)).map((Function1 & Serializable)_$4 -> PackageEntryImpl$.MODULE$.apply((String)_$4)).toVector();
    }

    @Override
    public scala.collection.immutable.Seq<ClassFileEntry> classes(PackageName inPackage) {
        Nil$ nil$;
        if (inPackage.isRoot()) {
            nil$ = package$.MODULE$.Nil();
        } else {
            Iterator sigFiles = ((IterableOnce)this.packageIndex.getOrElse((Object)inPackage.dottedString(), CtSymClassPath::$anonfun$1)).iterator().flatMap((Function1 & Serializable)p -> ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(p).iterator()).asScala()).filter((Function1 & Serializable)_$5 -> _$5.getFileName().toString().endsWith(".sig")));
            nil$ = sigFiles.map((Function1 & Serializable)f -> ClassFileEntryImpl$.MODULE$.apply(PlainFile$.MODULE$.toPlainFile((Path)f))).toVector();
        }
        return (scala.collection.immutable.Seq)nil$;
    }

    @Override
    public ClassPathEntries list(PackageName inPackage) {
        return inPackage.isRoot() ? ClassPathEntries$.MODULE$.apply((Seq<PackageEntry>)this.packages(inPackage), (Seq<ClassRepresentation>)package$.MODULE$.Nil()) : ClassPathEntries$.MODULE$.apply((Seq<PackageEntry>)this.packages(inPackage), (Seq<ClassRepresentation>)this.classes(inPackage));
    }

    @Override
    public scala.collection.immutable.Seq<URL> asURLs() {
        return package$.MODULE$.Nil();
    }

    @Override
    public scala.collection.immutable.Seq<String> asClassPathStrings() {
        return package$.MODULE$.Nil();
    }

    @Override
    public Option<AbstractFile> findClassFile(String className) {
        None$ none$;
        if (!className.contains(".")) {
            none$ = None$.MODULE$;
        } else {
            Tuple2 tuple2;
            int lastDotIndex = className.lastIndexOf(46);
            Tuple2 tuple22 = tuple2 = lastDotIndex == -1 ? Tuple2$.MODULE$.apply((Object)ClassPath$.MODULE$.RootPackage(), (Object)className) : Tuple2$.MODULE$.apply((Object)className.substring(0, lastDotIndex), (Object)className.substring(lastDotIndex + 1));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String inPackage = (String)tuple2._1();
            String classSimpleName = (String)tuple2._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)inPackage, (Object)classSimpleName);
            String inPackage2 = (String)tuple23._1();
            String classSimpleName2 = (String)tuple23._2();
            none$ = ((IterableOnce)this.packageIndex.getOrElse((Object)inPackage2, CtSymClassPath::findClassFile$$anonfun$1)).iterator().flatMap((Function1 & Serializable)p -> {
                Nil$ nil$;
                Path path = p.resolve(new StringBuilder(4).append(classSimpleName2).append(".sig").toString());
                if (Files.exists(path, new LinkOption[0])) {
                    PlainFile plainFile = PlainFile$.MODULE$.toPlainFile(path);
                    nil$ = package$.MODULE$.Nil().$colon$colon((Object)plainFile);
                } else {
                    nil$ = package$.MODULE$.Nil();
                }
                return nil$;
            }).take(1).toList().headOption();
        }
        return none$;
    }

    private static final ListBuffer $init$$$anonfun$4$$anonfun$2$$anonfun$1() {
        return new ListBuffer();
    }

    private static final Nil$ $anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final Nil$ findClassFile$$anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

