/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.tools.dotc.core.NameKinds;
import dotty.tools.dotc.core.NameKinds$;
import dotty.tools.dotc.core.NameKinds$SignedName$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Names$;
import dotty.tools.dotc.core.Signature;
import dotty.tools.dotc.core.Signature$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyFormat$;
import dotty.tools.tasty.TastyHeaderUnpickler;
import dotty.tools.tasty.TastyReader;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;

public class TastyUnpickler {
    private final TastyReader reader;
    private final HashMap<String, TastyReader> sectionReader;
    private final NameTable nameAtRef;

    public TastyUnpickler(TastyReader reader) {
        this.reader = reader;
        this.sectionReader = new HashMap();
        this.nameAtRef = new NameTable();
        new TastyHeaderUnpickler(reader).readHeader();
        reader.until(reader.readEnd(), this::$init$$$anonfun$1);
        while (!reader.isAtEnd()) {
            String secName = this.readString();
            int secEnd = reader.readEnd();
            this.sectionReader.update((Object)secName, (Object)new TastyReader(this.bytes(), reader.currentAddr(), secEnd, reader.currentAddr()));
            reader.goto(secEnd);
        }
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public TastyUnpickler(byte[] bytes) {
        this(new TastyReader(bytes));
    }

    public NameTable nameAtRef() {
        return this.nameAtRef;
    }

    private Names.TermName readName() {
        return this.nameAtRef().apply(this.reader.readNameRef());
    }

    private String readString() {
        return this.readName().toString();
    }

    private Object readParamSig() {
        int ref = this.reader.readInt();
        return ref < 0 ? BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(ref))) : this.nameAtRef().apply(TastyBuffer.NameRef$.MODULE$.apply(ref)).toTypeName();
    }

    private Names.TermName readNameContents() {
        Names.TermName termName;
        int tag = this.reader.readByte();
        int length = this.reader.readNat();
        int start = this.reader.currentAddr();
        int end = TastyBuffer.Addr$.MODULE$.$plus$extension(start, length);
        int n = tag;
        switch (n) {
            case 1: {
                this.reader.goto(end);
                termName = Names$.MODULE$.termName(this.bytes(), start, length);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                termName = NameKinds$.MODULE$.qualifiedNameKindOfTag().apply(BoxesRunTime.boxToInteger((int)tag)).apply(this.readName(), this.readName().asSimpleName());
                break;
            }
            case 10: {
                String separator = this.readName().toString();
                int num = this.reader.readNat();
                List originals = this.reader.until(end, this::$anonfun$1);
                Names.TermName original = originals.isEmpty() ? Names$.MODULE$.EmptyTermName() : (Names.TermName)originals.head();
                termName = ((NameKinds.NumberedNameKind)NameKinds$.MODULE$.uniqueNameKindOfSeparator().apply(separator)).apply(original, num);
                break;
            }
            case 11: {
                termName = NameKinds$.MODULE$.numberedNameKindOfTag().apply(BoxesRunTime.boxToInteger((int)tag)).apply(this.readName(), this.reader.readNat());
                break;
            }
            case 63: {
                Names.TermName original = this.readName();
                termName = this.readSignedRest$1(end, original, original);
                break;
            }
            case 62: {
                Names.TermName original = this.readName();
                Names.TermName target = this.readName();
                termName = this.readSignedRest$1(end, original, target);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                termName = NameKinds$.MODULE$.simpleNameKindOfTag().apply(BoxesRunTime.boxToInteger((int)tag)).apply(this.readName());
                break;
            }
            default: {
                throw new MatchError((Object)new StringBuilder(17).append("unknown name tag ").append(TastyFormat$.MODULE$.nameTagToString(tag)).toString());
            }
        }
        Names.TermName result = termName;
        if (!TastyBuffer.Addr$.MODULE$.$eq$eq$extension(this.reader.currentAddr(), end)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(12).append("bad name ").append(result).append(" ").append(new TastyBuffer.Addr(start)).append(" ").append(new TastyBuffer.Addr(this.reader.currentAddr())).append(" ").append(new TastyBuffer.Addr(end)).toString());
        }
        return result;
    }

    public <R> Option<R> unpickle(SectionUnpickler<R> sec) {
        return this.sectionReader.get((Object)sec.name()).map((Function1 & Serializable)reader -> sec.unpickle((TastyReader)reader, this.nameAtRef()));
    }

    public byte[] bytes() {
        return this.reader.bytes();
    }

    private final ArrayBuffer $init$$$anonfun$1() {
        return this.nameAtRef().add(this.readNameContents());
    }

    private final Object $anonfun$2() {
        return this.readParamSig();
    }

    private final Names.TermName readSignedRest$1(int end$1, Names.TermName original, Names.TermName target) {
        Names.TypeName result = this.readName().toTypeName();
        List paramsSig = this.reader.until(end$1, this::$anonfun$2);
        Signature sig = Signature$.MODULE$.apply((List<Object>)paramsSig, result);
        return NameKinds$SignedName$.MODULE$.apply(original, sig, target);
    }

    private final Names.TermName $anonfun$1() {
        return this.readName();
    }

    public static class NameTable
    implements Function1<TastyBuffer.NameRef, Names.TermName> {
        private final ArrayBuffer<Names.TermName> names = new ArrayBuffer();

        public ArrayBuffer<Names.TermName> add(Names.TermName name) {
            return (ArrayBuffer)this.names.$plus$eq((Object)name);
        }

        public Names.TermName apply(int ref) {
            return (Names.TermName)this.names.apply(ref);
        }

        public Iterable<Names.TermName> contents() {
            return this.names;
        }
    }

    public static abstract class SectionUnpickler<R> {
        private final String name;

        public SectionUnpickler(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract R unpickle(TastyReader var1, NameTable var2);
    }
}

