/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.HashSet$;
import dotty.tools.dotc.util.MutableSet;
import scala.Array$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;

public class HashSet<T>
extends MutableSet<T> {
    private final int initialCapacity;
    private final int capacityMultiple;
    private int used;
    private int limit;
    public Object[] dotty$tools$dotc$util$HashSet$$table;

    public static <T> HashSet<T> from(IterableOnce<T> iterableOnce) {
        return HashSet$.MODULE$.from(iterableOnce);
    }

    public static <T> int $lessinit$greater$default$1() {
        return HashSet$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> int $lessinit$greater$default$2() {
        return HashSet$.MODULE$.$lessinit$greater$default$2();
    }

    public <T> HashSet(int initialCapacity, int capacityMultiple) {
        this.initialCapacity = initialCapacity;
        this.capacityMultiple = capacityMultiple;
        this.clear();
    }

    private void allocate(int capacity) {
        this.dotty$tools$dotc$util$HashSet$$table = new Object[capacity];
        this.limit = capacity <= 8 ? capacity - 1 : capacity / this.capacityMultiple;
    }

    private int roundToPower(int n) {
        return n < 4 ? 4 : (Integer.bitCount(n) == 1 ? n : 1 << 32 - Integer.numberOfLeadingZeros(n));
    }

    @Override
    public void clear() {
        this.used = 0;
        this.allocate(this.roundToPower(this.initialCapacity));
    }

    @Override
    public int size() {
        return this.used;
    }

    public boolean isDense() {
        return this.limit < 8;
    }

    public int hash(T key) {
        int h = key.hashCode();
        int i = (h ^ h >>> 16) * -2048144789;
        int j = (i ^ i >>> 13) & Integer.MAX_VALUE;
        return j == 0 ? 1091049865 : j;
    }

    public boolean isEqual(T x, T y) {
        return x.equals(y);
    }

    public int index(int x) {
        return x & this.dotty$tools$dotc$util$HashSet$$table.length - 1;
    }

    public Object[] currentTable() {
        return this.dotty$tools$dotc$util$HashSet$$table;
    }

    public int firstIndex(T x) {
        return this.isDense() ? 0 : this.index(this.hash(x));
    }

    public int nextIndex(int idx) {
        return this.index(idx + 1);
    }

    public T entryAt(int idx) {
        return (T)this.dotty$tools$dotc$util$HashSet$$table[idx];
    }

    public void setEntry(int idx, T x) {
        this.dotty$tools$dotc$util$HashSet$$table[idx] = x;
    }

    @Override
    public Object lookup(T x) {
        int idx = this.firstIndex(x);
        T e = this.entryAt(idx);
        while (e != null) {
            if (this.isEqual(e, x)) {
                return e;
            }
            idx = this.nextIndex(idx);
            e = this.entryAt(idx);
        }
        return null;
    }

    public T addEntryAt(int idx, T x) {
        this.setEntry(idx, x);
        ++this.used;
        if (this.used > this.limit) {
            this.growTable();
        }
        return x;
    }

    @Override
    public T put(T x) {
        int idx = this.firstIndex(x);
        T e = this.entryAt(idx);
        while (e != null) {
            if (this.isEqual(e, x)) {
                return e;
            }
            idx = this.nextIndex(idx);
            e = this.entryAt(idx);
        }
        return this.addEntryAt(idx, x);
    }

    @Override
    public void $plus$eq(T x) {
        this.put(x);
    }

    public boolean remove(T x) {
        int idx = this.firstIndex(x);
        T e = this.entryAt(idx);
        while (e != null) {
            if (this.isEqual(e, x)) {
                int hole = idx;
                while ((e = this.entryAt(idx = this.nextIndex(idx))) != null) {
                    int eidx = this.index(this.hash(e));
                    if (!this.isDense() && this.index(eidx - (hole + 1)) <= this.index(idx - (hole + 1))) continue;
                    this.setEntry(hole, e);
                    hole = idx;
                }
                this.dotty$tools$dotc$util$HashSet$$table[hole] = null;
                --this.used;
                return true;
            }
            idx = this.nextIndex(idx);
            e = this.entryAt(idx);
        }
        return false;
    }

    @Override
    public void $minus$eq(T x) {
        this.remove(x);
    }

    private void addOld(T x) {
        int idx = this.firstIndex(x);
        T e = this.entryAt(idx);
        while (e != null) {
            idx = this.nextIndex(idx);
            e = this.entryAt(idx);
        }
        this.setEntry(idx, x);
    }

    public void copyFrom(Object[] oldTable) {
        if (this.isDense()) {
            Array$.MODULE$.copy((Object)oldTable, 0, (Object)this.dotty$tools$dotc$util$HashSet$$table, 0, oldTable.length);
        } else {
            for (int idx = 0; idx < oldTable.length; ++idx) {
                Object e = oldTable[idx];
                if (e == null) continue;
                this.addOld(e);
            }
        }
    }

    public void growTable() {
        Object[] oldTable = this.dotty$tools$dotc$util$HashSet$$table;
        int newLength = oldTable.length == 8 ? 16 * this.roundToPower(this.capacityMultiple) : this.dotty$tools$dotc$util$HashSet$$table.length * 2;
        this.allocate(newLength);
        this.copyFrom(oldTable);
    }

    @Override
    public Iterator<T> iterator() {
        return new EntryIterator(this){
            private final HashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer);
            }

            public Object entry(int idx) {
                return this.$outer.entryAt(idx);
            }
        };
    }

    public String toString() {
        return this.iterator().mkString("HashSet(", ", ", ")");
    }

    public String statsItem(String op) {
        String prefix = this.isDense() ? "HashSet(dense)." : "HashSet.";
        String suffix = this.getClass().getSimpleName();
        return "" + prefix + op + " " + suffix;
    }

    public abstract class EntryIterator
    implements Iterator<T> {
        private int idx;
        private final HashSet<T> $outer;

        public EntryIterator(HashSet $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.idx = 0;
        }

        public abstract T entry(int var1);

        public boolean hasNext() {
            while (this.idx < this.$outer.dotty$tools$dotc$util$HashSet$$table.length && this.$outer.dotty$tools$dotc$util$HashSet$$table[this.idx] == null) {
                ++this.idx;
            }
            return this.idx < this.$outer.dotty$tools$dotc$util$HashSet$$table.length;
        }

        public T next() {
            Object t;
            Predef$.MODULE$.require(this.hasNext());
            try {
                t = this.entry(this.idx);
            }
            finally {
                ++this.idx;
            }
            return t;
        }

        public final HashSet<T> dotty$tools$dotc$util$HashSet$EntryIterator$$$outer() {
            return this.$outer;
        }
    }
}

