/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.interfaces.SourcePosition;
import dotty.tools.dotc.reporting.Diagnostic$;
import dotty.tools.dotc.reporting.Message;
import java.util.Optional;

public class Diagnostic
extends Exception
implements dotty.tools.dotc.interfaces.Diagnostic {
    private final Message msg;
    private final dotty.tools.dotc.util.SourcePosition pos;
    private final int level;

    public static boolean shouldExplain(Diagnostic diagnostic, Contexts.Context context) {
        return Diagnostic$.MODULE$.shouldExplain(diagnostic, context);
    }

    public Diagnostic(Message msg, dotty.tools.dotc.util.SourcePosition pos, int level) {
        this.msg = msg;
        this.pos = pos;
        this.level = level;
    }

    public Message msg() {
        return this.msg;
    }

    public dotty.tools.dotc.util.SourcePosition pos() {
        return this.pos;
    }

    public int level() {
        return this.level;
    }

    public Optional<SourcePosition> position() {
        return this.pos().exists() && this.pos().source().exists() ? Optional.of(this.pos()) : Optional.empty();
    }

    public String message() {
        return this.msg().message().replaceAll("\u001b\\[[;\\d]*m", "");
    }

    @Override
    public String toString() {
        return "" + this.getClass() + " at " + this.pos() + ": " + this.message();
    }

    @Override
    public String getMessage() {
        return this.message();
    }

    public static abstract class ConditionalWarning
    extends Warning {
        public ConditionalWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public abstract Settings.Setting<Object> enablingOption(Contexts.Context var1);
    }

    public static class DeprecationWarning
    extends ConditionalWarning {
        public DeprecationWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().deprecation();
        }
    }

    public static class Error
    extends Diagnostic {
        public Error(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 2);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static class FeatureWarning
    extends ConditionalWarning {
        public FeatureWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().feature();
        }
    }

    public static class Info
    extends Diagnostic {
        public Info(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 0);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static class MigrationWarning
    extends Warning {
        public MigrationWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static class StickyError
    extends Error {
        public StickyError(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static class UncheckedWarning
    extends ConditionalWarning {
        public UncheckedWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().unchecked();
        }
    }

    public static class Warning
    extends Diagnostic {
        public Warning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 1);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public Error toError() {
            return new Error(this.msg$accessor(), this.pos$accessor());
        }
    }
}

