/*
 * Decompiled with CFR 0.152.
 */
package scala.sys.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.LinkedBlockingQueue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.process.BasicIO;
import scala.sys.process.BasicIO$;
import scala.sys.process.BasicIO$LazilyListed$;
import scala.sys.process.BasicIO$Streamed$;
import scala.sys.process.BasicIO$Uncloseable$;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessIO;
import scala.sys.process.ProcessImpl;
import scala.sys.process.ProcessLogger;
import scala.util.control.NonFatal$;

public interface ProcessBuilderImpl {
    public static void $init$(ProcessBuilderImpl $this) {
    }

    public static Function0 scala$sys$process$ProcessBuilderImpl$$URLInput$superArg$1$(ProcessBuilderImpl $this, URL url) {
        return $this.scala$sys$process$ProcessBuilderImpl$$URLInput$superArg$1(url);
    }

    default public Function0<InputStream> scala$sys$process$ProcessBuilderImpl$$URLInput$superArg$1(URL url) {
        return () -> ProcessBuilderImpl.URLInput$superArg$1$$anonfun$1(url);
    }

    public static Function0 scala$sys$process$ProcessBuilderImpl$$FileInput$superArg$1$(ProcessBuilderImpl $this, File file) {
        return $this.scala$sys$process$ProcessBuilderImpl$$FileInput$superArg$1(file);
    }

    default public Function0<InputStream> scala$sys$process$ProcessBuilderImpl$$FileInput$superArg$1(File file) {
        return () -> ProcessBuilderImpl.FileInput$superArg$1$$anonfun$1(file);
    }

    public static Function0 scala$sys$process$ProcessBuilderImpl$$FileOutput$superArg$1$(ProcessBuilderImpl $this, File file, boolean append) {
        return $this.scala$sys$process$ProcessBuilderImpl$$FileOutput$superArg$1(file, append);
    }

    default public Function0<OutputStream> scala$sys$process$ProcessBuilderImpl$$FileOutput$superArg$1(File file, boolean append) {
        return () -> ProcessBuilderImpl.FileOutput$superArg$1$$anonfun$1(file, append);
    }

    public static Function1 scala$sys$process$ProcessBuilderImpl$$OStreamBuilder$superArg$1$(ProcessBuilderImpl $this, Function0 stream, String label) {
        return $this.scala$sys$process$ProcessBuilderImpl$$OStreamBuilder$superArg$1(stream, label);
    }

    default public Function1<ProcessIO, BoxedUnit> scala$sys$process$ProcessBuilderImpl$$OStreamBuilder$superArg$1(Function0<OutputStream> stream, String label) {
        return _$1 -> _$1.writeInput().apply(BasicIO$Uncloseable$.MODULE$.protect((OutputStream)stream.apply()));
    }

    public static Function1 scala$sys$process$ProcessBuilderImpl$$IStreamBuilder$superArg$1$(ProcessBuilderImpl $this, Function0 stream, String label) {
        return $this.scala$sys$process$ProcessBuilderImpl$$IStreamBuilder$superArg$1(stream, label);
    }

    default public Function1<ProcessIO, BoxedUnit> scala$sys$process$ProcessBuilderImpl$$IStreamBuilder$superArg$1(Function0<InputStream> stream, String label) {
        return _$2 -> _$2.processOutput().apply(BasicIO$Uncloseable$.MODULE$.protect((InputStream)stream.apply()));
    }

    private static InputStream URLInput$superArg$1$$anonfun$1(URL url$1) {
        return url$1.openStream();
    }

    private static InputStream FileInput$superArg$1$$anonfun$1(File file$1) {
        return new FileInputStream(file$1);
    }

    private static OutputStream FileOutput$superArg$1$$anonfun$1(File file$2, boolean append$1) {
        return new FileOutputStream(file$2, append$1);
    }

    private static void $anonfun$2(ProcessIO io$2, java.lang.Process process$1) {
        io$2.writeInput().apply(process$1.getOutputStream());
    }

    public static /* bridge */ /* synthetic */ Object scala$sys$process$ProcessBuilderImpl$Simple$$_$_$$anonfun$adapted$2(ProcessIO io$7, java.lang.Process process$6) {
        ProcessBuilderImpl.$anonfun$2(io$7, process$6);
        return BoxedUnit.UNIT;
    }

    private static void $anonfun$3(ProcessIO io$3, java.lang.Process process$2) {
        io$3.processOutput().apply(process$2.getInputStream());
    }

    public static /* bridge */ /* synthetic */ Object scala$sys$process$ProcessBuilderImpl$Simple$$_$_$$anonfun$adapted$3(ProcessIO io$8, java.lang.Process process$7) {
        ProcessBuilderImpl.$anonfun$3(io$8, process$7);
        return BoxedUnit.UNIT;
    }

    private static void $anonfun$4(ProcessIO io$4, java.lang.Process process$3) {
        io$4.processError().apply(process$3.getErrorStream());
    }

    public static /* bridge */ /* synthetic */ Object scala$sys$process$ProcessBuilderImpl$Simple$$_$_$$anonfun$adapted$4(ProcessIO io$9, java.lang.Process process$8) {
        ProcessBuilderImpl.$anonfun$4(io$9, process$8);
        return BoxedUnit.UNIT;
    }

    public static Object scala$sys$process$ProcessBuilderImpl$AbstractBuilder$$_$$hash$bar$$anonfun$1() {
        return "Piping to multiple processes is not supported.";
    }

    private static void lazyLines$$anonfun$1(Function1 done$1, Process process$4) {
        Integer n;
        Function1 function1 = done$1;
        try {
            n = BoxesRunTime.boxToInteger(process$4.exitValue());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable throwable3 = option.get();
            n = BoxesRunTime.boxToInteger(-2);
        }
        Integer n2 = n;
        Function1 function12 = function1;
        function1 = null;
        Integer n3 = n2;
        n2 = null;
        function12.apply(n3);
    }

    public static /* bridge */ /* synthetic */ Object scala$sys$process$ProcessBuilderImpl$AbstractBuilder$$_$lazyLines$$anonfun$adapted$1(Function1 done$2, Process process$9) {
        ProcessBuilderImpl.lazyLines$$anonfun$1(done$2, process$9);
        return BoxedUnit.UNIT;
    }

    private static void lineStream$$anonfun$1(BasicIO.Streamed streamed$1, Process process$5) {
        streamed$1.done().apply(BoxesRunTime.boxToInteger(process$5.exitValue()));
    }

    public static /* bridge */ /* synthetic */ Object scala$sys$process$ProcessBuilderImpl$AbstractBuilder$$_$lineStream$$anonfun$adapted$1(BasicIO.Streamed streamed$2, Process process$10) {
        ProcessBuilderImpl.lineStream$$anonfun$1(streamed$2, process$10);
        return BoxedUnit.UNIT;
    }

    public static Object scala$sys$process$ProcessBuilderImpl$BasicBuilder$$_$checkNotThis$$anonfun$1(ProcessBuilder a$1) {
        return new StringBuilder(42).append("Compound process '").append(a$1).append("' cannot contain itself.").toString();
    }

    public abstract class AbstractBuilder
    implements ProcessBuilder.Source,
    ProcessBuilder.Sink,
    ProcessBuilder {
        private final int defaultStreamCapacity;

        public AbstractBuilder() {
            if (ProcessBuilderImpl.this == null) {
                throw new NullPointerException();
            }
            ProcessBuilder.Source.$init$(this);
            ProcessBuilder.Sink.$init$(this);
            this.defaultStreamCapacity = 4096;
        }

        @Override
        public ProcessBuilder $hash$greater(File f) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, f);
        }

        @Override
        public ProcessBuilder $hash$greater$greater(File f) {
            return ProcessBuilder.Source.$hash$greater$greater$(this, f);
        }

        @Override
        public ProcessBuilder $hash$greater(Function0<OutputStream> out) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, out);
        }

        @Override
        public ProcessBuilder $hash$greater(ProcessBuilder b) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, b);
        }

        @Override
        public ProcessBuilder cat() {
            return ProcessBuilder.Source.cat$(this);
        }

        @Override
        public ProcessBuilder $hash$less(File f) {
            return ProcessBuilder.Sink.$hash$less$((ProcessBuilder.Sink)this, f);
        }

        @Override
        public ProcessBuilder $hash$less(URL f) {
            return ProcessBuilder.Sink.$hash$less$((ProcessBuilder.Sink)this, f);
        }

        @Override
        public ProcessBuilder $hash$less(Function0<InputStream> in) {
            return ProcessBuilder.Sink.$hash$less$((ProcessBuilder.Sink)this, in);
        }

        @Override
        public ProcessBuilder $hash$less(ProcessBuilder b) {
            return ProcessBuilder.Sink.$hash$less$((ProcessBuilder.Sink)this, b);
        }

        @Override
        public AbstractBuilder toSource() {
            return this;
        }

        @Override
        public AbstractBuilder toSink() {
            return this;
        }

        @Override
        public ProcessBuilder $hash$bar(ProcessBuilder other) {
            Predef$.MODULE$.require(other.canPipeTo(), ProcessBuilderImpl::scala$sys$process$ProcessBuilderImpl$AbstractBuilder$$_$$hash$bar$$anonfun$1);
            return new PipedBuilder(ProcessBuilderImpl.this, (ProcessBuilder)this, other, false);
        }

        @Override
        public ProcessBuilder $hash$bar$bar(ProcessBuilder other) {
            return new OrBuilder(ProcessBuilderImpl.this, this, other);
        }

        @Override
        public ProcessBuilder $hash$amp$amp(ProcessBuilder other) {
            return new AndBuilder(ProcessBuilderImpl.this, this, other);
        }

        @Override
        public ProcessBuilder $hash$hash$hash(ProcessBuilder other) {
            return new SequenceBuilder(ProcessBuilderImpl.this, this, other);
        }

        @Override
        public Process run() {
            return this.run(false);
        }

        @Override
        public Process run(boolean connectInput) {
            return this.run(BasicIO$.MODULE$.standard(connectInput));
        }

        @Override
        public Process run(ProcessLogger log) {
            return this.run(log, false);
        }

        @Override
        public Process run(ProcessLogger log, boolean connectInput) {
            return this.run(BasicIO$.MODULE$.apply(connectInput, log));
        }

        @Override
        public String $bang$bang() {
            return this.slurp(None$.MODULE$, false);
        }

        @Override
        public String $bang$bang(ProcessLogger log) {
            return this.slurp(Some$.MODULE$.apply(log), false);
        }

        @Override
        public String $bang$bang$less() {
            return this.slurp(None$.MODULE$, true);
        }

        @Override
        public String $bang$bang$less(ProcessLogger log) {
            return this.slurp(Some$.MODULE$.apply(log), true);
        }

        @Override
        public LazyList<String> lazyLines() {
            return this.lazyLines(false, true, None$.MODULE$, Predef$.MODULE$.int2Integer(this.defaultStreamCapacity));
        }

        @Override
        public LazyList<String> lazyLines(ProcessLogger log) {
            return this.lazyLines(false, true, Some$.MODULE$.apply(log), Predef$.MODULE$.int2Integer(this.defaultStreamCapacity));
        }

        @Override
        public LazyList<String> lazyLines_$bang() {
            return this.lazyLines(false, false, None$.MODULE$, Predef$.MODULE$.int2Integer(this.defaultStreamCapacity));
        }

        @Override
        public LazyList<String> lazyLines_$bang(ProcessLogger log) {
            return this.lazyLines(false, false, Some$.MODULE$.apply(log), Predef$.MODULE$.int2Integer(this.defaultStreamCapacity));
        }

        @Override
        public LazyList<String> lazyLines(Integer capacity) {
            return this.lazyLines(false, true, None$.MODULE$, capacity);
        }

        @Override
        public LazyList<String> lazyLines(ProcessLogger log, Integer capacity) {
            return this.lazyLines(false, true, Some$.MODULE$.apply(log), capacity);
        }

        @Override
        public LazyList<String> lazyLines_$bang(Integer capacity) {
            return this.lazyLines(false, false, None$.MODULE$, capacity);
        }

        @Override
        public LazyList<String> lazyLines_$bang(ProcessLogger log, Integer capacity) {
            return this.lazyLines(false, false, Some$.MODULE$.apply(log), capacity);
        }

        @Override
        public Stream<String> lineStream() {
            return this.lineStream(false, true, None$.MODULE$, Predef$.MODULE$.int2Integer(this.defaultStreamCapacity));
        }

        @Override
        public Stream<String> lineStream(ProcessLogger log) {
            return this.lineStream(false, true, Some$.MODULE$.apply(log), Predef$.MODULE$.int2Integer(this.defaultStreamCapacity));
        }

        @Override
        public Stream<String> lineStream_$bang() {
            return this.lineStream(false, false, None$.MODULE$, Predef$.MODULE$.int2Integer(this.defaultStreamCapacity));
        }

        @Override
        public Stream<String> lineStream_$bang(ProcessLogger log) {
            return this.lineStream(false, false, Some$.MODULE$.apply(log), Predef$.MODULE$.int2Integer(this.defaultStreamCapacity));
        }

        @Override
        public Stream<String> lineStream(Integer capacity) {
            return this.lineStream(false, true, None$.MODULE$, capacity);
        }

        @Override
        public Stream<String> lineStream(ProcessLogger log, Integer capacity) {
            return this.lineStream(false, true, Some$.MODULE$.apply(log), capacity);
        }

        @Override
        public Stream<String> lineStream_$bang(Integer capacity) {
            return this.lineStream(false, false, None$.MODULE$, capacity);
        }

        @Override
        public Stream<String> lineStream_$bang(ProcessLogger log, Integer capacity) {
            return this.lineStream(false, false, Some$.MODULE$.apply(log), capacity);
        }

        @Override
        public int $bang() {
            return this.run(false).exitValue();
        }

        public int $bang(ProcessIO io) {
            return this.run(io).exitValue();
        }

        @Override
        public int $bang(ProcessLogger log) {
            return this.runBuffered(log, false);
        }

        @Override
        public int $bang$less() {
            return this.run(true).exitValue();
        }

        @Override
        public int $bang$less(ProcessLogger log) {
            return this.runBuffered(log, true);
        }

        public ProcessBuilder daemonized() {
            return new DaemonBuilder(ProcessBuilderImpl.this, this);
        }

        private String slurp(Option<ProcessLogger> log, boolean withIn) {
            StringBuffer buffer = new StringBuffer();
            int code = this.$bang(BasicIO$.MODULE$.apply(withIn, buffer, log));
            if (code == 0) {
                return buffer.toString();
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(20).append("Nonzero exit value: ").append(code).toString());
        }

        private LazyList<String> lazyLines(boolean withInput, boolean nonZeroException, Option<ProcessLogger> log, Integer capacity) {
            BasicIO.LazilyListed lazilyListed = BasicIO$LazilyListed$.MODULE$.apply(nonZeroException, capacity);
            Process process = this.run(BasicIO$.MODULE$.apply(withInput, lazilyListed.process(), log));
            Function1<Object, BoxedUnit> done = lazilyListed.done();
            Process$.MODULE$.Spawn().apply("LazyLines", Process$.MODULE$.Spawn().apply$default$2(), (Function0<BoxedUnit>)((Function0<Object> & Serializable)() -> ProcessBuilderImpl.scala$sys$process$ProcessBuilderImpl$AbstractBuilder$$_$lazyLines$$anonfun$adapted$1(done, process)));
            return lazilyListed.lazyList();
        }

        private Stream<String> lineStream(boolean withInput, boolean nonZeroException, Option<ProcessLogger> log, Integer capacity) {
            BasicIO.Streamed streamed = BasicIO$Streamed$.MODULE$.apply(nonZeroException, capacity);
            Process process = this.run(BasicIO$.MODULE$.apply(withInput, streamed.process(), log));
            Process$.MODULE$.Spawn().apply("LineStream", Process$.MODULE$.Spawn().apply$default$2(), (Function0<BoxedUnit>)((Function0<Object> & Serializable)() -> ProcessBuilderImpl.scala$sys$process$ProcessBuilderImpl$AbstractBuilder$$_$lineStream$$anonfun$adapted$1(streamed, process)));
            return streamed.stream().apply();
        }

        private int runBuffered(ProcessLogger log, boolean connectInput) {
            return BoxesRunTime.unboxToInt(log.buffer(() -> this.runBuffered$$anonfun$1(log, connectInput)));
        }

        @Override
        public boolean canPipeTo() {
            return false;
        }

        @Override
        public boolean hasExitValue() {
            return true;
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$AbstractBuilder$$$outer() {
            return ProcessBuilderImpl.this;
        }

        private final int runBuffered$$anonfun$1(ProcessLogger log$1, boolean connectInput$1) {
            return this.run(log$1, connectInput$1).exitValue();
        }
    }

    public class AndBuilder
    extends SequentialBuilder {
        private final ProcessBuilder first;
        private final ProcessBuilder second;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public AndBuilder(ProcessBuilderImpl $outer, ProcessBuilder first, ProcessBuilder second) {
            this.first = first;
            this.second = second;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, first, second, "#&&");
        }

        @Override
        public ProcessImpl.AndProcess createProcess(ProcessIO io) {
            return new ProcessImpl.AndProcess(Process$.MODULE$, this.first, this.second, io);
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$AndBuilder$$$outer() {
            return this.$outer;
        }
    }

    public abstract class BasicBuilder
    extends AbstractBuilder {
        public BasicBuilder() {
            if (ProcessBuilderImpl.this == null) {
                throw new NullPointerException();
            }
        }

        public void checkNotThis(ProcessBuilder a) {
            ProcessBuilder processBuilder = a;
            BasicBuilder basicBuilder = this;
            Predef$.MODULE$.require(processBuilder == null ? basicBuilder != null : !processBuilder.equals(basicBuilder), () -> ProcessBuilderImpl.scala$sys$process$ProcessBuilderImpl$BasicBuilder$$_$checkNotThis$$anonfun$1(a));
        }

        @Override
        public final Process run(ProcessIO io) {
            ProcessImpl.BasicProcess p = this.createProcess(io);
            p.start();
            return p;
        }

        public abstract ProcessImpl.BasicProcess createProcess(ProcessIO var1);

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$BasicBuilder$$$outer() {
            return ProcessBuilderImpl.this;
        }
    }

    public class DaemonBuilder
    extends AbstractBuilder {
        private final ProcessBuilder underlying;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public DaemonBuilder(ProcessBuilderImpl $outer, ProcessBuilder underlying) {
            this.underlying = underlying;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public final Process run(ProcessIO io) {
            return this.underlying.run(io.daemonized());
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$DaemonBuilder$$$outer() {
            return this.$outer;
        }
    }

    public class Dummy
    extends AbstractBuilder {
        private final String toString;
        private final Function0<Object> exitValue;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public Dummy(ProcessBuilderImpl $outer, String toString, Function0<Object> exitValue) {
            this.toString = toString;
            this.exitValue = exitValue;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String toString() {
            return this.toString;
        }

        @Override
        public Process run(ProcessIO io) {
            return new ProcessImpl.DummyProcess(Process$.MODULE$, this.exitValue);
        }

        @Override
        public boolean canPipeTo() {
            return true;
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$Dummy$$$outer() {
            return this.$outer;
        }
    }

    public class FileImpl
    implements ProcessBuilder.Sink,
    ProcessBuilder.Source,
    ProcessBuilder.FileBuilder {
        private final File base;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public FileImpl(ProcessBuilderImpl $outer, File base) {
            this.base = base;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            ProcessBuilder.Sink.$init$(this);
            ProcessBuilder.Source.$init$(this);
        }

        @Override
        public ProcessBuilder $hash$less(File f) {
            return ProcessBuilder.Sink.$hash$less$((ProcessBuilder.Sink)this, f);
        }

        @Override
        public ProcessBuilder $hash$less(URL f) {
            return ProcessBuilder.Sink.$hash$less$((ProcessBuilder.Sink)this, f);
        }

        @Override
        public ProcessBuilder $hash$less(Function0<InputStream> in) {
            return ProcessBuilder.Sink.$hash$less$((ProcessBuilder.Sink)this, in);
        }

        @Override
        public ProcessBuilder $hash$less(ProcessBuilder b) {
            return ProcessBuilder.Sink.$hash$less$((ProcessBuilder.Sink)this, b);
        }

        @Override
        public ProcessBuilder $hash$greater(File f) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, f);
        }

        @Override
        public ProcessBuilder $hash$greater$greater(File f) {
            return ProcessBuilder.Source.$hash$greater$greater$(this, f);
        }

        @Override
        public ProcessBuilder $hash$greater(Function0<OutputStream> out) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, out);
        }

        @Override
        public ProcessBuilder $hash$greater(ProcessBuilder b) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, b);
        }

        @Override
        public ProcessBuilder cat() {
            return ProcessBuilder.Source.cat$(this);
        }

        @Override
        public FileInput toSource() {
            return this.$outer.new FileInput(this.base);
        }

        @Override
        public FileOutput toSink() {
            return this.$outer.new FileOutput(this.base, false);
        }

        @Override
        public ProcessBuilder $hash$less$less(File f) {
            return this.$hash$less$less(this.$outer.new FileInput(f));
        }

        @Override
        public ProcessBuilder $hash$less$less(URL u) {
            return this.$hash$less$less(this.$outer.new URLInput(u));
        }

        @Override
        public ProcessBuilder $hash$less$less(Function0<InputStream> s) {
            return this.$hash$less$less(this.$outer.new IStreamBuilder(s, "<input stream>"));
        }

        @Override
        public ProcessBuilder $hash$less$less(ProcessBuilder b) {
            return new PipedBuilder(this.$outer, b, (ProcessBuilder)this.$outer.new FileOutput(this.base, true), false);
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$FileImpl$$$outer() {
            return this.$outer;
        }
    }

    public class FileInput
    extends IStreamBuilder {
        public FileInput(File file) {
            if (ProcessBuilderImpl.this == null) {
                throw new NullPointerException();
            }
            super(ProcessBuilderImpl.this.scala$sys$process$ProcessBuilderImpl$$FileInput$superArg$1(file), file.getAbsolutePath());
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$FileInput$$$outer() {
            return ProcessBuilderImpl.this;
        }
    }

    public class FileOutput
    extends OStreamBuilder {
        public FileOutput(File file, boolean append) {
            if (ProcessBuilderImpl.this == null) {
                throw new NullPointerException();
            }
            super(ProcessBuilderImpl.this.scala$sys$process$ProcessBuilderImpl$$FileOutput$superArg$1(file, append), file.getAbsolutePath());
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$FileOutput$$$outer() {
            return ProcessBuilderImpl.this;
        }
    }

    public class IStreamBuilder
    extends ThreadBuilder {
        public IStreamBuilder(Function0<InputStream> stream, String label) {
            if (ProcessBuilderImpl.this == null) {
                throw new NullPointerException();
            }
            super(ProcessBuilderImpl.this, label, ProcessBuilderImpl.this.scala$sys$process$ProcessBuilderImpl$$IStreamBuilder$superArg$1(stream, label));
        }

        @Override
        public boolean hasExitValue() {
            return false;
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$IStreamBuilder$$$outer() {
            return ProcessBuilderImpl.this;
        }
    }

    public class OStreamBuilder
    extends ThreadBuilder {
        public OStreamBuilder(Function0<OutputStream> stream, String label) {
            if (ProcessBuilderImpl.this == null) {
                throw new NullPointerException();
            }
            super(ProcessBuilderImpl.this, label, ProcessBuilderImpl.this.scala$sys$process$ProcessBuilderImpl$$OStreamBuilder$superArg$1(stream, label));
        }

        @Override
        public boolean hasExitValue() {
            return false;
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$OStreamBuilder$$$outer() {
            return ProcessBuilderImpl.this;
        }
    }

    public class OrBuilder
    extends SequentialBuilder {
        private final ProcessBuilder first;
        private final ProcessBuilder second;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public OrBuilder(ProcessBuilderImpl $outer, ProcessBuilder first, ProcessBuilder second) {
            this.first = first;
            this.second = second;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, first, second, "#||");
        }

        @Override
        public ProcessImpl.OrProcess createProcess(ProcessIO io) {
            return new ProcessImpl.OrProcess(Process$.MODULE$, this.first, this.second, io);
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$OrBuilder$$$outer() {
            return this.$outer;
        }
    }

    public class PipedBuilder
    extends SequentialBuilder {
        private final ProcessBuilder first;
        private final ProcessBuilder second;
        private final boolean toError;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public PipedBuilder(ProcessBuilderImpl $outer, ProcessBuilder first, ProcessBuilder second, boolean toError) {
            this.first = first;
            this.second = second;
            this.toError = toError;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, first, second, toError ? "#|!" : "#|");
        }

        @Override
        public ProcessImpl.PipedProcesses createProcess(ProcessIO io) {
            return new ProcessImpl.PipedProcesses(Process$.MODULE$, this.first, this.second, io, this.toError);
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$PipedBuilder$$$outer() {
            return this.$outer;
        }
    }

    public class SequenceBuilder
    extends SequentialBuilder {
        private final ProcessBuilder first;
        private final ProcessBuilder second;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public SequenceBuilder(ProcessBuilderImpl $outer, ProcessBuilder first, ProcessBuilder second) {
            this.first = first;
            this.second = second;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, first, second, "###");
        }

        @Override
        public ProcessImpl.ProcessSequence createProcess(ProcessIO io) {
            return new ProcessImpl.ProcessSequence(Process$.MODULE$, this.first, this.second, io);
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$SequenceBuilder$$$outer() {
            return this.$outer;
        }
    }

    public abstract class SequentialBuilder
    extends BasicBuilder {
        private final ProcessBuilder a;
        private final ProcessBuilder b;
        private final String operatorString;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public SequentialBuilder(ProcessBuilderImpl $outer, ProcessBuilder a, ProcessBuilder b, String operatorString) {
            this.a = a;
            this.b = b;
            this.operatorString = operatorString;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.checkNotThis(a);
            this.checkNotThis(b);
        }

        public String toString() {
            return new StringBuilder(8).append(" ( ").append(this.a).append(" ").append(this.operatorString).append(" ").append(this.b).append(" ) ").toString();
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$SequentialBuilder$$$outer() {
            return this.$outer;
        }
    }

    public class Simple
    extends AbstractBuilder {
        private final java.lang.ProcessBuilder p;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public Simple(ProcessBuilderImpl $outer, java.lang.ProcessBuilder p) {
            this.p = p;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Process run(ProcessIO io) {
            boolean inherit;
            boolean bl = inherit = io.writeInput() == BasicIO$.MODULE$.connectToStdIn();
            if (inherit) {
                this.p.redirectInput(ProcessBuilder.Redirect.INHERIT);
            }
            java.lang.Process process = this.p.start();
            Thread inThread = inherit || io.writeInput() == BasicIO$.MODULE$.connectNoOp() ? null : Process$.MODULE$.Spawn().apply("Simple-input", true, (Function0<BoxedUnit>)((Function0<Object> & Serializable)() -> ProcessBuilderImpl.scala$sys$process$ProcessBuilderImpl$Simple$$_$_$$anonfun$adapted$2(io, process)));
            Thread outThread = Process$.MODULE$.Spawn().apply("Simple-output", io.daemonizeThreads(), (Function0<BoxedUnit>)((Function0<Object> & Serializable)() -> ProcessBuilderImpl.scala$sys$process$ProcessBuilderImpl$Simple$$_$_$$anonfun$adapted$3(io, process)));
            Nil$ errorThread = this.p.redirectErrorStream() ? package$.MODULE$.Nil() : (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Process$.MODULE$.Spawn().apply("Simple-error", io.daemonizeThreads(), (Function0<BoxedUnit>)((Function0<Object> & Serializable)() -> ProcessBuilderImpl.scala$sys$process$ProcessBuilderImpl$Simple$$_$_$$anonfun$adapted$4(io, process)))), Nil$.MODULE$));
            return new ProcessImpl.SimpleProcess(Process$.MODULE$, process, inThread, errorThread.$colon$colon(outThread));
        }

        public String toString() {
            return this.p.command().toString();
        }

        @Override
        public boolean canPipeTo() {
            return true;
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$Simple$$$outer() {
            return this.$outer;
        }
    }

    public abstract class ThreadBuilder
    extends AbstractBuilder {
        private final String toString;
        private final Function1<ProcessIO, BoxedUnit> runImpl;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public ThreadBuilder(ProcessBuilderImpl $outer, String toString, Function1<ProcessIO, BoxedUnit> runImpl) {
            this.toString = toString;
            this.runImpl = runImpl;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String toString() {
            return this.toString;
        }

        @Override
        public Process run(ProcessIO io) {
            LinkedBlockingQueue<Object> success = new LinkedBlockingQueue<Object>(1);
            Thread t = Process$.MODULE$.Spawn().apply("ThreadProcess", io.daemonizeThreads(), (Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
                this.$anonfun$1(io, success);
                return BoxedUnit.UNIT;
            });
            return new ProcessImpl.ThreadProcess(Process$.MODULE$, t, success);
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$ThreadBuilder$$$outer() {
            return this.$outer;
        }

        private final void go$1(ProcessIO io$1, LinkedBlockingQueue success$1) {
            boolean ok = false;
            try {
                this.runImpl.apply(io$1);
                ok = true;
            }
            finally {
                success$1.put(BoxesRunTime.boxToBoolean(ok));
            }
        }

        private final void $anonfun$1(ProcessIO io$5, LinkedBlockingQueue success$2) {
            this.go$1(io$5, success$2);
        }
    }

    public class URLImpl
    implements ProcessBuilder.Source,
    ProcessBuilder.URLBuilder {
        private final URL url;
        private final /* synthetic */ ProcessBuilderImpl $outer;

        public URLImpl(ProcessBuilderImpl $outer, URL url) {
            this.url = url;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            ProcessBuilder.Source.$init$(this);
        }

        @Override
        public ProcessBuilder $hash$greater(File f) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, f);
        }

        @Override
        public ProcessBuilder $hash$greater$greater(File f) {
            return ProcessBuilder.Source.$hash$greater$greater$(this, f);
        }

        @Override
        public ProcessBuilder $hash$greater(Function0<OutputStream> out) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, out);
        }

        @Override
        public ProcessBuilder $hash$greater(ProcessBuilder b) {
            return ProcessBuilder.Source.$hash$greater$((ProcessBuilder.Source)this, b);
        }

        @Override
        public ProcessBuilder cat() {
            return ProcessBuilder.Source.cat$(this);
        }

        @Override
        public URLInput toSource() {
            return this.$outer.new URLInput(this.url);
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$URLImpl$$$outer() {
            return this.$outer;
        }
    }

    public class URLInput
    extends IStreamBuilder {
        public URLInput(URL url) {
            if (ProcessBuilderImpl.this == null) {
                throw new NullPointerException();
            }
            super(ProcessBuilderImpl.this.scala$sys$process$ProcessBuilderImpl$$URLInput$superArg$1(url), url.toString());
        }

        public final /* synthetic */ ProcessBuilderImpl scala$sys$process$ProcessBuilderImpl$URLInput$$$outer() {
            return ProcessBuilderImpl.this;
        }
    }
}

