/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.StringOps$;
import scala.io.Codec;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;

public class BufferedSource
extends Source {
    private static final VarHandle charReader$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(BufferedSource.class, "charReader$lzy1", Object.class);
    private final InputStream inputStream;
    private final int bufferSize;
    private final Codec codec;
    private boolean charReaderCreated;
    private volatile Object charReader$lzy1;
    private final Iterator<Object> iter;

    public BufferedSource(InputStream inputStream, int bufferSize, Codec codec) {
        this.inputStream = inputStream;
        this.bufferSize = bufferSize;
        this.codec = codec;
        this.charReaderCreated = false;
        this.iter = Iterator$.MODULE$.continually(() -> this.$init$$$anonfun$1(codec)).takeWhile((Function1<Object, Boolean> & Serializable)(A _$1) -> BufferedSource.$init$$$anonfun$2(BoxesRunTime.unboxToInt(_$1))).map((Function1<Object, Character> & Serializable)(A _$2) -> BufferedSource.$init$$$anonfun$3(BoxesRunTime.unboxToInt(_$2)));
    }

    public Codec codec() {
        return this.codec;
    }

    public BufferedSource(InputStream inputStream, Codec codec) {
        this(inputStream, Source$.MODULE$.DefaultBufSize(), codec);
    }

    public InputStreamReader reader() {
        return new InputStreamReader(this.inputStream, this.codec().decoder());
    }

    public BufferedReader bufferedReader() {
        return new BufferedReader(this.reader(), this.bufferSize);
    }

    private BufferedReader charReader() {
        Object object = this.charReader$lzy1;
        if (object instanceof BufferedReader) {
            return (BufferedReader)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (BufferedReader)this.charReader$lzyINIT1();
    }

    private Object charReader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.charReader$lzy1) == null) {
                    if (!charReader$lzy1$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BufferedReader bufferedReader = null;
                    try {
                        this.charReaderCreated = true;
                        bufferedReader = this.bufferedReader();
                        object2 = bufferedReader == null ? LazyVals$NullValue$.MODULE$ : bufferedReader;
                    }
                    finally {
                        if (!charReader$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.charReader$lzy1;
                            charReader$lzy1$lzyHandle.compareAndSet(this, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bufferedReader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    charReader$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Iterator<Object> iter() {
        return this.iter;
    }

    public BufferedReader scala$io$BufferedSource$$decachedReader() {
        if (this.charReaderCreated && this.iter().hasNext()) {
            PushbackReader pb = new PushbackReader(this.charReader());
            pb.unread(BoxesRunTime.unboxToChar(this.iter().next()));
            return new BufferedReader(pb, this.bufferSize);
        }
        return this.charReader();
    }

    @Override
    public Iterator<String> getLines() {
        return new BufferedLineIterator();
    }

    @Override
    public scala.collection.mutable.StringBuilder addString(scala.collection.mutable.StringBuilder sb, String start, String sep, String end) {
        if (sep.isEmpty()) {
            BufferedReader allReader = this.scala$io$BufferedSource$$decachedReader();
            char[] buf = new char[this.bufferSize];
            StringBuilder jsb = sb.underlying();
            if (start.length() != 0) {
                jsb.append(start);
            }
            int n = allReader.read(buf);
            while (n != -1) {
                jsb.append(buf, 0, n);
                n = allReader.read(buf);
            }
            if (end.length() != 0) {
                jsb.append(end);
            }
            return sb;
        }
        return StringOps$.MODULE$.addString$extension(Predef$.MODULE$.augmentString(this.mkString()), sb, start, sep, end);
    }

    private final int $init$$$anonfun$1$$anonfun$1() {
        return this.charReader().read();
    }

    private final int $init$$$anonfun$1(Codec codec$1) {
        return codec$1.wrap((Function0<Object>)((Function0<Integer> & Serializable)this::$init$$$anonfun$1$$anonfun$1));
    }

    private static final /* synthetic */ boolean $init$$$anonfun$2(int _$1) {
        return _$1 != -1;
    }

    private static final /* synthetic */ char $init$$$anonfun$3(int _$2) {
        return (char)_$2;
    }

    public class BufferedLineIterator
    extends AbstractIterator<String> {
        private final BufferedReader lineReader;
        private String nextLine;

        public BufferedLineIterator() {
            if (BufferedSource.this == null) {
                throw new NullPointerException();
            }
            this.lineReader = BufferedSource.this.scala$io$BufferedSource$$decachedReader();
            this.nextLine = null;
        }

        public String nextLine() {
            return this.nextLine;
        }

        public void nextLine_$eq(String x$1) {
            this.nextLine = x$1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextLine() == null) {
                this.nextLine_$eq(this.lineReader.readLine());
            }
            return this.nextLine() != null;
        }

        @Override
        public String next() {
            String string2;
            if (this.nextLine() == null) {
                string2 = this.lineReader.readLine();
            } else {
                try {
                    string2 = this.nextLine();
                }
                finally {
                    this.nextLine_$eq(null);
                }
            }
            String result = string2;
            if (result == null) {
                return (String)Iterator$.MODULE$.empty().next();
            }
            return result;
        }

        public final /* synthetic */ BufferedSource scala$io$BufferedSource$BufferedLineIterator$$$outer() {
            return BufferedSource.this;
        }
    }
}

