/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Hashing$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionSetNode;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetNode;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class HashSetBuilder<A>
implements ReusableBuilder<A, HashSet<A>> {
    private HashSet<A> aliased;
    public BitmapIndexedSetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode;

    public HashSetBuilder() {
        Growable.$init$(this);
        Builder.$init$(this);
        this.aliased = null;
        this.scala$collection$immutable$HashSetBuilder$$rootNode = this.newEmptyRootNode();
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable $plus$plus$eq(IterableOnce elems) {
        return Growable.$plus$plus$eq$(this, elems);
    }

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<HashSet<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    private BitmapIndexedSetNode<A> newEmptyRootNode() {
        return new BitmapIndexedSetNode(0, 0, Array$.MODULE$.emptyObjectArray(), Array$.MODULE$.emptyIntArray(), 0, 0);
    }

    private boolean isAliased() {
        return this.aliased != null;
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <A1> void insertValue(BitmapIndexedSetNode<A> bm, int bitpos, A key, int originalHash, int keyHash) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    private <A1> void setValue(BitmapIndexedSetNode<A> bm, int bitpos, A elem) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        bm.content()[idx] = elem;
    }

    public void update(SetNode<A> setNode, A element, int originalHash, int elementHash, int shift) {
        SetNode<A> setNode2 = setNode;
        if (setNode2 instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode;
            BitmapIndexedSetNode bm = bitmapIndexedSetNode = (BitmapIndexedSetNode)setNode2;
            int mask = Node$.MODULE$.maskFrom(elementHash, shift);
            int bitpos = Node$.MODULE$.bitposFrom(mask);
            if ((bm.dataMap() & bitpos) != 0) {
                int index = Node$.MODULE$.indexFrom(bm.dataMap(), mask, bitpos);
                Object element0 = bm.getPayload(index);
                int element0UnimprovedHash = bm.getHash(index);
                if (element0UnimprovedHash == originalHash && BoxesRunTime.equals(element0, element)) {
                    this.setValue(bm, bitpos, element0);
                    return;
                }
                int element0Hash = Hashing$.MODULE$.improve(element0UnimprovedHash);
                SetNode subNodeNew = bm.mergeTwoKeyValPairs(element0, element0UnimprovedHash, element0Hash, element, originalHash, elementHash, shift + 5);
                bm.migrateFromInlineToNodeInPlace(bitpos, element0Hash, subNodeNew);
                return;
            }
            if ((bm.nodeMap() & bitpos) != 0) {
                int index = Node$.MODULE$.indexFrom(bm.nodeMap(), mask, bitpos);
                Node subNode = bm.getNode(index);
                int beforeSize = ((SetNode)subNode).size();
                int beforeHashCode = subNode.cachedJavaKeySetHashCode();
                this.update((SetNode<A>)subNode, element, originalHash, elementHash, shift + 5);
                bm.size_$eq(bm.size() + (((SetNode)subNode).size() - beforeSize));
                bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHashCode));
                return;
            }
            this.insertValue(bm, bitpos, element, originalHash, elementHash);
            return;
        }
        if (setNode2 instanceof HashCollisionSetNode) {
            HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)setNode2;
            HashCollisionSetNode hc = hashCollisionSetNode;
            int index = hc.content().indexOf(element);
            if (index < 0) {
                hc.content_$eq(hc.content().appended(element));
                return;
            }
            hc.content_$eq(hc.content().updated(index, element));
            return;
        }
        throw new MatchError(setNode2);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased = null;
    }

    private void copyElems() {
        this.scala$collection$immutable$HashSetBuilder$$rootNode = this.scala$collection$immutable$HashSetBuilder$$rootNode.copy();
    }

    @Override
    public HashSet<A> result() {
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode.size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        if (this.aliased != null) {
            return this.aliased;
        }
        this.aliased = new HashSet<A>(this.scala$collection$immutable$HashSetBuilder$$rootNode);
        Statics.releaseFence();
        return this.aliased;
    }

    @Override
    public HashSetBuilder<A> addOne(A elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem);
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashSetBuilder$$rootNode, elem, h, im, 0);
        return this;
    }

    @Override
    public HashSetBuilder<A> addAll(IterableOnce<A> xs) {
        Object object;
        this.ensureUnaliased();
        IterableOnce<A> iterableOnce = xs;
        if (iterableOnce instanceof HashSet) {
            HashSet hashSet;
            HashSet hm = hashSet = (HashSet)iterableOnce;
            object = new ChampBaseIterator<A, SetNode<A>>(hm, this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(hm$1.rootNode());
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashSetBuilder$$rootNode, ((SetNode)this.currentValueNode()).getPayload(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }

                public Object next() {
                    return Iterator$.MODULE$.empty().next();
                }
            };
        } else {
            IterableOnce<A> other = iterableOnce;
            Iterator<A> it = other.iterator();
            while (it.hasNext()) {
                this.addOne((Object)it.next());
            }
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    @Override
    public void clear() {
        this.aliased = null;
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode.size() > 0) {
            this.scala$collection$immutable$HashSetBuilder$$rootNode = this.newEmptyRootNode();
            return;
        }
    }

    public int size() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode.size();
    }

    @Override
    public int knownSize() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode.size();
    }
}

