/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import scala.Option;
import scala.collection.StringParsers$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Fractional;
import scala.math.Integral;
import scala.math.Numeric$;
import scala.math.Numeric$BigDecimalIsConflicted$;
import scala.math.Ordering;
import scala.math.package$;
import scala.util.Try$;

public interface Numeric<T>
extends Ordering<T> {
    public static <T> Numeric<T> apply(Numeric<T> numeric) {
        return Numeric$.MODULE$.apply(numeric);
    }

    public static void $init$(Numeric $this) {
    }

    public T plus(T var1, T var2);

    public T minus(T var1, T var2);

    public T times(T var1, T var2);

    public T negate(T var1);

    public T fromInt(int var1);

    public Option<T> parseString(String var1);

    public int toInt(T var1);

    public long toLong(T var1);

    public float toFloat(T var1);

    public double toDouble(T var1);

    public static Object zero$(Numeric $this) {
        return $this.zero();
    }

    default public T zero() {
        return this.fromInt(0);
    }

    public static Object one$(Numeric $this) {
        return $this.one();
    }

    default public T one() {
        return this.fromInt(1);
    }

    public static Object abs$(Numeric $this, Object x) {
        return $this.abs(x);
    }

    default public T abs(T x) {
        if (this.lt(x, this.zero())) {
            return this.negate(x);
        }
        return x;
    }

    public static int signum$(Numeric $this, Object x) {
        return $this.signum(x);
    }

    default public int signum(T x) {
        if (this.lt(x, this.zero())) {
            return -1;
        }
        if (this.gt(x, this.zero())) {
            return 1;
        }
        return 0;
    }

    public static Object sign$(Numeric $this, Object x) {
        return $this.sign(x);
    }

    default public T sign(T x) {
        if (this.lt(x, this.zero())) {
            return this.negate(this.one());
        }
        if (this.gt(x, this.zero())) {
            return this.one();
        }
        return this.zero();
    }

    public static NumericOps mkNumericOps$(Numeric $this, Object lhs) {
        return $this.mkNumericOps(lhs);
    }

    default public NumericOps mkNumericOps(T lhs) {
        return new NumericOps(this, lhs);
    }

    public static interface BigDecimalAsIfIntegral
    extends BigDecimalIsConflicted,
    Integral<BigDecimal> {
        public static void $init$(BigDecimalAsIfIntegral $this) {
        }

        public static BigDecimal quot$(BigDecimalAsIfIntegral $this, BigDecimal x, BigDecimal y) {
            return $this.quot(x, y);
        }

        @Override
        default public BigDecimal quot(BigDecimal x, BigDecimal y) {
            return x.quot(y);
        }

        public static BigDecimal rem$(BigDecimalAsIfIntegral $this, BigDecimal x, BigDecimal y) {
            return $this.rem(x, y);
        }

        @Override
        default public BigDecimal rem(BigDecimal x, BigDecimal y) {
            return x.remainder(y);
        }
    }

    public static interface BigDecimalIsConflicted
    extends Numeric<BigDecimal> {
        public static void $init$(BigDecimalIsConflicted $this) {
        }

        public static BigDecimal plus$(BigDecimalIsConflicted $this, BigDecimal x, BigDecimal y) {
            return $this.plus(x, y);
        }

        @Override
        default public BigDecimal plus(BigDecimal x, BigDecimal y) {
            if (x == Numeric$BigDecimalIsConflicted$.scala$math$Numeric$BigDecimalIsConflicted$$$_0) {
                return y;
            }
            return x.$plus(y);
        }

        public static BigDecimal minus$(BigDecimalIsConflicted $this, BigDecimal x, BigDecimal y) {
            return $this.minus(x, y);
        }

        @Override
        default public BigDecimal minus(BigDecimal x, BigDecimal y) {
            if (x == Numeric$BigDecimalIsConflicted$.scala$math$Numeric$BigDecimalIsConflicted$$$_0) {
                return y.unary_$minus();
            }
            return x.$minus(y);
        }

        public static BigDecimal times$(BigDecimalIsConflicted $this, BigDecimal x, BigDecimal y) {
            return $this.times(x, y);
        }

        @Override
        default public BigDecimal times(BigDecimal x, BigDecimal y) {
            if (x == Numeric$BigDecimalIsConflicted$.scala$math$Numeric$BigDecimalIsConflicted$$$_1) {
                return y;
            }
            return x.$times(y);
        }

        public static BigDecimal negate$(BigDecimalIsConflicted $this, BigDecimal x) {
            return $this.negate(x);
        }

        @Override
        default public BigDecimal negate(BigDecimal x) {
            return x.unary_$minus();
        }

        public static BigDecimal fromInt$(BigDecimalIsConflicted $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public BigDecimal fromInt(int x) {
            return BigDecimal$.MODULE$.apply(x);
        }

        public static Option parseString$(BigDecimalIsConflicted $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<BigDecimal> parseString(String str) {
            return Try$.MODULE$.apply(() -> Numeric$.scala$math$Numeric$BigDecimalIsConflicted$$_$parseString$$anonfun$3(str)).toOption();
        }

        public static int toInt$(BigDecimalIsConflicted $this, BigDecimal x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(BigDecimal x) {
            return x.intValue();
        }

        public static long toLong$(BigDecimalIsConflicted $this, BigDecimal x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(BigDecimal x) {
            return x.longValue();
        }

        public static float toFloat$(BigDecimalIsConflicted $this, BigDecimal x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(BigDecimal x) {
            return x.floatValue();
        }

        public static double toDouble$(BigDecimalIsConflicted $this, BigDecimal x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(BigDecimal x) {
            return x.doubleValue();
        }
    }

    public static interface BigDecimalIsFractional
    extends BigDecimalIsConflicted,
    Fractional<BigDecimal> {
        public static void $init$(BigDecimalIsFractional $this) {
        }

        public static BigDecimal div$(BigDecimalIsFractional $this, BigDecimal x, BigDecimal y) {
            return $this.div(x, y);
        }

        @Override
        default public BigDecimal div(BigDecimal x, BigDecimal y) {
            return x.$div(y);
        }
    }

    public static interface BigIntIsIntegral
    extends Integral<BigInt> {
        public static void $init$(BigIntIsIntegral $this) {
        }

        public static BigInt plus$(BigIntIsIntegral $this, BigInt x, BigInt y) {
            return $this.plus(x, y);
        }

        @Override
        default public BigInt plus(BigInt x, BigInt y) {
            return x.$plus(y);
        }

        public static BigInt minus$(BigIntIsIntegral $this, BigInt x, BigInt y) {
            return $this.minus(x, y);
        }

        @Override
        default public BigInt minus(BigInt x, BigInt y) {
            return x.$minus(y);
        }

        public static BigInt times$(BigIntIsIntegral $this, BigInt x, BigInt y) {
            return $this.times(x, y);
        }

        @Override
        default public BigInt times(BigInt x, BigInt y) {
            return x.$times(y);
        }

        public static BigInt quot$(BigIntIsIntegral $this, BigInt x, BigInt y) {
            return $this.quot(x, y);
        }

        @Override
        default public BigInt quot(BigInt x, BigInt y) {
            return x.$div(y);
        }

        public static BigInt rem$(BigIntIsIntegral $this, BigInt x, BigInt y) {
            return $this.rem(x, y);
        }

        @Override
        default public BigInt rem(BigInt x, BigInt y) {
            return x.$percent(y);
        }

        public static BigInt negate$(BigIntIsIntegral $this, BigInt x) {
            return $this.negate(x);
        }

        @Override
        default public BigInt negate(BigInt x) {
            return x.unary_$minus();
        }

        public static BigInt fromInt$(BigIntIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public BigInt fromInt(int x) {
            return BigInt$.MODULE$.apply(x);
        }

        public static Option parseString$(BigIntIsIntegral $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<BigInt> parseString(String str) {
            return Try$.MODULE$.apply(() -> Numeric$.scala$math$Numeric$BigIntIsIntegral$$_$parseString$$anonfun$1(str)).toOption();
        }

        public static int toInt$(BigIntIsIntegral $this, BigInt x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(BigInt x) {
            return x.intValue();
        }

        public static long toLong$(BigIntIsIntegral $this, BigInt x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(BigInt x) {
            return x.longValue();
        }

        public static float toFloat$(BigIntIsIntegral $this, BigInt x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(BigInt x) {
            return x.floatValue();
        }

        public static double toDouble$(BigIntIsIntegral $this, BigInt x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(BigInt x) {
            return x.doubleValue();
        }
    }

    public static interface ByteIsIntegral
    extends Integral<Object> {
        public static void $init$(ByteIsIntegral $this) {
        }

        public static byte plus$(ByteIsIntegral $this, byte x, byte y) {
            return $this.plus(x, y);
        }

        @Override
        default public byte plus(byte x, byte y) {
            return (byte)(x + y);
        }

        public static byte minus$(ByteIsIntegral $this, byte x, byte y) {
            return $this.minus(x, y);
        }

        @Override
        default public byte minus(byte x, byte y) {
            return (byte)(x - y);
        }

        public static byte times$(ByteIsIntegral $this, byte x, byte y) {
            return $this.times(x, y);
        }

        @Override
        default public byte times(byte x, byte y) {
            return (byte)(x * y);
        }

        public static byte quot$(ByteIsIntegral $this, byte x, byte y) {
            return $this.quot(x, y);
        }

        @Override
        default public byte quot(byte x, byte y) {
            return (byte)(x / y);
        }

        public static byte rem$(ByteIsIntegral $this, byte x, byte y) {
            return $this.rem(x, y);
        }

        @Override
        default public byte rem(byte x, byte y) {
            return (byte)(x % y);
        }

        public static byte negate$(ByteIsIntegral $this, byte x) {
            return $this.negate(x);
        }

        @Override
        default public byte negate(byte x) {
            return -x;
        }

        public static byte fromInt$(ByteIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public byte fromInt(int x) {
            return (byte)x;
        }

        public static Option parseString$(ByteIsIntegral $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<Object> parseString(String str) {
            return StringParsers$.MODULE$.parseByte(str);
        }

        public static int toInt$(ByteIsIntegral $this, byte x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(byte x) {
            return x;
        }

        public static long toLong$(ByteIsIntegral $this, byte x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(byte x) {
            return x;
        }

        public static float toFloat$(ByteIsIntegral $this, byte x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(byte x) {
            return x;
        }

        public static double toDouble$(ByteIsIntegral $this, byte x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(byte x) {
            return x;
        }

        public static int signum$(ByteIsIntegral $this, byte x) {
            return $this.signum(x);
        }

        @Override
        default public int signum(byte x) {
            return package$.MODULE$.signum(x);
        }

        public static byte sign$(ByteIsIntegral $this, byte x) {
            return $this.sign(x);
        }

        @Override
        default public byte sign(byte x) {
            return (byte)package$.MODULE$.signum(x);
        }
    }

    public static interface CharIsIntegral
    extends Integral<Object> {
        public static void $init$(CharIsIntegral $this) {
        }

        public static char plus$(CharIsIntegral $this, char x, char y) {
            return $this.plus(x, y);
        }

        @Override
        default public char plus(char x, char y) {
            return (char)(x + y);
        }

        public static char minus$(CharIsIntegral $this, char x, char y) {
            return $this.minus(x, y);
        }

        @Override
        default public char minus(char x, char y) {
            return (char)(x - y);
        }

        public static char times$(CharIsIntegral $this, char x, char y) {
            return $this.times(x, y);
        }

        @Override
        default public char times(char x, char y) {
            return (char)(x * y);
        }

        public static char quot$(CharIsIntegral $this, char x, char y) {
            return $this.quot(x, y);
        }

        @Override
        default public char quot(char x, char y) {
            return (char)(x / y);
        }

        public static char rem$(CharIsIntegral $this, char x, char y) {
            return $this.rem(x, y);
        }

        @Override
        default public char rem(char x, char y) {
            return (char)(x % y);
        }

        public static char negate$(CharIsIntegral $this, char x) {
            return $this.negate(x);
        }

        @Override
        default public char negate(char x) {
            return -x;
        }

        public static char fromInt$(CharIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public char fromInt(int x) {
            return (char)x;
        }

        public static Option parseString$(CharIsIntegral $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<Object> parseString(String str) {
            return Try$.MODULE$.apply(() -> Numeric$.scala$math$Numeric$CharIsIntegral$$_$parseString$$anonfun$2(str)).toOption();
        }

        public static int toInt$(CharIsIntegral $this, char x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(char x) {
            return x;
        }

        public static long toLong$(CharIsIntegral $this, char x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(char x) {
            return x;
        }

        public static float toFloat$(CharIsIntegral $this, char x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(char x) {
            return x;
        }

        public static double toDouble$(CharIsIntegral $this, char x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(char x) {
            return x;
        }

        public static int signum$(CharIsIntegral $this, char x) {
            return $this.signum(x);
        }

        @Override
        default public int signum(char x) {
            return package$.MODULE$.signum(x);
        }

        public static char sign$(CharIsIntegral $this, char x) {
            return $this.sign(x);
        }

        @Override
        default public char sign(char x) {
            return (char)package$.MODULE$.signum(x);
        }
    }

    public static interface DoubleIsFractional
    extends Fractional<Object> {
        public static void $init$(DoubleIsFractional $this) {
        }

        public static double plus$(DoubleIsFractional $this, double x, double y) {
            return $this.plus(x, y);
        }

        @Override
        default public double plus(double x, double y) {
            return x + y;
        }

        public static double minus$(DoubleIsFractional $this, double x, double y) {
            return $this.minus(x, y);
        }

        @Override
        default public double minus(double x, double y) {
            return x - y;
        }

        public static double times$(DoubleIsFractional $this, double x, double y) {
            return $this.times(x, y);
        }

        @Override
        default public double times(double x, double y) {
            return x * y;
        }

        public static double negate$(DoubleIsFractional $this, double x) {
            return $this.negate(x);
        }

        @Override
        default public double negate(double x) {
            return -x;
        }

        public static double fromInt$(DoubleIsFractional $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public double fromInt(int x) {
            return x;
        }

        public static Option parseString$(DoubleIsFractional $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<Object> parseString(String str) {
            return StringParsers$.MODULE$.parseDouble(str);
        }

        public static int toInt$(DoubleIsFractional $this, double x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(double x) {
            return (int)x;
        }

        public static long toLong$(DoubleIsFractional $this, double x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(double x) {
            return (long)x;
        }

        public static float toFloat$(DoubleIsFractional $this, double x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(double x) {
            return (float)x;
        }

        public static double toDouble$(DoubleIsFractional $this, double x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(double x) {
            return x;
        }

        public static double div$(DoubleIsFractional $this, double x, double y) {
            return $this.div(x, y);
        }

        @Override
        default public double div(double x, double y) {
            return x / y;
        }

        public static double abs$(DoubleIsFractional $this, double x) {
            return $this.abs(x);
        }

        @Override
        default public double abs(double x) {
            return package$.MODULE$.abs(x);
        }

        public static double sign$(DoubleIsFractional $this, double x) {
            return $this.sign(x);
        }

        @Override
        default public double sign(double x) {
            return package$.MODULE$.signum(x);
        }
    }

    public static interface ExtraImplicits {
        public static void $init$(ExtraImplicits $this) {
        }

        public static NumericOps infixNumericOps$(ExtraImplicits $this, Object x, Numeric num) {
            return $this.infixNumericOps(x, num);
        }

        default public <T> NumericOps infixNumericOps(T x, Numeric<T> num) {
            return new NumericOps(num, x);
        }
    }

    public static interface FloatIsFractional
    extends Fractional<Object> {
        public static void $init$(FloatIsFractional $this) {
        }

        public static float plus$(FloatIsFractional $this, float x, float y) {
            return $this.plus(x, y);
        }

        @Override
        default public float plus(float x, float y) {
            return x + y;
        }

        public static float minus$(FloatIsFractional $this, float x, float y) {
            return $this.minus(x, y);
        }

        @Override
        default public float minus(float x, float y) {
            return x - y;
        }

        public static float times$(FloatIsFractional $this, float x, float y) {
            return $this.times(x, y);
        }

        @Override
        default public float times(float x, float y) {
            return x * y;
        }

        public static float negate$(FloatIsFractional $this, float x) {
            return $this.negate(x);
        }

        @Override
        default public float negate(float x) {
            return -x;
        }

        public static float fromInt$(FloatIsFractional $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public float fromInt(int x) {
            return x;
        }

        public static Option parseString$(FloatIsFractional $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<Object> parseString(String str) {
            return StringParsers$.MODULE$.parseFloat(str);
        }

        public static int toInt$(FloatIsFractional $this, float x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(float x) {
            return (int)x;
        }

        public static long toLong$(FloatIsFractional $this, float x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(float x) {
            return (long)x;
        }

        public static float toFloat$(FloatIsFractional $this, float x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(float x) {
            return x;
        }

        public static double toDouble$(FloatIsFractional $this, float x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(float x) {
            return x;
        }

        public static float div$(FloatIsFractional $this, float x, float y) {
            return $this.div(x, y);
        }

        @Override
        default public float div(float x, float y) {
            return x / y;
        }

        public static float abs$(FloatIsFractional $this, float x) {
            return $this.abs(x);
        }

        @Override
        default public float abs(float x) {
            return package$.MODULE$.abs(x);
        }

        public static float sign$(FloatIsFractional $this, float x) {
            return $this.sign(x);
        }

        @Override
        default public float sign(float x) {
            return package$.MODULE$.signum(x);
        }
    }

    public static interface IntIsIntegral
    extends Integral<Object> {
        public static void $init$(IntIsIntegral $this) {
        }

        public static int plus$(IntIsIntegral $this, int x, int y) {
            return $this.plus(x, y);
        }

        @Override
        default public int plus(int x, int y) {
            return x + y;
        }

        public static int minus$(IntIsIntegral $this, int x, int y) {
            return $this.minus(x, y);
        }

        @Override
        default public int minus(int x, int y) {
            return x - y;
        }

        public static int times$(IntIsIntegral $this, int x, int y) {
            return $this.times(x, y);
        }

        @Override
        default public int times(int x, int y) {
            return x * y;
        }

        public static int quot$(IntIsIntegral $this, int x, int y) {
            return $this.quot(x, y);
        }

        @Override
        default public int quot(int x, int y) {
            return x / y;
        }

        public static int rem$(IntIsIntegral $this, int x, int y) {
            return $this.rem(x, y);
        }

        @Override
        default public int rem(int x, int y) {
            return x % y;
        }

        public static int negate$(IntIsIntegral $this, int x) {
            return $this.negate(x);
        }

        @Override
        default public int negate(int x) {
            return -x;
        }

        public static int fromInt$(IntIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public int fromInt(int x) {
            return x;
        }

        public static Option parseString$(IntIsIntegral $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<Object> parseString(String str) {
            return StringParsers$.MODULE$.parseInt(str);
        }

        public static int toInt$(IntIsIntegral $this, int x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(int x) {
            return x;
        }

        public static long toLong$(IntIsIntegral $this, int x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(int x) {
            return x;
        }

        public static float toFloat$(IntIsIntegral $this, int x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(int x) {
            return x;
        }

        public static double toDouble$(IntIsIntegral $this, int x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(int x) {
            return x;
        }

        public static int signum$(IntIsIntegral $this, int x) {
            return $this.signum(x);
        }

        @Override
        default public int signum(int x) {
            return package$.MODULE$.signum(x);
        }

        public static int sign$(IntIsIntegral $this, int x) {
            return $this.sign(x);
        }

        @Override
        default public int sign(int x) {
            return package$.MODULE$.signum(x);
        }
    }

    public static interface LongIsIntegral
    extends Integral<Object> {
        public static void $init$(LongIsIntegral $this) {
        }

        public static long plus$(LongIsIntegral $this, long x, long y) {
            return $this.plus(x, y);
        }

        @Override
        default public long plus(long x, long y) {
            return x + y;
        }

        public static long minus$(LongIsIntegral $this, long x, long y) {
            return $this.minus(x, y);
        }

        @Override
        default public long minus(long x, long y) {
            return x - y;
        }

        public static long times$(LongIsIntegral $this, long x, long y) {
            return $this.times(x, y);
        }

        @Override
        default public long times(long x, long y) {
            return x * y;
        }

        public static long quot$(LongIsIntegral $this, long x, long y) {
            return $this.quot(x, y);
        }

        @Override
        default public long quot(long x, long y) {
            return x / y;
        }

        public static long rem$(LongIsIntegral $this, long x, long y) {
            return $this.rem(x, y);
        }

        @Override
        default public long rem(long x, long y) {
            return x % y;
        }

        public static long negate$(LongIsIntegral $this, long x) {
            return $this.negate(x);
        }

        @Override
        default public long negate(long x) {
            return -x;
        }

        public static long fromInt$(LongIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public long fromInt(int x) {
            return x;
        }

        public static Option parseString$(LongIsIntegral $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<Object> parseString(String str) {
            return StringParsers$.MODULE$.parseLong(str);
        }

        public static int toInt$(LongIsIntegral $this, long x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(long x) {
            return (int)x;
        }

        public static long toLong$(LongIsIntegral $this, long x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(long x) {
            return x;
        }

        public static float toFloat$(LongIsIntegral $this, long x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(long x) {
            return x;
        }

        public static double toDouble$(LongIsIntegral $this, long x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(long x) {
            return x;
        }

        public static int signum$(LongIsIntegral $this, long x) {
            return $this.signum(x);
        }

        @Override
        default public int signum(long x) {
            return (int)package$.MODULE$.signum(x);
        }

        public static long sign$(LongIsIntegral $this, long x) {
            return $this.sign(x);
        }

        @Override
        default public long sign(long x) {
            return package$.MODULE$.signum(x);
        }
    }

    public class NumericOps {
        private final T lhs;
        private final /* synthetic */ Numeric $outer;

        public NumericOps(Numeric $outer, T lhs) {
            this.lhs = lhs;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public T $plus(T rhs) {
            return this.$outer.plus(this.lhs, rhs);
        }

        public T $minus(T rhs) {
            return this.$outer.minus(this.lhs, rhs);
        }

        public T $times(T rhs) {
            return this.$outer.times(this.lhs, rhs);
        }

        public T unary_$minus() {
            return this.$outer.negate(this.lhs);
        }

        public T abs() {
            return this.$outer.abs(this.lhs);
        }

        public int signum() {
            return this.$outer.signum(this.lhs);
        }

        public T sign() {
            return this.$outer.sign(this.lhs);
        }

        public int toInt() {
            return this.$outer.toInt(this.lhs);
        }

        public long toLong() {
            return this.$outer.toLong(this.lhs);
        }

        public float toFloat() {
            return this.$outer.toFloat(this.lhs);
        }

        public double toDouble() {
            return this.$outer.toDouble(this.lhs);
        }

        public final /* synthetic */ Numeric scala$math$Numeric$NumericOps$$$outer() {
            return this.$outer;
        }
    }

    public static interface ShortIsIntegral
    extends Integral<Object> {
        public static void $init$(ShortIsIntegral $this) {
        }

        public static short plus$(ShortIsIntegral $this, short x, short y) {
            return $this.plus(x, y);
        }

        @Override
        default public short plus(short x, short y) {
            return (short)(x + y);
        }

        public static short minus$(ShortIsIntegral $this, short x, short y) {
            return $this.minus(x, y);
        }

        @Override
        default public short minus(short x, short y) {
            return (short)(x - y);
        }

        public static short times$(ShortIsIntegral $this, short x, short y) {
            return $this.times(x, y);
        }

        @Override
        default public short times(short x, short y) {
            return (short)(x * y);
        }

        public static short quot$(ShortIsIntegral $this, short x, short y) {
            return $this.quot(x, y);
        }

        @Override
        default public short quot(short x, short y) {
            return (short)(x / y);
        }

        public static short rem$(ShortIsIntegral $this, short x, short y) {
            return $this.rem(x, y);
        }

        @Override
        default public short rem(short x, short y) {
            return (short)(x % y);
        }

        public static short negate$(ShortIsIntegral $this, short x) {
            return $this.negate(x);
        }

        @Override
        default public short negate(short x) {
            return -x;
        }

        public static short fromInt$(ShortIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        @Override
        default public short fromInt(int x) {
            return (short)x;
        }

        public static Option parseString$(ShortIsIntegral $this, String str) {
            return $this.parseString(str);
        }

        @Override
        default public Option<Object> parseString(String str) {
            return StringParsers$.MODULE$.parseShort(str);
        }

        public static int toInt$(ShortIsIntegral $this, short x) {
            return $this.toInt(x);
        }

        @Override
        default public int toInt(short x) {
            return x;
        }

        public static long toLong$(ShortIsIntegral $this, short x) {
            return $this.toLong(x);
        }

        @Override
        default public long toLong(short x) {
            return x;
        }

        public static float toFloat$(ShortIsIntegral $this, short x) {
            return $this.toFloat(x);
        }

        @Override
        default public float toFloat(short x) {
            return x;
        }

        public static double toDouble$(ShortIsIntegral $this, short x) {
            return $this.toDouble(x);
        }

        @Override
        default public double toDouble(short x) {
            return x;
        }

        public static int signum$(ShortIsIntegral $this, short x) {
            return $this.signum(x);
        }

        @Override
        default public int signum(short x) {
            return package$.MODULE$.signum(x);
        }

        public static short sign$(ShortIsIntegral $this, short x) {
            return $this.sign(x);
        }

        @Override
        default public short sign(short x) {
            return (short)package$.MODULE$.signum(x);
        }
    }
}

