/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$Pair$;
import scala.ScalaObject;
import scala.Some;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.actors.AbstractActor;
import scala.actors.Actor$;
import scala.actors.Debug$;
import scala.actors.OutputChannel;
import scala.actors.remote.FreshNameCreator$;
import scala.actors.remote.LocalApply0;
import scala.actors.remote.Locator;
import scala.actors.remote.NamedSend;
import scala.actors.remote.NetKernel$;
import scala.actors.remote.Node;
import scala.actors.remote.Proxy;
import scala.actors.remote.RemoteApply0;
import scala.actors.remote.SendTo;
import scala.actors.remote.Service;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.StringAdd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetKernel
implements ScalaObject {
    private static final /* synthetic */ Symbol symbol$1;
    private final HashMap<Tuple2<Node, Symbol>, Proxy> proxies;
    private final HashMap<OutputChannel<Object>, Symbol> names;
    private final HashMap<Symbol, OutputChannel<Object>> actors;
    private final Service service;

    static {
        symbol$1 = (Symbol)Symbol$.MODULE$.apply("nosession");
    }

    public NetKernel(Service service) {
        this.service = service;
        this.actors = new HashMap();
        this.names = new HashMap();
        this.proxies = new HashMap();
    }

    private final void liftedTree1$1(Locator locator, byte[] byArray, Symbol symbol, OutputChannel outputChannel) {
        try {
            Object msg = this.service.serializer().deserialize(byArray);
            Proxy senderProxy = this.getOrCreateProxy(locator.node(), locator.name());
            senderProxy.send(new SendTo(outputChannel, msg, symbol), (OutputChannel<Object>)null);
        }
        catch (Exception exception) {
            Debug$.MODULE$.error(new StringBuilder().append((Object)new StringAdd(this).$plus(": caught ")).append(exception).toString());
        }
    }

    public void terminate() {
        this.proxies().valuesIterator().foreach(new $anonfun$terminate$1(this));
        this.service.terminate();
    }

    public void processMsg(Node senderNode, Object msg) {
        synchronized (this) {
            block9: {
                Option<OutputChannel<Object>> temp47;
                block11: {
                    block7: {
                        block10: {
                            block5: {
                                Option<OutputChannel<Object>> temp43;
                                block8: {
                                    block6: {
                                        if (!(msg instanceof RemoteApply0)) break block5;
                                        RemoteApply0 temp52 = (RemoteApply0)msg;
                                        Locator temp53 = temp52.senderLoc();
                                        Locator temp54 = temp52.receiverLoc();
                                        Function2<AbstractActor, Proxy, Object> temp55 = temp52.rfun();
                                        Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": processing ")).append(temp52).toString());
                                        temp43 = this.actors().get(temp54.name());
                                        if (!(temp43 instanceof Some)) break block6;
                                        Some temp44 = (Some)temp43;
                                        OutputChannel temp45 = (OutputChannel)temp44.x();
                                        Proxy senderProxy = this.getOrCreateProxy(temp53.node(), temp53.name());
                                        senderProxy.send(new LocalApply0(temp55, (AbstractActor)temp45), (OutputChannel<Object>)null);
                                        break block7;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    if (none$ != null ? !none$.equals(temp43) : temp43 != null) break block8;
                                    Debug$.MODULE$.info(new StringAdd(this).$plus(": lost message"));
                                    break block7;
                                }
                                throw new MatchError(temp43.toString());
                            }
                            if (!(msg instanceof NamedSend)) break block9;
                            NamedSend temp56 = (NamedSend)msg;
                            Locator temp57 = temp56.senderLoc();
                            Locator temp58 = temp56.receiverLoc();
                            byte[] temp59 = temp56.data();
                            Symbol temp60 = temp56.session();
                            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": processing ")).append(temp56).toString());
                            temp47 = this.actors().get(temp58.name());
                            if (!(temp47 instanceof Some)) break block10;
                            Some temp48 = (Some)temp47;
                            OutputChannel temp49 = (OutputChannel)temp48.x();
                            this.liftedTree1$1(temp57, temp59, temp60, temp49);
                            break block7;
                        }
                        None$ none$ = None$.MODULE$;
                        if (none$ != null ? !none$.equals(temp47) : temp47 != null) break block11;
                        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": lost message"));
                    }
                    return;
                }
                throw new MatchError(temp47.toString());
            }
            throw new MatchError(msg.toString());
        }
    }

    public void registerProxy(Node senderNode, Symbol senderName, Proxy p) {
        HashMap<Tuple2<Node, Symbol>, Proxy> hashMap = this.proxies();
        synchronized (hashMap) {
            Option<Proxy> temp39;
            block7: {
                block6: {
                    Object object;
                    block5: {
                        temp39 = this.proxies().get(new Tuple2<Node, Symbol>(senderNode, senderName));
                        if (!(temp39 instanceof Some)) break block5;
                        object = BoxedUnit.UNIT;
                        break block6;
                    }
                    None$ none$ = None$.MODULE$;
                    if (none$ != null ? !none$.equals(temp39) : temp39 != null) break block7;
                    object = this.proxies().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(new Tuple2<Node, Symbol>(senderNode, senderName), p));
                }
                return;
            }
            throw new MatchError(temp39.toString());
        }
    }

    public Proxy getOrCreateProxy(Node senderNode, Symbol senderName) {
        HashMap<Tuple2<Node, Symbol>, Proxy> hashMap = this.proxies();
        synchronized (hashMap) {
            Option<Proxy> temp35;
            block6: {
                Proxy proxy;
                temp35 = this.proxies().get(new Tuple2<Node, Symbol>(senderNode, senderName));
                if (temp35 instanceof Some) {
                    Proxy temp37;
                    Some temp36 = (Some)temp35;
                    proxy = temp37 = (Proxy)temp36.x();
                } else {
                    None$ none$ = None$.MODULE$;
                    if (none$ != null ? !none$.equals(temp35) : temp35 != null) break block6;
                    proxy = this.createProxy(senderNode, senderName);
                }
                return proxy;
            }
            throw new MatchError(temp35.toString());
        }
    }

    public HashMap<Tuple2<Node, Symbol>, Proxy> proxies() {
        return this.proxies;
    }

    /*
     * WARNING - void declaration
     */
    public Proxy createProxy(Node node, Symbol sym) {
        void var3_3;
        Proxy p = new Proxy(node, sym, this);
        this.proxies().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(new Tuple2<Node, Symbol>(node, sym), p));
        return var3_3;
    }

    public void remoteApply(Node node, Symbol name, OutputChannel<Object> from2, Function2<AbstractActor, Proxy, Object> rfun) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(from2));
        Locator receiverLoc = new Locator(node, name);
        this.sendToNode(receiverLoc.node(), new RemoteApply0(senderLoc, receiverLoc, rfun));
    }

    public void forward(OutputChannel<Object> from2, Node node, Symbol name, Object msg, Symbol session) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(from2));
        Locator receiverLoc = new Locator(node, name);
        this.namedSend(senderLoc, receiverLoc, msg, session);
    }

    public void send(Node node, Symbol name, Object msg, Symbol session) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(Actor$.MODULE$.self()));
        Locator receiverLoc = new Locator(node, name);
        this.namedSend(senderLoc, receiverLoc, msg, session);
    }

    public void send(Node node, Symbol name, Object msg) {
        this.send(node, name, msg, symbol$1);
    }

    /*
     * WARNING - void declaration
     */
    public Symbol getOrCreateName(OutputChannel<Object> from2) {
        Option<Symbol> temp31;
        block4: {
            Symbol symbol;
            block3: {
                Symbol temp34;
                block2: {
                    void var2_3;
                    temp31 = this.names().get(from2);
                    None$ none$ = None$.MODULE$;
                    if (none$ != null ? !none$.equals(temp31) : temp31 != null) break block2;
                    Symbol freshName = FreshNameCreator$.MODULE$.newName("remotesender");
                    this.register(freshName, from2);
                    symbol = var2_3;
                    break block3;
                }
                if (!(temp31 instanceof Some)) break block4;
                Some temp33 = (Some)temp31;
                symbol = temp34 = (Symbol)temp33.x();
            }
            return symbol;
        }
        throw new MatchError(temp31.toString());
    }

    public void register(Symbol name, OutputChannel<Object> a) {
        synchronized (this) {
            this.actors().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(name, a));
            this.names().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(a, name));
            return;
        }
    }

    private HashMap<OutputChannel<Object>, Symbol> names() {
        return this.names;
    }

    private HashMap<Symbol, OutputChannel<Object>> actors() {
        return this.actors;
    }

    public void namedSend(Locator senderLoc, Locator receiverLoc, Object msg, Symbol session) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.sendToNode(receiverLoc.node(), new NamedSend(senderLoc, receiverLoc, bytes, session));
    }

    public void sendToNode(Node node, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.service.send(node, bytes);
    }
}

