/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.io.Serializable;
import java.math.BigInteger;
import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range$BigInt$;
import scala.math.BigDecimal;
import scala.math.BigInt$;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericConversions;
import scala.math.ScalaNumericConversions$class;
import scala.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigInt
extends ScalaNumber
implements ScalaNumericConversions,
ScalaObject,
Serializable {
    private final BigInteger bigInteger;

    public static final BigInt long2bigInt(long l) {
        return BigInt$.MODULE$.long2bigInt(l);
    }

    public static final BigInt int2bigInt(int n) {
        return BigInt$.MODULE$.int2bigInt(n);
    }

    public static final BigInt probablePrime(int n, Random random) {
        return BigInt$.MODULE$.probablePrime(n, random);
    }

    public static final BigInt apply(String string2, int n) {
        return BigInt$.MODULE$.apply(string2, n);
    }

    public static final BigInt apply(String string2) {
        return BigInt$.MODULE$.apply(string2);
    }

    public static final BigInt apply(int n, Random random) {
        return BigInt$.MODULE$.apply(n, random);
    }

    public static final BigInt apply(int n, int n2, Random random) {
        return BigInt$.MODULE$.apply(n, n2, random);
    }

    public static final BigInt apply(int n, byte[] byArray) {
        return BigInt$.MODULE$.apply(n, byArray);
    }

    public static final BigInt apply(byte[] byArray) {
        return BigInt$.MODULE$.apply(byArray);
    }

    public static final BigInt apply(long l) {
        return BigInt$.MODULE$.apply(l);
    }

    public static final BigInt apply(int n) {
        return BigInt$.MODULE$.apply(n);
    }

    public static final BigInt MaxLong() {
        return BigInt$.MODULE$.MaxLong();
    }

    public static final BigInt MinLong() {
        return BigInt$.MODULE$.MinLong();
    }

    public BigInt(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
        ScalaNumericConversions$class.$init$(this);
    }

    public byte[] toByteArray() {
        return this.bigInteger().toByteArray();
    }

    public String toString(int radix) {
        return this.bigInteger().toString(radix);
    }

    public String toString() {
        return this.bigInteger().toString();
    }

    public NumericRange.Inclusive<BigInt> to(BigInt end, BigInt step) {
        return Range$BigInt$.MODULE$.inclusive(this, end, step);
    }

    public NumericRange.Exclusive<BigInt> until(BigInt end, BigInt step) {
        return Range$BigInt$.MODULE$.apply(this, end, step);
    }

    @Override
    public double doubleValue() {
        return this.bigInteger().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public long longValue() {
        return this.bigInteger().longValue();
    }

    @Override
    public int intValue() {
        return this.bigInteger().intValue();
    }

    public char charValue() {
        return (char)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    public boolean isProbablePrime(int certainty) {
        return this.bigInteger().isProbablePrime(certainty);
    }

    public int bitCount() {
        return this.bigInteger().bitCount();
    }

    public int bitLength() {
        return this.bigInteger().bitLength();
    }

    public int lowestSetBit() {
        return this.bigInteger().getLowestSetBit();
    }

    public BigInt flipBit(int n) {
        return new BigInt(this.bigInteger().flipBit(n));
    }

    public BigInt clearBit(int n) {
        return new BigInt(this.bigInteger().clearBit(n));
    }

    public BigInt setBit(int n) {
        return new BigInt(this.bigInteger().setBit(n));
    }

    public boolean testBit(int n) {
        return this.bigInteger().testBit(n);
    }

    public BigInt $tilde() {
        return new BigInt(this.bigInteger().not());
    }

    public int signum() {
        return this.bigInteger().signum();
    }

    public BigInt abs() {
        return new BigInt(this.bigInteger().abs());
    }

    public BigInt unary_$minus() {
        return new BigInt(this.bigInteger().negate());
    }

    public BigInt modInverse(BigInt m) {
        return new BigInt(this.bigInteger().modInverse(m.bigInteger()));
    }

    public BigInt modPow(BigInt exp, BigInt m) {
        return new BigInt(this.bigInteger().modPow(exp.bigInteger(), m.bigInteger()));
    }

    public BigInt pow(int exp) {
        return new BigInt(this.bigInteger().pow(exp));
    }

    public BigInt max(BigInt that) {
        return new BigInt(this.bigInteger().max(that.bigInteger()));
    }

    public BigInt min(BigInt that) {
        return new BigInt(this.bigInteger().min(that.bigInteger()));
    }

    public BigInt mod(BigInt that) {
        return new BigInt(this.bigInteger().mod(that.bigInteger()));
    }

    public BigInt gcd(BigInt that) {
        return new BigInt(this.bigInteger().gcd(that.bigInteger()));
    }

    public BigInt $amp$tilde(BigInt that) {
        return new BigInt(this.bigInteger().andNot(that.bigInteger()));
    }

    public BigInt $up(BigInt that) {
        return new BigInt(this.bigInteger().xor(that.bigInteger()));
    }

    public BigInt $bar(BigInt that) {
        return new BigInt(this.bigInteger().or(that.bigInteger()));
    }

    public BigInt $amp(BigInt that) {
        return new BigInt(this.bigInteger().and(that.bigInteger()));
    }

    public BigInt $greater$greater(int n) {
        return new BigInt(this.bigInteger().shiftRight(n));
    }

    public BigInt $less$less(int n) {
        return new BigInt(this.bigInteger().shiftLeft(n));
    }

    public Tuple2<BigInt, BigInt> $div$percent(BigInt that) {
        BigInteger[] dr = this.bigInteger().divideAndRemainder(that.bigInteger());
        return new Tuple2<BigInt, BigInt>(new BigInt(dr[0]), new BigInt(dr[1]));
    }

    public BigInt $percent(BigInt that) {
        return new BigInt(this.bigInteger().remainder(that.bigInteger()));
    }

    public BigInt $div(BigInt that) {
        return new BigInt(this.bigInteger().divide(that.bigInteger()));
    }

    public BigInt $times(BigInt that) {
        return new BigInt(this.bigInteger().multiply(that.bigInteger()));
    }

    public BigInt $minus(BigInt that) {
        return new BigInt(this.bigInteger().subtract(that.bigInteger()));
    }

    public BigInt $plus(BigInt that) {
        return new BigInt(this.bigInteger().add(that.bigInteger()));
    }

    public boolean $greater(BigInt that) {
        return this.compare(that) > 0;
    }

    public boolean $less(BigInt that) {
        return this.compare(that) < 0;
    }

    public boolean $greater$eq(BigInt that) {
        return this.compare(that) >= 0;
    }

    public boolean $less$eq(BigInt that) {
        return this.compare(that) <= 0;
    }

    public int compare(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger());
    }

    public boolean equals(BigInt that) {
        return this.compare(that) == 0;
    }

    @Override
    public BigInteger underlying() {
        return this.bigInteger();
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    public boolean equals(Object that) {
        block7: {
            boolean bl;
            block4: {
                block5: {
                    block6: {
                        block2: {
                            block3: {
                                if (!(that instanceof BigInt)) break block2;
                                BigInt temp2 = (BigInt)that;
                                if (!true) break block3;
                                bl = this.equals(temp2);
                                break block4;
                            }
                            throw new MatchError(that.toString());
                        }
                        if (!(that instanceof BigDecimal)) break block5;
                        BigDecimal temp3 = (BigDecimal)that;
                        if (!true) break block6;
                        bl = temp3.toBigIntExact().exists(new $anonfun$equals$1(this));
                        break block4;
                    }
                    throw new MatchError(that.toString());
                }
                if (!true) break block7;
                bl = this.unifiedPrimitiveEquals(that);
            }
            return bl;
        }
        throw new MatchError(that.toString());
    }

    public int hashCode() {
        return this.$greater$eq(BigInt$.MODULE$.MinLong()) && this.$less$eq(BigInt$.MODULE$.MaxLong()) ? this.unifiedPrimitiveHashcode() : this.bigInteger().hashCode();
    }

    public BigInteger bigInteger() {
        return this.bigInteger;
    }

    public /* synthetic */ BigInt until$default$2() {
        return BigInt$.MODULE$.apply(1);
    }

    public /* synthetic */ BigInt to$default$2() {
        return BigInt$.MODULE$.apply(1);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericConversions$class.unifiedPrimitiveEquals(this, x);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericConversions$class.unifiedPrimitiveHashcode(this);
    }

    @Override
    public boolean isValidChar() {
        return ScalaNumericConversions$class.isValidChar(this);
    }

    @Override
    public boolean isValidInt() {
        return ScalaNumericConversions$class.isValidInt(this);
    }

    @Override
    public boolean isValidShort() {
        return ScalaNumericConversions$class.isValidShort(this);
    }

    @Override
    public boolean isValidByte() {
        return ScalaNumericConversions$class.isValidByte(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericConversions$class.toDouble(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericConversions$class.toFloat(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericConversions$class.toLong(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericConversions$class.toInt(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericConversions$class.toShort(this);
    }

    @Override
    public byte toByte() {
        return ScalaNumericConversions$class.toByte(this);
    }

    @Override
    public char toChar() {
        return ScalaNumericConversions$class.toChar(this);
    }
}

