/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.math.MathContext;
import scala.ScalaObject;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;

public final class BigDecimal$
implements ScalaObject {
    public static final BigDecimal$ MODULE$;
    public volatile int bitmap$0;
    private final MathContext defaultMathContext;
    private BigDecimal[] cache;
    private final int maxCached;
    private final int minCached;

    static {
        new BigDecimal$();
    }

    private BigDecimal$() {
        MODULE$ = this;
        this.minCached = -512;
        this.maxCached = 512;
        this.defaultMathContext = MathContext.UNLIMITED;
    }

    public BigDecimal double2bigDecimal(double d) {
        return this.valueOf(d, this.defaultMathContext());
    }

    public BigDecimal long2bigDecimal(long l) {
        return this.apply(l);
    }

    public BigDecimal int2bigDecimal(int i) {
        return this.apply(i);
    }

    public BigDecimal apply(java.math.BigDecimal bd, MathContext mc) {
        return new BigDecimal(bd, mc);
    }

    public BigDecimal apply(java.math.BigDecimal bd) {
        return this.apply(bd, this.defaultMathContext());
    }

    public BigDecimal apply(BigInt unscaledVal, int scale, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(unscaledVal.bigInteger(), scale, mc), mc);
    }

    public BigDecimal apply(BigInt unscaledVal, int scale) {
        return this.apply(unscaledVal, scale, this.defaultMathContext());
    }

    public BigDecimal apply(BigInt x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(x.bigInteger(), mc), mc);
    }

    public BigDecimal apply(BigInt x) {
        return this.apply(x, this.defaultMathContext());
    }

    public BigDecimal apply(String x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(x, mc), mc);
    }

    public BigDecimal apply(String x) {
        return this.apply(x, this.defaultMathContext());
    }

    public BigDecimal apply(char[] x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(x.toString(), mc), mc);
    }

    public BigDecimal apply(char[] x) {
        return this.apply(x, this.defaultMathContext());
    }

    public BigDecimal apply(double d, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(Double.toString(d), mc), mc);
    }

    public BigDecimal apply(double d) {
        return this.apply(d, this.defaultMathContext());
    }

    public BigDecimal apply(long unscaledVal, int scale, MathContext mc) {
        return this.apply(BigInt$.MODULE$.apply(unscaledVal), scale, mc);
    }

    public BigDecimal apply(long unscaledVal, int scale) {
        return this.apply(BigInt$.MODULE$.apply(unscaledVal), scale);
    }

    public BigDecimal apply(long l, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(l, mc), mc);
    }

    public BigDecimal apply(long l) {
        return (long)this.minCached() <= l && l <= (long)this.maxCached() ? this.apply((int)l) : new BigDecimal(java.math.BigDecimal.valueOf(l), this.defaultMathContext());
    }

    public BigDecimal apply(int i, MathContext mc) {
        BigDecimal bigDecimal;
        if (this.minCached() <= i && i <= this.maxCached()) {
            int offset = i - this.minCached();
            BigDecimal n = this.cache()[offset];
            if (n == null) {
                this.cache()[offset] = n = new BigDecimal(java.math.BigDecimal.valueOf(i), mc);
            }
            bigDecimal = n;
        } else {
            bigDecimal = new BigDecimal(java.math.BigDecimal.valueOf(i), mc);
        }
        return bigDecimal;
    }

    public BigDecimal apply(int i) {
        return this.apply(i, this.defaultMathContext());
    }

    public BigDecimal valueOf(double d, MathContext mc) {
        return this.apply(java.math.BigDecimal.valueOf(d), mc);
    }

    public BigDecimal valueOf(double d) {
        return this.apply(java.math.BigDecimal.valueOf(d));
    }

    public MathContext defaultMathContext() {
        return this.defaultMathContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal[] cache() {
        if ((this.bitmap$0 & 1) != 0) return this.cache;
        BigDecimal$ bigDecimal$ = this;
        synchronized (bigDecimal$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.cache = new BigDecimal[this.maxCached() - this.minCached() + 1];
                this.bitmap$0 |= 1;
            }
            return this.cache;
        }
    }

    private int maxCached() {
        return this.maxCached;
    }

    private int minCached() {
        return this.minCached;
    }
}

