/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.text.MessageFormat;
import java.util.Locale;
import org.sakaiproject.util.ResourceLoader;
import org.springframework.context.support.AbstractMessageSource;

public class ResourceLoaderMessageSource
extends AbstractMessageSource {
    ResourceLoader resourceLoader;

    public void setBasename(String baseName) {
        if (baseName.startsWith("classpath:")) {
            baseName = baseName.replaceFirst("classpath:", "");
            baseName = baseName.replaceAll("/", ".");
        }
        this.resourceLoader = new ResourceLoader(baseName);
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        this.resourceLoader.setContextLocale(locale);
        String msg = this.resourceLoader.getString(code);
        return this.createMessageFormat(msg, locale);
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        this.resourceLoader.setContextLocale(locale);
        return this.resourceLoader.getString(code);
    }

    public void setCacheSeconds(int secs) {
    }
}

