/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;

public class RemoteHostFilter
implements Filter {
    private static Log M_log = LogFactory.getLog(RemoteHostFilter.class);
    private static final Pattern[] EMPTY_PATTERN = new Pattern[0];
    protected String allowList = null;
    protected String denyList = null;
    protected Pattern[] allow = EMPTY_PATTERN;
    protected Pattern[] deny = EMPTY_PATTERN;
    protected boolean logAllowed = false;
    protected boolean logDenied = true;

    public void init(FilterConfig config) throws ServletException {
        this.allowList = this.getParameter(config, "allow");
        if (":empty:".equals(this.allowList)) {
            this.allowList = null;
        }
        this.allow = this.getRegExPatterns(this.allowList);
        this.logAllowed = Boolean.valueOf(this.getParameter(config, "log-allowed"));
        this.denyList = this.getParameter(config, "deny");
        if (":empty:".equals(this.denyList)) {
            this.denyList = null;
        }
        this.deny = this.getRegExPatterns(this.denyList);
        this.logDenied = Boolean.valueOf(this.getParameter(config, "log-denied"));
    }

    private String getParameter(FilterConfig config, String parmName) {
        String retval = ServerConfigurationService.getString((String)("webservices." + parmName), null);
        if (retval != null) {
            return retval;
        }
        return config.getInitParameter(parmName);
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        int i;
        if (!(sreq instanceof HttpServletRequest) || !(sres instanceof HttpServletResponse)) {
            chain.doFilter(sreq, sres);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)sreq;
        HttpServletResponse response = (HttpServletResponse)sres;
        String host = request.getRemoteHost();
        String addr = request.getRemoteAddr();
        for (i = 0; i < this.deny.length; ++i) {
            if (!this.deny[i].matcher(host).matches() && !this.deny[i].matcher(addr).matches()) continue;
            if (this.logDenied && M_log.isInfoEnabled()) {
                M_log.info((Object)("Access denied (" + this.deny[i].pattern() + "): " + host + "/" + addr));
            }
            response.sendError(403);
            return;
        }
        for (i = 0; i < this.allow.length; ++i) {
            if (!this.allow[i].matcher(host).matches() && !this.allow[i].matcher(addr).matches()) continue;
            if (this.logAllowed && M_log.isInfoEnabled()) {
                M_log.info((Object)("Access granted (" + this.allow[i].pattern() + "): " + host + "/" + addr));
            }
            chain.doFilter(sreq, sres);
            return;
        }
        if (this.deny.length > 0 && this.allow.length == 0) {
            if (this.logAllowed && M_log.isInfoEnabled()) {
                M_log.info((Object)("Access granted (implicit): " + host + "/" + addr));
            }
            chain.doFilter(sreq, sres);
            return;
        }
        if (this.logDenied && M_log.isInfoEnabled()) {
            M_log.info((Object)("Access denied (implicit): " + host + "/" + addr));
        }
        response.sendError(403);
    }

    public void destroy() {
    }

    protected Pattern[] getRegExPatterns(String list) {
        if (list == null) {
            return EMPTY_PATTERN;
        }
        if ((list = list.trim()).length() < 1) {
            return EMPTY_PATTERN;
        }
        StringTokenizer st = new StringTokenizer(list, ",");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            try {
                patterns.add(Pattern.compile(token, 2));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Illegal Regular Expression Syntax: [" + token + "] - " + e.getMessage());
            }
        }
        return patterns.toArray(EMPTY_PATTERN);
    }
}

