/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.IntRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.util.Resource;

public class PasswordCheck {
    public static final int VERY_STRONG = 5;
    public static final int STRONG = 4;
    public static final int MEDIOCRE = 3;
    public static final int WEAK = 2;
    public static final int VERY_WEAK = 1;
    public static final int NONE = 0;
    private static Log log = LogFactory.getLog(Resource.class);

    public static int getPasswordStrength(String passwd) {
        int upper = 0;
        int lower = 0;
        int numbers = 0;
        int special = 0;
        int length = 0;
        int strength = 0;
        if (StringUtils.isBlank((String)passwd)) {
            log.debug((Object)"Password null");
            return 0;
        }
        length = passwd.length();
        if (length < 5) {
            strength += 3;
            log.debug((Object)("3 points for length (" + length + ")"));
        } else if (length > 4 && passwd.length() < 8) {
            strength += 6;
            log.debug((Object)("6 points for length (" + length + ")"));
        } else if (length > 7 && passwd.length() < 16) {
            strength += 12;
            log.debug((Object)("12 points for length (" + length + ")"));
        } else if (length > 15) {
            strength += 18;
            log.debug((Object)("18 points for length (" + length + ")"));
        }
        Pattern p = Pattern.compile(".??[a-z]");
        Matcher m = p.matcher(passwd);
        while (m.find()) {
            ++lower;
        }
        if (lower > 0) {
            ++strength;
            log.debug((Object)"1 point for a lower case character");
        }
        p = Pattern.compile(".??[A-Z]");
        m = p.matcher(passwd);
        while (m.find()) {
            ++upper;
        }
        if (upper > 0) {
            strength += 5;
            log.debug((Object)"5 points for an upper case character");
        }
        p = Pattern.compile(".??[0-9]");
        m = p.matcher(passwd);
        while (m.find()) {
            ++numbers;
        }
        if (numbers > 0) {
            strength += 5;
            log.debug((Object)"5 points for a number");
            if (numbers > 1) {
                strength += 2;
                log.debug((Object)"2 points for at least two numbers");
                if (numbers > 2) {
                    strength += 3;
                    log.debug((Object)"3 points for at least three numbers");
                }
            }
        }
        p = Pattern.compile(".??[:,!,@,#,$,%,^,&,*,?,_,~]");
        m = p.matcher(passwd);
        while (m.find()) {
            ++special;
        }
        if (special > 0) {
            strength += 5;
            log.debug((Object)"5 points for a special character");
            if (special > 1) {
                strength += strength + 5;
                log.debug((Object)"5 points for at least two special characters");
            }
        }
        if (upper > 0 && lower > 0) {
            strength += 2;
            log.debug((Object)"2 combo points for upper and lower letters");
        }
        if ((upper > 0 || lower > 0) && numbers > 0) {
            strength += 2;
            log.debug((Object)"2 combo points for letters and numbers");
        }
        if ((upper > 0 || lower > 0) && numbers > 0 && special > 0) {
            strength += 2;
            log.debug((Object)"2 combo points for letters, numbers and special chars");
        }
        if (upper > 0 && lower > 0 && numbers > 0 && special > 0) {
            strength += 2;
            log.debug((Object)"2 combo points for upper and lower case letters, numbers and special chars");
        }
        if (strength < 16) {
            log.debug((Object)"very weak");
            return 1;
        }
        if (strength > 15 && strength < 25) {
            log.debug((Object)"weak");
            return 2;
        }
        if (strength > 24 && strength < 35) {
            log.debug((Object)"mediocre");
            return 3;
        }
        if (strength > 34 && strength < 45) {
            log.debug((Object)"strong");
            return 4;
        }
        log.debug((Object)"very strong");
        return 5;
    }

    public static boolean isAcceptableLength(String passwd, int min, int max) {
        int length;
        IntRange range;
        if (StringUtils.isBlank((String)passwd)) {
            return false;
        }
        if (min > max) {
            log.error((Object)("Invalid bounds supplied, min (" + min + ") is greater than max (" + max + ")"));
        }
        if ((range = new IntRange(min, max)).containsInteger(length = passwd.length())) {
            log.debug((Object)"Range ok");
            return true;
        }
        log.debug((Object)("Range bad; min=" + min + ", max=" + max + ", length=" + length));
        return false;
    }
}

